#pragma once

#include <C2/lm/vector3.h>

#include "Mesh/BaseMesh.h"
#include "Shape.h"



namespace lib_geo
{


class CSEdge
{
public:
	CSEdge(void) :
		vid0(-1),
		vid1(-1),
		eid(-1)
	{
	}

	void Set(int _vid0, int _vid1, int _eid)
	{
		vid0 = _vid0;
		vid1 = _vid1;
		eid  = _eid ;
	}

public:
	int vid0, vid1;
	int eid;
};


class CSFace
{
public:
	int parent_fid;
	CSEdge edges[3];
};


class CSCache
{
public:
	CSCache(void);
	void GetTwoEdgeCS(int& leid0, int& leid1);
	void GetTriangleDisq(float& d01, float& d12, float& d20);
	void GetCloseDist(int& base_leid, int& sub_leid0, int& sub_leid1);
	void GetLid(int& lid);

	void CalcFace(const BaseMesh& mesh, const CSFace& cf, const Plane& cutplane);

public:
	// fʂƌĂGbWidxƖ{ƒfʂƂ̌ʒu
	int NumEdgeInter;
	bool IsEdgeIntersect[3];
	lm::vec3f InterPos[3];

	// [_fʏɏĂGbWidxƂ̖{
	int NumEdgeOnface;
	bool IsEdgeOnface[3];
};


}
