#pragma once

#include "GlInclude.h"


namespace lib_gl
{


// -----------------------------------------------------------------------------------------------
//! Viewport
class Viewport
{
public:
	Viewport(void) 
		: Left(0) , Bottom(0)
		, Width(0) , Height(0)
		, Visible(true)
	{}

	Viewport( int i_left , int i_bottom , int i_width , int i_height )
		: Left( i_left ) , Bottom( i_bottom )
		, Width( i_width ) , Height( i_height )
		, Visible(true)
	{}

	//! n_(  ) ̈ʒuݒ肷.
	void SetLeftBottom( int i_left , int i_bottom );
	//! TCY( Ɖ ) ݒ肷.
	void SetWidthHeight( int i_width , int i_height );
	//! n_ƃTCYݒ肷.
	void SetViewport( int i_left , int i_bottom , int i_width , int i_height );

	//! n_(  ) ̈ʒu擾.
	void GetLefBottom( int& o_left , int& o_bottom ) const;
	//! TCY( Ɖ ) 擾.
	void GetWidthHeight( int& o_width , int& o_height ) const;
	//! n_ƃTCY擾.
	void GetViewport( int& o_left , int& o_bottom , int& o_width , int& o_height ) const;

	//! TCY񂪓Kׂ.
	//! @retval true  - ʐς0ȏ
	//! @retval false - ʐς0
	bool IsValidView(void) const;

	//! AXyNgԂ ( == GetAspectWH() )
	float GetAspect(void) const;
	//! AXyNgԂ (  /  )
	float GetAspectWH(void) const;
	//! AXyNgԂ (  /  )
	float GetAspectHW(void) const;

	void SetGLViewport(void);
	void SetGLScissor(void);

	//! ݂̃r[|[gɑ΂r{[h̓esZbg
	void SetGLBillboardMatrix(bool invert_vertical);

	//! w肳ꂽWr[|[gɊ܂܂邩ǂ\
	bool Contains( int i_x , int i_y ) const;

	//! GLint[4]ɕϊ
	void GetGlArray( GLint* o_array ) const;

	int GetRight(void) const { return Left + Width; }
	int GetTop(void) const { return Bottom + Height; }


public:
	int Left;
	int Bottom;
	int Width;
	int Height;

	bool Visible; //!< \A\\
};



// -----------------------------------------------------------------------------------------------

inline
void Viewport::SetLeftBottom( int i_left , int i_bottom )
{
	Left    = i_left;
	Bottom  = i_bottom;
}

inline
void Viewport::SetWidthHeight( int i_width , int i_height )
{
	Width  = i_width;
	Height = i_height;
}

inline
void Viewport::SetViewport( int i_left , int i_bottom , int i_width , int i_height )
{
	Left   = i_left;
	Bottom = i_bottom;
	Width  = i_width;
	Height = i_height;
}

inline
void Viewport::GetLefBottom( int& o_left , int& o_bottom ) const
{
	o_left   = Left;
	o_bottom = Bottom;
}

inline
void Viewport::GetWidthHeight( int& o_width , int& o_height ) const
{
	o_width  = Width;
	o_height = Height;
}

inline
void Viewport::GetViewport( int& o_left , int& o_bottom , int& o_width , int& o_height ) const
{
	o_left   = Left;
	o_bottom = Bottom;
	o_width  = Width;
	o_height = Height;
}


inline
bool Viewport::IsValidView(void) const
{
	if( Width  == 0 ) return false;
	if( Height == 0 ) return false;
	return true;
}

inline
float Viewport::GetAspect(void) const
{
	return GetAspectWH();
}

inline
float Viewport::GetAspectWH(void) const
{
	if( Height == 0 ) return 0.0f;
	return static_cast<float>(Width) / static_cast<float>(Height);
}

inline
float Viewport::GetAspectHW(void) const
{
	if( Width == 0 ) return 0.0f;
	return static_cast<float>(Height) / static_cast<float>(Width);
}

inline
void Viewport::SetGLViewport(void)
{
	glViewport( Left , Bottom , Width , Height );
}

inline
void Viewport::SetGLScissor(void)
{
	glScissor( Left , Bottom , Width , Height );
}


inline
void Viewport::SetGLBillboardMatrix(bool invert_vertical)
{
	glPushAttrib( GL_TRANSFORM_BIT );

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	if( invert_vertical )
		glOrtho( 0.0 , (GLdouble)Width , (GLdouble)Height , 0.0 , 1.0 , -1.0 );
	else
		glOrtho( 0.0 , (GLdouble)Width , 0.0 , (GLdouble)Height , 1.0 , -1.0 );

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glPopAttrib();
}


inline
bool Viewport::Contains( int i_x , int i_y ) const
{
	if( i_x < Left   ) return false;
	if( i_y < Bottom ) return false;
	if( i_x > ( Left   + Width - 1 ) ) return false;
	if( i_y > ( Bottom + Height -1 ) ) return false;

	return true;
}


inline
void Viewport::GetGlArray( GLint* o_array ) const
{
	o_array[0] = static_cast<GLint>( Left   );
	o_array[1] = static_cast<GLint>( Bottom );
	o_array[2] = static_cast<GLint>( Width  );
	o_array[3] = static_cast<GLint>( Height );
}


}
