#pragma once

#include "Shader/ShaderInterface.h"


class DefaultShader;
class ConstantShader;
class PhongShader;
class CustomShader;
class NormalColorShader;
class DepthColorShader;
class ShadowMap;
class EnvMap;
class IntegrateShader;
class MatcapShader;



enum class ShaderType
{
	None,
	Constant,
	Default,
	Phong,
	Custom,
	NormalColor,
	DepthColor,
	Shadowmap,
	Envmap,
	Integrate,
	Matcap,
};


class ShaderLibrary
{
public:
	ShaderLibrary(ShaderContext* context) :
		m_Context(context)
	{
	}

	void ReleaseAllShaders(void);

	std::string GetShaderLibDir(void) const;

	ShaderInterface* GetShader(ShaderType t);

	DefaultShader*      GetDefaultShader(void);
	ConstantShader*     GetConstantShader(void);
	PhongShader*        GetPhongShader(void);
	CustomShader*       GetCustomShader(void);
	NormalColorShader*  GetNormalColorShader(void);
	DepthColorShader*   GetDepthColorShader(void);
	ShadowMap*          GetShadowmapShader(void);
	EnvMap*             GetEnvmapShader(void);
	IntegrateShader*    GetIntegrateShader(void);
	MatcapShader*       GetMatcapShader(void);

	static const char* GetTypeToName(ShaderType type);
	static ShaderType GetNameToType(const char* name);

private:
	ShaderContext* m_Context;

	std::shared_ptr< DefaultShader     > m_DefaultShader;
	std::shared_ptr< ConstantShader    > m_ConstantShader;
	std::shared_ptr< PhongShader       > m_PhongShader;
	std::shared_ptr< CustomShader      > m_CustomShaer;
	std::shared_ptr< NormalColorShader > m_NormalColorShader;
	std::shared_ptr< DepthColorShader  > m_DepthColorShader;
	std::shared_ptr< ShadowMap         > m_ShadowMapShader;
	std::shared_ptr< EnvMap            > m_EnvMapShader;
	std::shared_ptr< IntegrateShader   > m_IntegrateShader;
	std::shared_ptr< MatcapShader      > m_MatcapShader;
};
