#pragma once

#include <C2/lm/matrix4.h>

#include "ShaderInterface.h"

#include "../ShadowBuffer.h"



class ShadowMap : public ShaderInterface
{
public:
	ShadowMap(ShaderContext* context);

	const char* GetShaderName(void)
	{
		return "ShadowMap";
	}

	bool Initialize(const std::string& shader_libdir);

	virtual void BeginShader(void);
	virtual void EndShader(void);

	void UpdateShadowMatrix(void);

	virtual bool IsRequireShadowBuf(void) const
	{
		return true;
	}

	virtual void SetTextureEnabled(bool enabled);
	virtual void SetDublesideEnabled(bool enabled);
	virtual void SetLightingEnabled(bool enabled);


private:
	bool InitializeShader(const std::string& shader_libdir);

private:
	lib_gl::GlslProgram m_Shader;
};
