#pragma once

#include <C2/lm/matrix4.h>

#include "ShaderInterface.h"



class IntegrateShader : public ShaderInterface
{
public:
	IntegrateShader(ShaderContext* context);

	const char* GetShaderName(void)
	{
		return "IntegrateShader";
	}

	bool Initialize(const std::string& shader_libdir);

	virtual void BeginShader(void);
	virtual void EndShader(void);

	virtual bool IsRequireShadowBuf(void) const
	{
		return true;
	}

	virtual void SetTextureEnabled(bool enabled);
	virtual void SetTextureSpecularSeparate(bool enabled);

	virtual void SetDublesideEnabled(bool enabled);
	virtual void SetLightingEnabled(bool enabled);
	virtual void SetFlatShade(bool enable_flat);

	virtual void SetMatcap(gl::MatcapImage* matcap);

	virtual void SetShadowmap(ShadowBuffer* shadow);

private:
	bool InitializeShader(const std::string& shader_libdir);

	GLint GetLoc(const GLchar* name);

private:
	lib_gl::GlslProgram m_Shader;
};
