#include "StdAfx.h"
#include "EnvMap.h"

#include <LibTest/DebugStream.h>

#include "../ShaderUtil.h"



EnvMap::EnvMap(ShaderContext* context) :
	ShaderInterface(context)
{
}



bool EnvMap::InitializeShader(const std::string& shader_libdir)
{
	std::string vert_filename = shader_libdir + "env_map.vert";
	std::string frag_filename = shader_libdir + "env_map.frag";

	return ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}

void EnvMap::BeginShader(void)
{
	m_Shader.BeginShader();

	SceneMain* scene = m_Context->m_Scene;

	glActiveTexture(GL_TEXTURE2);
	scene->m_EnvImg.BindTexture();

	glActiveTexture(GL_TEXTURE0);

	glUniform1i(m_Shader.GetUniformLocation("tex_color"), 0);
	glUniform1i(m_Shader.GetUniformLocation("tex_envmap"), 2);

	glUniform1i(m_Shader.GetUniformLocation("enable_envmap"), scene->m_EnvImg.m_IsEnableReflection);

	lm::matrix4f mat;
	scene->m_WorldTransform.GetRotateMatrix(mat);
	glUniformMatrix4fv(m_Shader.GetUniformLocation("scene_mat"), 1, GL_FALSE, &mat[0]);

	glUniform1f(m_Shader.GetUniformLocation("env_reflection"), scene->m_EnvImg.m_EnvReflection);
}

void EnvMap::EndShader(void)
{
	m_Shader.EndShader();
}


void EnvMap::SetTextureEnabled(bool enabled)
{
	glUniform1i( m_Shader.GetUniformLocation( "enable_texture" ) , enabled ? 1 : 0 );
}

void EnvMap::SetDublesideEnabled(bool enabled)
{
	glUniform1i( m_Shader.GetUniformLocation( "enable_doubleside" ) , enabled ? 1 : 0 );
}

void EnvMap::SetLightingEnabled(bool enabled)
{
	glUniform1i( m_Shader.GetUniformLocation( "enable_lighting" ) , enabled ? 1 : 0 );
}
