#pragma once

#include <QDialog>
#include "ui_MatcapSelectDlg.h"

class MatcapSelectDlg : public QDialog
{
	Q_OBJECT

signals:
	void ListSelectChanged();

public:
	MatcapSelectDlg(QWidget *parent = 0);
	~MatcapSelectDlg();

	bool RebuildList(void);

	QString GetSelectedItemPath(void) const;

	QString GetImageDirPath(void) const;

private:
	void InitGroups(void);

	bool RebuildListMain(void);
	void GetPresetFiles(const QString& dirpath, QStringList& files);

private slots:
	void on_buttonBox_accepted();
	void on_buttonBox_rejected();

	void on_listImages_currentItemChanged(QListWidgetItem *current, QListWidgetItem *previous);

	void on_comboDataGroup_currentIndexChanged(int index);

private:
	Ui::MatcapSelectDlg ui;

	QString m_CurrentGroup;
};
