import sys
sys.path.append('../PythonLib')

from IOUtil import *
from CollectLib import *


def makeDirs(OutDir):
	createPathIfnotExist(OutDir)
	createPathIfnotExist(OutDir + 'Data/')
	createPathIfnotExist('Res/')
	createPathIfnotExist('translations/')

def copyResources(OutDir):
	copyFiles('../QtGeoViewer/BuildInfo.h', 'Res/')
	copyFiles('../QtGeoViewer/Version.rc', 'Res/')
	createPathIfnotExist(OutDir + 'translations/')
	copyFiles('../QtGeoViewer/translations/*.qm', OutDir + 'translations/')

def copyBuildFiles(OutDir):
	InDir = '../Win32/Release/'
	copyFiles(InDir + '*.exe', OutDir)
	copyFiles(InDir + '*.dll', OutDir)
	copyFiles('../DependsLibraries.txt', OutDir)

def copyShader(OutDir):
	ShaderOutDir = OutDir + 'ShaderCode/'
	createPathIfnotExist(ShaderOutDir)
	createPathIfnotExist(ShaderOutDir + 'Mesh/')
	createPathIfnotExist(ShaderOutDir + 'Postproc/')
	ShaderInDir = '../QtGeoViewer/ShaderCode/'
	copyFiles(ShaderInDir + 'Mesh/*.frag', ShaderOutDir + 'Mesh/')
	copyFiles(ShaderInDir + 'Mesh/*.vert', ShaderOutDir + 'Mesh/')
	copyFiles(ShaderInDir + 'Postproc/*.frag', ShaderOutDir + 'Postproc/')
	copyFiles(ShaderInDir + 'Postproc/*.vert', ShaderOutDir + 'Postproc/')

def copyMatcap(OutDir):
	createPathIfnotExist(OutDir + 'Data/matcaps/')
	createPathIfnotExist(OutDir + 'Data/matcaps/blender/')
	copyFiles('../Data/matcaps/blender/*.*', OutDir + 'Data/matcaps/blender/')
	createPathIfnotExist(OutDir + 'Data/matcaps/Proton/')
	copyFiles('../Data/matcaps/Proton/*.*', OutDir + 'Data/matcaps/Proton/')

def copyDefaultConfig(OutDir, isFullmode):
	configOut = OutDir + 'Data/DefaultConfig/'
	rootDir = '../Data/DefaultConfig/'
	createPathIfnotExist(configOut)
	copyFiles(rootDir + 'layout.dat', configOut)
	if (isFullmode):
		copyFiles(rootDir + 'gui_config_full.xml', configOut + 'gui_config.xml')
	else:
		copyFiles(rootDir + 'gui_config.xml', configOut + 'gui_config.xml')

def copyVCRuntime(OutDir):
	VSDir = 'C:/Program Files (x86)/Microsoft Visual Studio 11.0/'
	Redist86 = VSDir + 'VC/redist/x86/'
	copyFiles(Redist86 + 'Microsoft.VC110.CRT/msvcp110.dll', OutDir);
	copyFiles(Redist86 + 'Microsoft.VC110.CRT/msvcr110.dll', OutDir);

OutDir = 'Release/'

isFullmode = False
if (len(sys.argv) == 2):
	if (sys.argv[1] == "FULL"):
		isFullmode = True

print("FullMode : " + str(isFullmode))

makeDirs(OutDir)
copyResources(OutDir)
copyBuildFiles(OutDir)
copyShader(OutDir)
copyMatcap(OutDir)
copyDefaultConfig(OutDir, isFullmode)
copyAssimpLibs(OutDir)
copyGLLibs(OutDir)
copySDLLibs(OutDir)
copyPythonLibs(OutDir)
copyQtLibs(OutDir)
copyVCRuntime(OutDir)
