#include "stdafx.h"
#include "BaseMeshPrimitives.h"



namespace lib_geo
{


// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// BaseEdge

void BaseEdge::Clear(void)
{
	m_VertIds[0] = -1;
	m_VertIds[1] = -1;

	ClearAdjBuffer();
}

void BaseEdge::ClearAdjBuffer(void)
{
	m_AdjFids.clear();
}

std::pair<int,int> BaseEdge::ToIntPair(void) const
{
	if( m_VertIds[0] > m_VertIds[1] )
		return std::pair<int,int>( m_VertIds[1] , m_VertIds[0] );
	else
		return std::pair<int,int>( m_VertIds[0] , m_VertIds[1] );
}


// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// BaseFace

//! Sobt@NA
void BaseFace::Clear(void)
{
	m_VertIds.clear();
	m_NormIds.clear();
	m_UVIds.clear();

	ClearAdjBuffer();

	ClearMatIdx();
}

void BaseFace::ClearAdjBuffer(void)
{
	m_AdjEids.clear();
}

void BaseFace::ClearMatIdx(void)
{
	m_MatIdx = -1;
}

size_t BaseFace::NumVertices(void) const
{
	return m_VertIds.size();
}

size_t BaseFace::NumTriangles(void) const
{
	size_t num_verts = m_VertIds.size();
	if( num_verts < 3 ) return 0;
	return num_verts - 2;
}

// ʒuȊO̗vfĂ邩mF.
bool BaseFace::HasNormal(void) const
{
	return !m_NormIds.empty();
}

bool BaseFace::HasUV(void) const
{
	return !m_UVIds.empty();
}


bool BaseFace::VerifyElementCounts(void) const
{
	// _IDɑp`\. ̗vf͊p̑\
	if( m_VertIds.empty() )
	{
		if( !m_NormIds.empty() ) return false;
		if( !m_UVIds.empty()   ) return false;
	}
	else
	{
		if( !m_NormIds.empty() )
		{
			if( m_VertIds.size() != m_NormIds.size() ) return false;
			if( m_UVIds.size() != m_UVIds.size() ) return false;
		}
	}

	return true;
}


// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// VertAdj

void VertAdj::ClearAdjBuffer(void)
{
	m_AdjEids.clear();
	m_AdjFids.clear();

	m_NormalAvg.set(0.0f, 0.0f, 0.0f);
}


// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// BasePolyline

void BasePolyline::Clear(void)
{
	m_VertIds.clear();
}

void BasePolyline::Swap(BasePolyline& pl)
{
	pl.m_VertIds.swap(m_VertIds);
}


}
