#pragma once

#ifdef OPENGLUT


#include "OpenGlutStringSigned.h"

#include <C2/lm/vector2.h>
#include <C2/lm/vector3.h>

#include <sstream>



//! ʒuwt̕`
inline void glutStrokeString3f(const lm::vec3f& pos, void* font, const char* string)
{
	glRasterPos3f(pos.x, pos.y, pos.z);
	glutStrokeString(font, string);
}

//! ʒuwt̕`
inline void glutStrokeString2f(const lm::vec2f& pos, void* font, const char* string)
{
	glRasterPos2f(pos.x, pos.y);
	glutStrokeString(font, string);
}

//! l𕶎񉻂ĕ`
template<typename T>
inline void glutStrokeStringVal(void* font, const T& val)
{
	std::ostringstream s;
	s << val;
	glutStrokeString(font, s.str().c_str());
}

//! ʒuwt̒lo
template<typename T>
inline void glutStrokeStringVal3f(const lm::vec3f& pos, void* font, const T& val)
{
	glRasterPos3f(pos.x, pos.y, pos.z);
	glutStrokeStringVal(font, val);
}

//! ʒuwt̒lo
template<typename T>
inline void glutStrokeStringVal2f(const lm::vec2f& pos, void* font, const T& val)
{
	glRasterPos2f(pos.x, pos.y);
	glutStrokeStringVal(font, val);
}


//! ftHgtHggp`
inline void glutStrokeString(const char* string)
{
	glutStrokeString(GLUT_BITMAP_HELVETICA_18, string);
}

//! ʒuwt̃ftHgtHggp`
inline void glutStrokeString3f(const lm::vec3f& pos, const char* string)
{
	glutStrokeString3f(pos, GLUT_BITMAP_HELVETICA_18, string);
}

//! ʒuwt̃ftHgtHggp`
inline void glutStrokeString2f(const lm::vec2f& pos, const char* string)
{
	glutStrokeString2f(pos, GLUT_BITMAP_HELVETICA_18, string);
}

template<typename T>
inline void glutStrokeStringVal(const T& val)
{
	glutStrokeStringVal(GLUT_BITMAP_HELVETICA_18, val);
}

template<typename T>
inline void glutStrokeStringVal3f(const lm::vec3f& pos, const T& val)
{
	glutStrokeStringVal3f(pos, GLUT_BITMAP_HELVETICA_18, val);
}

template<typename T>
inline void glutStrokeStringVal2f(const lm::vec2f& pos, const T& val)
{
	glutStrokeString2f(pos, GLUT_BITMAP_HELVETICA_18, val);
}


inline void glutStrokeBillboardString(int view_width, int view_height, int line, void* font, const char* string)
{
	glPushAttrib(GL_TRANSFORM_BIT|GL_ENABLE_BIT);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	float half_w = view_width * 0.5f;
	float half_h = view_height * 0.5f;
	glOrtho( -half_w , half_w , -half_h , half_h , 0 , 1 );

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	lm::vec2f pos(-half_w + 10, half_h - 20 * (line + 1));
	glutStrokeString2f(pos, string);

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	glPopAttrib();
}

inline void glutStrokeBillboardString(int view_width, int view_height, int line, const char* string)
{
	glutStrokeBillboardString(view_width, view_height, line, GLUT_BITMAP_HELVETICA_18, string);
}

template<typename T>
inline void glutStrokeBillboardStringVal(int view_width, int view_height, int line, const T& val)
{
	std::ostringstream s;
	s << val;
	glutStrokeBillboardString(view_width, view_height, line, GLUT_BITMAP_HELVETICA_18, s.str().c_str());
}


#endif
