#!/bin/bash

#usage: REV4=b44c SUFFIX=rc2 /path/to/create_patch_153.sh

set -uex

echo REV4: $REV4
echo SUFFIX: $SUFFIX

# Unzip all
for f in $(ls *.zip); do
  echo $f
  unzip $f
done

no_exit_diff()
{
    set +e
    diff $@
    set -e
}

# Create patch packages
no_exit_diff -urN pukiwiki-1.5.2_utf8 pukiwiki-1.5.3_utf8 > update_pukiwiki_152to153_utf8.patch
no_exit_diff -urN pukiwiki-1.5.2_eucjp pukiwiki-1.5.3_eucjp > update_pukiwiki_152to153_eucjp.patch
zip update_pukiwiki_152to153_utf8.patch.zip update_pukiwiki_152to153_utf8.patch
zip update_pukiwiki_152to153_eucjp.patch.zip update_pukiwiki_152to153_eucjp.patch
cp -p update_pukiwiki_152to153_utf8.patch.zip update_pukiwiki_152to153${SUFFIX}-${REV4}_utf8.patch.zip
cp -p update_pukiwiki_152to153_eucjp.patch.zip update_pukiwiki_152to153${SUFFIX}-${REV4}_eucjp.patch.zip

