	/*
 *  psychlops_io_display_Win32.h
 *  Psychlops Standard Library (Win32)
 *
 *  Last Modified 2009/03/02 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */


#include <string>
#include <windows.h>
#include "../../core/graphic/psychlops_g_canvas.h"



namespace Psychlops {

	typedef std::vector<Display> Displays;

	class APIDisplayProperties {
	private:
		static BOOL CALLBACK DisplayEnumProc(HMONITOR hMonitor, HDC hdcMonitor, LPRECT lprcMonitor, LPARAM dwData);
		static Displays displays;

	public:
		int gamma_mode_;
		HMONITOR monitor_;
		HDC display_;
		int primary_;
		DEVMODE mode_, original_mode_;
		enum { RAMP_STEPS_ = 256 };
		struct GAMMA_RAMP_TABLE {
			WORD r[RAMP_STEPS_];
			WORD g[RAMP_STEPS_];
			WORD b[RAMP_STEPS_];
		};
		GAMMA_RAMP_TABLE savedGammaRamp_;
		LPVOID savedGammaRamp_ptr_;


		static Displays emumDisplays();
//		void* native();

		APIDisplayProperties();
		~APIDisplayProperties();

		void getInfo(int &width, int &height, int &color_depth, double &refresh_rate, std::string& name, Rectangle& area);
/*		void setGammaValue(const double gamma_r, const double gamma_g, const double gamma_b);
		void setGammaTable(const std::vector<double> &table_r, const std::vector<double> &table_g, const std::vector<double> &table_b);
		void setGammaTable(const CGGammaValue * const table_r, const CGGammaValue * const table_g, const CGGammaValue * const table_b, const int num_steps);
		void saveGammaValue();
		void destroyGammaSettings();
		int getCalibrationMode();
*/
	};


}	/*	<- namespace Psycholops 	*/
