<?php
/**
 * プリモコで共通で使用するHTMLパーツを提供するヘルパークラスです
 *
 * @author pippine
 *
 */
class PrimoccoHelper extends AppHelper {

	/**
	 * フォントサイズ指定用コンボボックスを生成します
	 *
	 * @param unknown_type $id
	 */
	function fontSize($id) {
		$html = "";
		$html = $html.'<select id="'.$id.'">';
		$html = $html.'<option value="6">6</option>';
		$html = $html.'<option value="8">8</option>';
		$html = $html.'<option value="9">9</option>';
		$html = $html.'<option value="10">10</option>';
		$html = $html.'<option value="11">11</option>';
		$html = $html.'<option value="12">12</option>';
		$html = $html.'<option value="14" selected>14</option>';
		$html = $html.'<option value="16">16</option>';
		$html = $html.'<option value="18">18</option>';
		$html = $html.'<option value="20">20</option>';
		$html = $html.'<option value="22">22</option>';
		$html = $html.'<option value="24">24</option>';
		$html = $html.'<option value="26">26</option>';
		$html = $html.'<option value="28">28</option>';
		$html = $html.'<option value="36">36</option>';
		$html = $html.'<option value="48">48</option>';
		$html = $html.'<option value="72">72</option>';
		$html = $html.'</select>';

		return $this->output($html);
	}

	/**
	 * 水平位置選択用コンボボックスを生成します
	 *
	 * @param unknown_type $id
	 */
	function alignSelect($id) {
		$html = "";
		$html = $html.'<select id="'.$id.'">';
		$html = $html.'<option value="left">左詰め</option>';
		$html = $html.'<option value="center">中央</option>';
		$html = $html.'<option value="right">右詰め</option>';
		$html = $html.'</select>';

		return $this->output($html);
	}


	/**
	 * 投稿日付と現在日時からの逆算日時を算出します。
	 * 例：2012年12月投稿で本日が2013年4月の場合→「4か月前」の算出
	 *
	 * @param date $d
	 */
	 function postedDate($d) {
		$val="";
		$ts = strtotime(date('Y-m-d')) - $d;
		if($ts>31536000) $val = round($ts/31536000,0).' 年';
		else if($ts>2419200) $val = round($ts/2419200,0).' か月';
		else if($ts>86400) $val = round($ts/86400,0).' 日';
		else $val = '0日';
		return $val;
	}

}