<?php
class Poster extends AppModel {

	public $name = "Poster";
	public $useTable = "poster";

	public $belongsTo = array(
		'Category',
		'Prefecture',
	);

	public $hasMany = array(
		'Image' => array('foreignKey' => 'page_id'),
	);

	public $validate = array(
		'category_id' => array(
			array(
				'rule' => 'notEmpty',
				'message' => 'カテゴリを選択してください',
			),
			array(
				'rule' => 'numeric',
				'message' => 'カテゴリを選択してください',
			),
		),
		'prefecture_id' => array(
			array(
				'rule' => 'numeric',
				'message' => 'データ不正です',
			),
			array(
				'rule' => array('range', -1, 48),
				'message' => 'データ不正です',
			),
		),
		'edit_type' => array(
			array(
				'rule' => 'numeric',
				'message' => 'データ不正です',
			),
			array(
				'rule' => array('range', -1, 2),
				'message' => 'データ不正です',
			),
		),
		'board_type' => array(
			array(
				'rule' => 'numeric',
				'message' => 'データ不正です',
			),
			array(
				'rule' => array('range', -1, 2),
				'message' => 'データ不正です',
			),
		),
		'poster_path' => array(
			array(
				'rule' => array('maxLength', 255),
				'message' => '文字数オーバーです',
			),
		),
		'directory' => array(
			array(
				'rule' => 'notEmpty',
				'message' => 'パスを入力してください',
			),
			array(
				'rule' => array('custom', '/^[a-zA-Z0-9]+$/'),
				'message' => '入力値が不正です',
			),
			array(
				'rule' => 'alphaNumeric',
				'message' => '入力値が不正です',
			),
			array(
				'rule' => array('maxLength', 32),
				'message' => '文字数オーバーです',
			),
		),
		'title' => array(
			array(
				'rule' => 'notEmpty',
				'message' => 'ポスタータイトルを入力してください',
			),
			array(
				'rule' => array('maxLength', 128),
				'message' => '文字数オーバーです',
			),
		),
		'caption' => array(
			array(
				'rule' => array('maxLength', 512),
				'message' => '文字数オーバーです',
			),
		),
		'catch_copy' => array(
			array(
				'rule' => array('maxLength', 30000),
				'message' => '文字数オーバーです',
			),
		),
		'description' => array(
			array(
				'rule' => array('maxLength', 30000),
				'message' => '文字数オーバーです',
			),
		),
		'catch_copy_ctrl' => array(
			array(
				'rule' => array('maxLength', 30000),
				'message' => '文字数オーバーです',
			),
		),
		'description_ctrl' => array(
			array(
				'rule' => array('maxLength', 30000),
				'message' => '文字数オーバーです',
			),
		),
	);
}