<?php
class Member extends AppModel {

	public $name = "Member";
	public $useTable = "member";

	public $validate = array(
		'domain' => array(
			array(
					'rule'		=> 'notEmpty',
					'message'	=> 'メンバーIDを入力してください',
			),
			array(
					'rule'		=> array('maxLength', 32),
					'message'	=> '32文字以内で入力してください',
			),
			array(
					'rule'		=> array('custom', '/^[a-z\d]*$/i'),
					'message'	=> '半角英数字のみご利用いただけます'
			),
		),
		'password' => array(
			array(
					'rule'		=> 'notEmpty',
					'message'	=> 'パスワードを入力してください',
			),
			array(
					'rule'		=> array('maxLength', 32),
					'message'	=> '32文字以内で入力してください',
			),
			array(
					'rule'		=> array('custom', '/^[a-z\d]*$/i'),
					'message'	=> '半角英数字のみご利用いただけます'
			),
		),
		'nickname' => array(
			array(
					'rule'		=> 'notEmpty',
					'message'	=> 'ニックネームを入力してください',
			),
		),
	);

}