<?php
/**
 * ログイン認証機能を提供する基底コントローラ
 * ログイン認証が必要なコントローラはこのコントローラを必ず継承してください
 * 各コントローラでbeforeFilterをオーバーライドする時は、必ずこのクラスのbeforeFilterを最初に呼び出してください
 *
 * @author pippine
 *
 */
abstract class PrimoccoAuthController extends AppController {

	public $layout = "mypage_layout";

	public function beforeFilter() {
		// ログインチェック
		if (!$this->Session->read($this->SESSION_KEY_MEMBER)) {
			$this->notLoginError();
		}
	}

}