<?php
class MemberController extends AppController {

	public $uses = array("Member","MemberInfo");

	public function register() {
		$this->render("regist");
	}

	public function regist() {
		$memberInfo = $this->data;
		if (!$this->Member->findByDomain($memberInfo["Member"]["domain"])) {
			$this->Member->create();
			$this->Member->set($memberInfo);
			if ($this->Member->validates()) {
				$memberInfo["Member"]["password"] = hash("md5", $this->data["Member"]["password"]);
				$this->Member->save($memberInfo);
				//新規登録時にmember_info(type_id=2)にてポイントの初期値を登録しておく
				$save_data["MemberInfo"] = array("member_id"=>$this->Member->getLastInsertID() ,"type_id"=>2,"value"=>100);
		        $this->MemberInfo->save($save_data);
				$this->render("complete");
			}
		// 既にメンバーが存在する場合
		} else {
			$this->set("error", "このメンバーIDはすでに存在します");
			$this->render("regist");
		}
	}

	public function login() {
		$this->render("login");
	}

	public function on() {
		$user = $this->Member->findByDomainAndPassword($this->data["Member"]["domain"], hash("md5", $this->data["Member"]["password"]));
		if ($user) {
			$this->Session->write($this->SESSION_KEY_MEMBER, $user);

			$info = $this->MemberInfo->findByTypeIdAndMemberId(2, $user["Member"]["id"]);
			echo $info;
			//if ($info) {
				$this->Session->write($this->SESSION_KEY_MEMBER_INFO, $info);
			//}

			$this->redirect("/");
		} else {
			$this->render("login_error");
		}
		
	}

	public function logout() {
		$this->sessionDestroy();
		$this->redirect("/");
	}


}