<?php
class ContactController extends AppController {

	public $uses = array('Contact');

	public $paginate = array(
		'Contact' => array(
			'order' => array(
				'id' => 'DESC',
			),
			'limit' => 8,
		),
	);

	public function login() {

		$this->Session->write('adminPass', false);
		if($this->request->isPost()) {

			$pass = $this->request->data[$this->Contact->alias]['adminPass'];
//			if (!empty($pass) && 'ec5cafa4c17c58e9e407fb7b829bc36faf48594a' == AuthComponent::password($pass)) {
			if (!empty($pass) && '17c87f7475e0a72f9b96b80b25d2552b' == hash('md5', $pass)) {
				$this->Session->write('adminPass', true);
				$login_back_url = $this->Session->read('login_back_url');
				if (!empty($login_back_url)) {
					$this->redirect($login_back_url);
				} else {
					$this->redirect(array('action' => 'viewList'));
				}
			} else {
				$this->redirect(array('action' => 'viewList'));
			}
		}
	}

	public function index() {

		if (!empty($this->request->data)) {

			if ($this->request->data[$this->Contact->alias]['confirmed']) {

				if ($this->Contact->saveAll($this->request->data)) {
					$this->redirect(array('action' => 'done'));
				} else {
					$this->request->data[$this->Contact->alias['confirmed']] = false;
				}

			} else {

				if ($this->Contact->saveAll($this->request->data, array('validate' => 'only'))) {
					$this->render('confirm');
				}

			}
		}
	}

	public function viewList() {

		$this->Session->write('adminPass', false);
		$contactData = $this->paginate('Contact');

		if (count($contactData) == 0){
			$this->set('error', '現在、お問い合わせはありません。');
		}
		$this->set(compact('contactData'));
	}

	public function view($id) {
		$contactData = $this->Contact->findById($id);

		if(empty($contactData)) {
			$this->redirect(array('action' => 'viewList'));
		}

		$this->set(compact('contactData'));
	}

	public function edit($id) {

		$pass = $this->Session->read('adminPass');
		if(!isset($pass) || $pass == false) {
			$this->Session->write('login_back_url',((getenv('SERVER_PORT')==443)?'https://':'http://').getenv('HTTP_HOST').getenv('REQUEST_URI'));
			$this->redirect(array('action' => 'login'));
		} else {
			if($this->request->isPut()) {

				if($this->Contact->save($this->request->data)) {
					$this->Session->write('adminPass', false);
					$this->redirect(array('action' => 'viewList'));
				} else {
					$this->Session->setFlash('入力内容に間違いがあります。');
				}
			} else {
				$this->request->data = $this->Contact->findById($id);

				if(empty($this->request->data)) {
					$this->Session->setFlash('お問い合わせが見つかりませんでした。');
					$this->redirect(array('action' => 'viewList'));
				}
			}
		}
	}

	public function delete($id) {

		$pass = $this->Session->read('adminPass');
		if(!isset($pass) || $pass == false) {
			$this->Session->write('login_back_url',((getenv('SERVER_PORT')==443)?'https://':'http://').getenv('HTTP_HOST').getenv('REQUEST_URI'));
			$this->redirect(array('action' => 'login'));
		} else {
			if($this->request->isDelete()) {

				if($this->Contact->delete($id)) {
					$this->Session->write('adminPass', false);
					$this->redirect(array('action' => 'viewList'));
				}
				$this->Session->setFlash('削除に失敗しました。');
				$this->redirect(array('action' => 'viewList'));
			}

			$this->request->data = $this->Contact->findById($id);

			if(empty($this->request->data)) {
				$this->Session->setFlash('お問い合わせが見つかりませんでした。');
				$this->redirect(array('action' => 'viewList'));
			}
		}
	}

	public function done() {
	}
}