package open.dolphin.plugin;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.prefs.Preferences;

import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;

import open.dolphin.client.IChart;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;

/**
 *
 * @author
 */
public class RSBasePlugin implements open.dolphin.plugin.IPlugin {

    private final String NODE_NAME = "/open/dolphin/plugin/rsbase";
    private String address;

    /**
     * 
     */
    public RSBasePlugin() {
        //  address = (String) getValue();
        Preferences prefs = Preferences.userRoot().node(NODE_NAME);
        address = prefs.get("address", "localhost");
    }

    private String getName() {
        return "showBrowser";
    }

    private String getReadableName() {
        return "RS Base表示";
    }

    private IAbstractSettingPanel configure() {
        return new RSBasePluginSettingPanel(this);
    }

    private boolean execute(IChart chartContext) {
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        if (chartContext != null) {
            String IDString = chartContext.getPatientVisit().getPatientId();
            final String PatentID = Integer.toString(Integer.parseInt(IDString));
            final Desktop desktop = Desktop.getDesktop();
            Task task = new Task<Object, Void>(app) {

                @Override
                protected Object doInBackground() throws Exception {
                    try {
                        try {
                            desktop.browse(new URI("http://" + address + "/~rsn/2000.cgi?show=" + PatentID));
                        } catch (URISyntaxException ex) {
                            LogWriter.error(getClass(), ex);
                        }
                    } catch (IOException ex) {
                        LogWriter.error(getClass(), ex);
                    }
                    return true;
                }

                @Override
                protected void succeeded(Object result) {
                }

                @Override
                protected void cancelled() {
                }

                @Override
                protected void failed(java.lang.Throwable cause) {
                }

                @Override
                protected void interrupted(java.lang.InterruptedException e) {
                }
            };

            appCtx.getTaskService().execute(task);
            return true;
        }
        return true;
    }

    private Type getType() {
        return open.dolphin.plugin.IPlugin.Type.toolmenu;
    }

    private Boolean update(Object object) {
        return false;
    }

    /**
     *
     * @param command
     * @param request
     * @param response
     * @return
     */
    @Override
    public boolean dispatchCommand(open.dolphin.plugin.IPlugin.Command command, Object[] request, Object[] response) {
        switch (command) {
            case execute:
                boolean res = execute(((IChart) request[0]));
                response[0] = res;
                break;
            case getType:
                response[0] = getType();
                break;
            case getName:
                response[0] = getName();
                break;
            case getReadableName:
                response[0] = getReadableName();
                break;
            case configure:
                response[0] = configure();
                break;
            case update:
                response[0] = update(request[0]);
                break;
            default:
                return false;
        }
        return true;
    }
}
