package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;

/**
 * スタンプツリー MEMO:マッピング d_stamp_tree
 * StampTreeModel generated by hbm2java
 */
public class StampTreeModel extends InfoModel implements IStampTreeModel {

    private long id;//MEMO:Refrection
    private UserModel user;//MEMO:Refrection
    private String name;//MEMO:Refrection
    private String publishType;//MEMO:Refrection
    private String category;//MEMO:Refrection
    private String partyName;//MEMO:Refrection
    private String url;//公開情報 MEMO:Refrection
    private String description;//MEMO:Refrection
    private Date publishedDate;//MEMO:Refrection
    private Date lastUpdated;//MEMO:Refrection
    private String published;//MEMO:Refrection
    private byte[] treeBytes;
    private Blob treeBlob;//MEMO:Refrection

    /**
     * コンストラクタ
     */
    public StampTreeModel() {
    }

    /**
     * 初期化
     * @param user
     * @param name
     * @param description
     * @param partyName
     * @param url
     * @param xml
     */
    public void initialize(UserModel user, String name, String description, String partyName, String url, String xml) {
        setUser(user);
        setName(name);
        setDescription(description);
        setPartyName(partyName);
        setUrl(url);
        setTreeXml(xml);
    }

    /**
     * 検索 MEMO:何もしない
     * @param query
     * @return false
     */
    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    /**
     * IDのGetter
     * MEMO:Refrection
     * @return ID
     */
    @Override
    public long getId() {
        return this.id;
    }

    /**
     * IDのSetter
     * MEMO:Refrection
     * @param id ID
     */
    @Override
    public void setId(long id) {
        this.id = id;
    }

    /**
     * ユーザのGetter
     * MEMO:Refrection
     * @return ユーザ
     */
    @Override
    public UserModel getUser() {
        return this.user;
    }

    /**
     * ユーザのSetter
     * MEMO:Refrection
     * @param DUsers ユーザ
     */
    public void setUser(UserModel DUsers) {
        this.user = DUsers;
    }

    /**
     * ツリー名のGetter
     * MEMO:Refrection
     * @return ツリー名
     */
    @Override
    public String getName() {
        return this.name;
    }

    /**
     * ツリー名のSetter
     * MEMO:Refrection
     * @param treeName ツリー名
     */
    public void setName(String treeName) {
        this.name = treeName;
    }

    /**
     * 公開タイプのGetter
     * MEMO:Refrection
     * @return 公開タイプ
     */
    @Override
    public String getPublishType() {
        return this.publishType;
    }

    /**
     * 公開タイプのSetter
     * MEMO:Refrection
     * @param publishType 公開タイプ
     */
    @Override
    public void setPublishType(String publishType) {
        this.publishType = publishType;
    }

    /**
     * 種別のGetter
     * MEMO:Refrection
     * @return 種別
     */
    @Override
    public String getCategory() {
        return this.category;
    }

    /**
     * 種別のSetter
     * MEMO:Refrection
     * @param category 種別
     */
    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    /**
     * partyNameのGetter
     * MEMO:Refrection
     * @return partyName
     */
    @Override
    public String getPartyName() {
        return this.partyName;
    }

    /**
     * partyNameのSetter
     * MEMO:Refrection
     * @param partyName
     */
    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    /**
     * URIのGetter
     * MEMO:Refrection
     * @return URI
     */
    @Override
    public String getUrl() {
        return this.url;
    }

    /**
     * URIのSetter
     * MEMO:Refrection
     * @param url URI
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * 詳細のGetter
     * MEMO:Refrection
     * @return 詳細
     */
    @Override
    public String getDescription() {
        return this.description;
    }

    /**
     * 詳細のSetter
     * MEMO:Refrection
     * @param description 詳細
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 公開日のGetter
     * MEMO:Refrection
     * @return 公開日
     */
    @Override
    public Date getPublishedDate() {
        return this.publishedDate;
    }

    /**
     * 公開日のSetter
     * MEMO:Refrection
     * @param publisheddate 公開日
     */
    @Override
    public void setPublishedDate(Date publisheddate) {
        this.publishedDate = publisheddate;
    }

    /**
     * 最終更新のGetter
     * MEMO:Refrection
     * @return 最終更新
     */
    @Override
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    /**
     * 最終更新のSetter
     * MEMO:Refrection
     * @param lastupdated 最終更新
     */
    @Override
    public void setLastUpdated(Date lastupdated) {
        this.lastUpdated = lastupdated;
    }

    /**
     * 公開のGetter
     * MEMO:Refrection
     * @return 公開
     */
    public String getPublished() {
        return this.published;
    }

    /**
     * 公開のSetter
     * MEMO:Refrection
     * @param published 公開
     */
    public void setPublished(String published) {
        this.published = published;
    }

    /**
     * ツリーのシリアライズ
     * @return シリアライズされたツリー
     */
    @Override
    public byte[] getTreeBytes() {
        return this.treeBytes;
    }

    /**
     * ツリーのシリアライズのSetter
     * @param treeBytes シリアライズされたツリー
     */
    public void setTreeBytes(byte[] treeBytes) {
        if (treeBytes != null) {
            this.treeBytes = treeBytes;
            this.treeBlob = new BlobImpl(treeBytes);
        }
    }

    /**
     * ツリーのBlobへのシリアライズ
     * MEMO:Refrection
     * @return ツリーのBlob
     */
    public Blob getTreeBlob() {
        return this.treeBlob;
    }

    /**
     * ツリーのBlobのSetter
     * MEMO:Refrection
     * @param treeBlob
     * @throws SQLException
     */
    public void setTreeBlob(Blob treeBlob) throws SQLException {
        if (treeBlob != null) {
            this.treeBlob = treeBlob;
            this.treeBytes = treeBlob.getBytes(1, (int) treeBlob.length());
        }
    }

    /**
     * treeXmlのGetter
     * @return treeXml
     */
    @Override
    public String getTreeXml() {
        if (treeBytes != null) {
            try {
                return new String(treeBytes, "UTF-8");
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), null, ex);
            }
        }
        return "";
    }

    /**
     * treeXmlのSetter
     * @param treeXml
     */
    @Override
    public void setTreeXml(String treeXml) {
        if (treeXml != null) {
            try {
                treeBytes = treeXml.getBytes("UTF-8");
                if (treeBytes == null) {
                    treeBlob = null;
                } else {
                    treeBlob = new BlobImpl(treeBytes);
                }
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), null, ex);
            }
        }
    }

    /**
     * ハッシュコード
     * @return
     */
    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + (int) (id ^ (id >>> 32));
        return result;
    }

    /**
     * 比較
     * @param obj
     * @return obj 同じなら真
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final StampTreeModel other = (StampTreeModel) obj;
        if (getId() != other.getId()) {
            return false;
        }
        return true;
    }
}
