package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;

/**
 * スタンプ MEMO:マッピング d_stamp
 * StampModel generated by hbm2java
 */
public class StampModel extends InfoModel {

    private String id;//ID MEMO:Refrection
    private long userId;//ユーザID MEMO:Refrection
    private String entity;//MEMO:Refrection
    private Blob stampBlob;//MEMO:Refrection
    private byte[] stampBytes;

    /**
     * コンストラクタ
     */
    public StampModel() {
    }

    /**
     * IDのGetter
     * MEMO:Refrection
     * @return ID
     */
    public String getId() {
        return this.id;
    }

    /**
     * IDのSetter
     * MEMO:Refrection
     * @param id ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * ユーザIDのGetter
     * MEMO:Refrection
     * @return ユーザID
     */
    public long getUserId() {
        return this.userId;
    }

    /**
     * ユーザIDのSetter
     * MEMO:Refrection
     * @param userid ユーザID
     */
    public void setUserId(long userid) {
        this.userId = userid;
    }

    /**
     * エントリのGetter
     * MEMO:Refrection
     * @return エントリ
     */
    public String getEntity() {
        return this.entity;
    }

    /**
     * エントリのSetter
     * MEMO:Refrection
     * @param entity エントリ
     */
    public void setEntity(String entity) {
        this.entity = entity;
    }

    /**
     * シリアライズされたスタンプ
     * @return シリアライズされたスタンプ
     */
    public byte[] getStampBytes() {
        return this.stampBytes;
    }

    /**
     * シリアライズされたスタンプのSetter
     * @param stampBytes シリアライズされたスタンプ
     */
    public void setStampBytes(byte[] stampBytes) {
        this.stampBytes = stampBytes;
        if (stampBytes == null) {
            stampBytes = null;
        } else {
            this.stampBlob = new BlobImpl(stampBytes);
        }
    }

    /**
     * シリアライズされたスタンプ
     * MEMO:Refrection
     * @return シリアライズされたスタンプ
     */
    public Blob getStampBlob() {
        return this.stampBlob;
    }

    /**
     * シリアライズされたスタンプのSetter
     * MEMO:Refrection
     * @param stampBlob
     * @throws SQLException
     */
    public void setStampBlob(Blob stampBlob) throws SQLException {
        if (stampBlob != null) {
            this.stampBlob = stampBlob;
            this.stampBytes = stampBlob.getBytes(1, (int) stampBlob.length());
        }
    }

    /**
     * 検索 MEMO:何もしない
     * @param query
     * @return false
     */
    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    /**
     * 初期化
     * @param id
     * @param userId
     * @param entity
     * @param stampBytes
     * @throws SQLException
     */
    public void initialize(String id, long userId, String entity, byte[] stampBytes) throws SQLException {
        setId(id);
        setUserId(userId);
        setEntity(entity);
        setStampBytes(stampBytes);
    }

    /**
     * 初期化
     * @param id
     * @param userId
     * @param entity
     * @param stampXml
     */
    public void initialize(String id, long userId, String entity, String stampXml) {
        setId(id);
        setUserId(userId);
        setEntity(entity);
        setXml(stampXml);
    }

    /**
     * XMLにシリアライズ
     * @return XML
     */
    public String getXml() {
        if (stampBytes != null) {
            try {
                return new String(stampBytes, "UTF-8");
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), ex);
            }
        }
        return "";
    }

    /**
     * XMLのSetter
     * @param xml
     */
    public void setXml(String xml) {
        if (xml != null) {
            try {
                stampBytes = xml.getBytes("UTF-8");
                if (stampBytes == null) {
                    stampBlob = null;
                } else {
                    stampBlob = new BlobImpl(stampBytes);
                }
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), ex);
            }
        }
    }

    /**
     * インフォモデルの取り出し
     * @return インフォモデル
     */
    public IInfoModel toInfoModel() {
        return ((IInfoModel) BeanUtils.xmlDecode(getStampBytes()));
    }

    /**
     * ハッシュ
     * @return ハッシュ
     */
    @Override
    public int hashCode() {
        return id.hashCode();
    }

    /**
     * 比較
     * @param obj
     * @return 同一なら真
     */
    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        final StampModel other = (StampModel) obj;
        if (!getId().equals(other.getId())) {
            return false;
        }
        return true;
    }

    /**
     * MEMO:何もしない
     * @param result
     * @throws IOException
     */
    public void serialize(Writer result) throws IOException {
        //TODO serialize
    }

    /**
     * MEMO:何もしない
     * @param result
     * @throws IOException
     */
    public void deserialize(Writer result) throws IOException {
        //TODO deserialize
    }
}
