package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import javax.persistence.Transient;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;

/**
 * カルテ MEMO:マッピング  d_module
 * ModuleModel generated by hbm2java
 */
public class ModuleModel extends KarteEntryBean {

    private IStampInfo moduleInfo;
    private transient Blob beanBlob;
    private byte[] beanBytes;//MEMO:Refrection
    private DocumentModel document;
    @Transient
    private IInfoModel model;

    /**
     *
     */
    public ModuleModel() {
        setModuleInfo(new ModuleInfoBean());
    }

    /**
     *
     * @param model
     */
    public ModuleModel(IInfoModel model) {
        setModuleInfo(new ModuleInfoBean());
        setModel(model);
    }

    /**
     * 検索
     * @param query
     * @return true false
     */
    @Override
    public boolean search(DolphinQuery query) {
        if (((InfoModel) model).search(query)) {
            return true;
        }
        if (moduleInfo.search(query)) {
            return true;
        }
        if (getXml().indexOf(query.what("keyword")) != -1) {
            return true;
        }
        return false;
    }

    /**
     * documentのGetter
     * @return
     */
    public DocumentModel getDocument() {
        return document;
    }

    /**
     * documentのSetter
     * @param document
     */
    public void setDocument(DocumentModel document) {
        this.document = document;
    }

    /**
     * moduleInfoのSetter
     * @param moduleInfo
     */
    public void setModuleInfo(IStampInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    /**
     * moduleInfoのGetter
     * @return
     */
    public IStampInfo getModuleInfo() {
        return moduleInfo;
    }

    /**
     * modelのSetter
     * @param model
     */
    public final void setModel(IInfoModel model) {
        this.model = model;
    }

    /**
     * modelのGetter
     * @return
     */
    public IInfoModel getModel() {
        return model;
    }

    /**
     * beanBytesのGetter
     * MEMO:Refrection
     * @return
     */
    public byte[] getBeanBytes() {
        return beanBytes;
    }

    /**
     * beanBytesのSetter
     * MEMO:Refrection
     * @param beanBytes
     */
    public void setBeanBytes(byte[] beanBytes) {
        this.beanBytes = beanBytes;
        if (beanBytes == null) {
            this.beanBlob = null;
        } else {
            this.beanBlob = new BlobImpl(beanBytes);
        }
    }

    /**
     * beanBlobのGetter
     * @return
     */
    public Blob getBeanBlob() {
        return this.beanBlob;
    }

    /**
     * beanBlobのSetter
     * @param beanBlob
     * @throws SQLException
     */
    public void setBeanBlob(Blob beanBlob) throws SQLException {
        if (beanBlob != null) {
            this.beanBlob = beanBlob;
            this.beanBytes = beanBlob.getBytes(1, (int) beanBlob.length());
        }
    }

    /**
     * XmlのGetter
     * @return
     */
    public String getXml() {
        if (beanBytes != null) {
            try {
                return new String(getBeanBytes(), "UTF-8");
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), ex);
            }
        }
        return "";
    }

    /**
     * XmlのSetter
     * @param xml
     */
    public void setXml(String xml) {
        if (xml != null) {
            try {
                beanBytes = xml.getBytes("UTF-8");
                if (beanBytes == null) {
                    beanBlob = null;
                } else {
                    beanBlob = new BlobImpl(beanBytes);
                }
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), ex);
            }
        }
    }

    /**
     *
     * @return
     */
    public IInfoModel toInfoModel() {
        return ((IInfoModel) BeanUtils.xmlDecode(getBeanBytes()));
    }

    /**
     *
     * @param other
     * @return
     */
    @Override
    public int compareTo(Object other) {
        if (other != null && getClass() == other.getClass()) {
            IStampInfo moduleInfo1 = getModuleInfo();
            IStampInfo moduleInfo2 = ((ModuleModel) other).getModuleInfo();
            return moduleInfo1.compareTo(moduleInfo2);
        }
        return -1;
    }

    /**
     *
     * @param d
     * @return
     */
    private String DocumentModelToString(DocumentModel d) {
        if (d == null) {
            return "";
        }
        return Long.toString(d.getId());
    }

    /**
     * シリアライズ
     * @param result
     * @throws IOException
     */
    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<ModuleModel" + " document_id='" + DocumentModelToString(document) + "'>" + System.getProperty("line.separator"));
        super.serialize(result);
        if (moduleInfo != null) {
            moduleInfo.serialize(result);
        }
        result.append("<beanBytes>");
        result.append(System.getProperty("line.separator"));
        result.append("<![CDATA[");
        result.append(getXml());
        result.append("]]>");
        result.append(System.getProperty("line.separator"));
        result.append("</beanBytes>");
        result.append(System.getProperty("line.separator"));
        result.append("</ModuleModel>");
        result.append(System.getProperty("line.separator"));
    }
}
