/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DirectionSettingPanel.java
 *
 * Created on 2010/04/16, 15:01:44
 */
package open.dolphin.client.settings;

import java.awt.print.PrinterJob;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.print.PrintService;
import javax.swing.JPanel;
import open.dolphin.log.LogWriter;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.Adapter;

/**
* 指示箋設定画面　MEMO:画面
 * @author
 */
public class DirectionSettingPanel extends javax.swing.JPanel implements IAbstractSettingPanel {

    private static final String ID = "directionSetting";
    private static final String TITLE = "指示箋";
    private static final String ICON = "prefs_24.gif";
    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    private State state = State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private DirectionSettingModel model;
    // private PageFormat pageFormat;
    private Adapter<Boolean, Boolean> adapter;

    /** Creates new form DirectionSettingPanel */
    public DirectionSettingPanel() {
        boundSupport = new PropertyChangeSupport(this);
        initComponents();
        initCustomComponents();

        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
        model = new DirectionSettingModel();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        medOrderComboBox = new javax.swing.JComboBox();
        injectionOrderComboBox = new javax.swing.JComboBox();
        treatmentOrderComboBox = new javax.swing.JComboBox();
        surgeryOrderComboBox = new javax.swing.JComboBox();
        testOrderComboBox = new javax.swing.JComboBox();
        radiologyOrderComboBox = new javax.swing.JComboBox();
        otherOrderComboBox = new javax.swing.JComboBox();
        cCmedOrderComboBox = new javax.swing.JComboBox();
        cCinjectionOrderComboBox = new javax.swing.JComboBox();
        cCtreatmentOrderComboBox = new javax.swing.JComboBox();
        cCsurgeryOrderComboBox = new javax.swing.JComboBox();
        cCtestOrderComboBox = new javax.swing.JComboBox();
        cCradiologyOrderComboBox = new javax.swing.JComboBox();
        cCotherOrderComboBox = new javax.swing.JComboBox();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("指示箋の印刷先"));
        jPanel1.setName("jPanel1"); // NOI18N

        jLabel1.setText("処方");
        jLabel1.setName("jLabel1"); // NOI18N

        jLabel2.setText("注射");
        jLabel2.setName("jLabel2"); // NOI18N

        jLabel7.setText("その他");
        jLabel7.setName("jLabel7"); // NOI18N

        jLabel6.setText("画像診断");
        jLabel6.setName("jLabel6"); // NOI18N

        jLabel5.setText("検査");
        jLabel5.setName("jLabel5"); // NOI18N

        jLabel4.setText("手術");
        jLabel4.setName("jLabel4"); // NOI18N

        jLabel3.setText("処置");
        jLabel3.setName("jLabel3"); // NOI18N

        medOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        medOrderComboBox.setName("medOrderComboBox"); // NOI18N
        medOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        injectionOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        injectionOrderComboBox.setName("injectionOrderComboBox"); // NOI18N
        injectionOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        treatmentOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        treatmentOrderComboBox.setName("treatmentOrderComboBox"); // NOI18N
        treatmentOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        surgeryOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        surgeryOrderComboBox.setName("surgeryOrderComboBox"); // NOI18N
        surgeryOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        testOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        testOrderComboBox.setName("testOrderComboBox"); // NOI18N
        testOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        radiologyOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        radiologyOrderComboBox.setName("radiologyOrderComboBox"); // NOI18N
        radiologyOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        otherOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        otherOrderComboBox.setName("otherOrderComboBox"); // NOI18N
        otherOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        cCmedOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        cCmedOrderComboBox.setName("cCmedOrderComboBox"); // NOI18N
        cCmedOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        cCinjectionOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        cCinjectionOrderComboBox.setName("cCinjectionOrderComboBox"); // NOI18N
        cCinjectionOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        cCtreatmentOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        cCtreatmentOrderComboBox.setName("cCtreatmentOrderComboBox"); // NOI18N
        cCtreatmentOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        cCsurgeryOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        cCsurgeryOrderComboBox.setName("cCsurgeryOrderComboBox"); // NOI18N
        cCsurgeryOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        cCtestOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        cCtestOrderComboBox.setName("cCtestOrderComboBox"); // NOI18N
        cCtestOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        cCradiologyOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        cCradiologyOrderComboBox.setName("cCradiologyOrderComboBox"); // NOI18N
        cCradiologyOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        cCotherOrderComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "なし" }));
        cCotherOrderComboBox.setName("cCotherOrderComboBox"); // NOI18N
        cCotherOrderComboBox.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                DirectionSettingPanel.this.propertyChange(evt);
            }
        });

        jLabel8.setText("プリント先１");
        jLabel8.setName("jLabel8"); // NOI18N

        jLabel9.setText("プリント先2");
        jLabel9.setName("jLabel9"); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(26, 26, 26)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel5)
                    .addComponent(jLabel6)
                    .addComponent(jLabel7)
                    .addComponent(jLabel4)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3))
                .addGap(11, 11, 11)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(surgeryOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(otherOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(radiologyOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(treatmentOrderComboBox, 0, 170, Short.MAX_VALUE)
                    .addComponent(injectionOrderComboBox, 0, 170, Short.MAX_VALUE)
                    .addComponent(medOrderComboBox, 0, 170, Short.MAX_VALUE)
                    .addComponent(jLabel8)
                    .addComponent(testOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel9)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addComponent(cCtreatmentOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cCsurgeryOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cCtestOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cCradiologyOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cCotherOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cCmedOrderComboBox, 0, 152, Short.MAX_VALUE)
                        .addComponent(cCinjectionOrderComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap(96, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(9, 9, 9)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel9)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel1)
                            .addComponent(medOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(12, 12, 12)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2)
                            .addComponent(injectionOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3)
                            .addComponent(treatmentOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel4)
                            .addComponent(surgeryOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel5)
                            .addComponent(testOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel6)
                            .addComponent(radiologyOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel7)
                            .addComponent(otherOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(cCmedOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(12, 12, 12)
                        .addComponent(cCinjectionOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cCtreatmentOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cCsurgeryOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cCtestOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cCradiologyOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cCotherOrderComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void propertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_propertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }
    }//GEN-LAST:event_propertyChange
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cCinjectionOrderComboBox;
    private javax.swing.JComboBox cCmedOrderComboBox;
    private javax.swing.JComboBox cCotherOrderComboBox;
    private javax.swing.JComboBox cCradiologyOrderComboBox;
    private javax.swing.JComboBox cCsurgeryOrderComboBox;
    private javax.swing.JComboBox cCtestOrderComboBox;
    private javax.swing.JComboBox cCtreatmentOrderComboBox;
    private javax.swing.JComboBox injectionOrderComboBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JComboBox medOrderComboBox;
    private javax.swing.JComboBox otherOrderComboBox;
    private javax.swing.JComboBox radiologyOrderComboBox;
    private javax.swing.JComboBox surgeryOrderComboBox;
    private javax.swing.JComboBox testOrderComboBox;
    private javax.swing.JComboBox treatmentOrderComboBox;
    // End of variables declaration//GEN-END:variables

    /**
     * 
     * @param adapter
     */
    @Override
    public void onChenge(Adapter<Boolean, Boolean> adapter) {
        this.adapter = adapter;
    }

    /**
     * 
     */
    private void initCustomComponents() {
        PrintService[] services = PrinterJob.lookupPrintServices();

        for (int index = 0; index < services.length; index++) {

            medOrderComboBox.addItem(services[index].getName());
            injectionOrderComboBox.addItem(services[index].getName());
            treatmentOrderComboBox.addItem(services[index].getName());
            surgeryOrderComboBox.addItem(services[index].getName());
            testOrderComboBox.addItem(services[index].getName());
            radiologyOrderComboBox.addItem(services[index].getName());
            otherOrderComboBox.addItem(services[index].getName());

            cCmedOrderComboBox.addItem(services[index].getName());
            cCinjectionOrderComboBox.addItem(services[index].getName());
            cCtreatmentOrderComboBox.addItem(services[index].getName());
            cCsurgeryOrderComboBox.addItem(services[index].getName());
            cCtestOrderComboBox.addItem(services[index].getName());
            cCradiologyOrderComboBox.addItem(services[index].getName());
            cCotherOrderComboBox.addItem(services[index].getName());
        }
    }

    /**
     * 
     * @return
     */
    @Override
    public String getId() {
        return id;
    }

    /**
     * 
     * @param id
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 
     * @return
     */
    @Override
    public String getTitle() {
        return title;
    }

    /**
     *
     * @param title
     */
    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 
     * @return
     */
    @Override
    public String getIcon() {
        return icon;
    }

    /**
     * 
     * @param icon
     */
    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     * 
     * @return
     */
    @Override
    public ProjectSettingDialog getContext() {
        return context;
    }

    /**
     * 
     * @param context
     */
    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener(STATE_PROP, context);
        this.setLogInState(context.getLoginState());
    }

    /**
     * 
     * @return
     */
    @Override
    public boolean isLoginState() {
        return loginState;
    }

    /**
     * 
     * @param login
     */
    @Override
    public void setLogInState(boolean login) {
        loginState = login;
    }

    /**
     * 
     * @return
     */
    @Override
    public JPanel getPanel() {
        return this;
    }

    /**
     *
     */
    @Override
    public void start() {
        model.populate();
        medOrderComboBox.getModel().setSelectedItem(model.get(0));
        injectionOrderComboBox.getModel().setSelectedItem(model.get(1));
        treatmentOrderComboBox.getModel().setSelectedItem(model.get(2));
        surgeryOrderComboBox.getModel().setSelectedItem(model.get(3));
        testOrderComboBox.getModel().setSelectedItem(model.get(4));
        radiologyOrderComboBox.getModel().setSelectedItem(model.get(5));
        otherOrderComboBox.getModel().setSelectedItem(model.get(6));

        cCmedOrderComboBox.getModel().setSelectedItem(model.getCc(0));
        cCinjectionOrderComboBox.getModel().setSelectedItem(model.getCc(1));
        cCtreatmentOrderComboBox.getModel().setSelectedItem(model.getCc(2));
        cCsurgeryOrderComboBox.getModel().setSelectedItem(model.getCc(3));
        cCtestOrderComboBox.getModel().setSelectedItem(model.getCc(4));
        cCradiologyOrderComboBox.getModel().setSelectedItem(model.getCc(5));
        cCotherOrderComboBox.getModel().setSelectedItem(model.getCc(6));
    }

    /**
     * 
     */
    @Override
    public void save() {
        model.set(0, (String) medOrderComboBox.getModel().getSelectedItem());
        model.set(1, (String) injectionOrderComboBox.getModel().getSelectedItem());
        model.set(2, (String) treatmentOrderComboBox.getModel().getSelectedItem());
        model.set(3, (String) surgeryOrderComboBox.getModel().getSelectedItem());
        model.set(4, (String) testOrderComboBox.getModel().getSelectedItem());
        model.set(5, (String) radiologyOrderComboBox.getModel().getSelectedItem());
        model.set(6, (String) otherOrderComboBox.getModel().getSelectedItem());

        model.setCc(0, (String) cCmedOrderComboBox.getModel().getSelectedItem());
        model.setCc(1, (String) cCinjectionOrderComboBox.getModel().getSelectedItem());
        model.setCc(2, (String) cCtreatmentOrderComboBox.getModel().getSelectedItem());
        model.setCc(3, (String) cCsurgeryOrderComboBox.getModel().getSelectedItem());
        model.setCc(4, (String) cCtestOrderComboBox.getModel().getSelectedItem());
        model.setCc(5, (String) cCradiologyOrderComboBox.getModel().getSelectedItem());
        model.setCc(6, (String) cCotherOrderComboBox.getModel().getSelectedItem());
        model.restore();
    }

    /**
     * 
     * @param prop
     * @param l
     */
    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.addPropertyChangeListener(prop, l);
    }

    /**
     * 
     * @param prop
     * @param l
     */
    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.removePropertyChangeListener(prop, l);
    }

    /**
     * 
     * @param state
     */
    @Override
    public void setState(State state) {
        this.state = state;
        boundSupport.firePropertyChange(STATE_PROP, null, this.state);
    }

    /**
     * 
     * @return
     */
    @Override
    public State getState() {
        return state;
    }

    /**
     *  サーバ画面設定用のモデルクラス。
     */
    class DirectionSettingModel {

        CombinedStringParser lines;
        CombinedStringParser cc_lines;

        /**
         *
         */
        public DirectionSettingModel() {
        }

        /**
         *
         * @param index
         * @param item
         */
        public void set(int index, String item) {
            lines.set(index, item);
        }

        /**
         *
         * @param index
         * @return
         */
        public String get(int index) {
            return lines.get(index);
        }

        /**
         *
         * @param index
         * @param item
         */
        public void setCc(int index, String item) {
            cc_lines.set(index, item);
        }

        /**
         *
         * @param index
         * @return
         */
        public String getCc(int index) {
            return cc_lines.get(index);
        }

        /**
         *
         */
        public void populate() {
            lines = GlobalVariables.getDirections();
            cc_lines = GlobalVariables.getCcDirections();
        }

        /**
         *
         */
        public void restore() {
            GlobalVariables.setDirections(lines);
            GlobalVariables.setCcDirections(cc_lines);
        }
    }
}
