/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.ContentImpl;

abstract class NamedContentImpl
extends ContentImpl {
    protected Code name;
    protected final Long obsDateTime;
    protected final Template template;

    protected static Code checkNotNull(Code name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return name;
    }

    NamedContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name) {
        super(owner);
        this.name = name;
        this.template = template;
        this.obsDateTime = obsDateTime != null ? new Long(obsDateTime.getTime()) : null;
    }

    StringBuffer prompt() {
        return super.prompt().append(this.getValueType()).append(this.name).append('=');
    }

    public Code getName() {
        return this.name;
    }

    public void setName(Code newName) {
        this.name = newName;
    }

    public Date getObservationDateTime(boolean inherit) {
        if (this.obsDateTime != null) {
            return new Date(this.obsDateTime);
        }
        if (!inherit) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.getObservationDateTime(true);
        }
        return this.owner.getContentDateTime();
    }

    public Template getTemplate() {
        return this.template;
    }
}

