/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.media.DirBuilder;
import org.dcm4che.media.DirBuilderFactory;
import org.dcm4che.media.DirBuilderPref;
import org.dcm4che.media.DirRecord;
import org.dcm4che.media.DirWriter;
import org.dcm4cheri.media.DirReaderImpl;

final class DirBuilderImpl
implements DirBuilder {
    private final DirWriter writer;
    private final DirBuilderPref pref;
    private String curPatID;
    private DirRecord curPatRec;
    private String curStudyUID;
    private DirRecord curStudyRec;
    private String curSeriesUID;
    private DirRecord curSeriesRec;

    public DirBuilderImpl(DirWriter writer, DirBuilderPref pref) {
        this.writer = writer;
        this.pref = pref;
    }

    public DirWriter getDirWriter() {
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFileRef(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        Dataset ds = DirReaderImpl.factory.newDataset();
        try {
            ds.readFile(in, FileFormat.DICOM_FILE, 2145386512);
        }
        finally {
            ((InputStream)in).close();
        }
        return this.addFileRef(this.writer.toFileIDs(file), ds);
    }

    public int addFileRef(String[] fileIDs, Dataset ds) throws IOException {
        FileMetaInfo fmi = ds.getFileMetaInfo();
        if (fmi == null) {
            throw new IllegalArgumentException("Missing File Meta Information");
        }
        String tsUID = fmi.getTransferSyntaxUID();
        if (tsUID == null) {
            throw new IllegalArgumentException("Missing Transfer Syntax UID");
        }
        String classUID = fmi.getMediaStorageSOPClassUID();
        if (classUID == null) {
            throw new IllegalArgumentException("Missing SOP Class UID");
        }
        if (!classUID.equals(ds.getString(524310))) {
            throw new IllegalArgumentException("Mismatch SOP Class UID");
        }
        String type = DirBuilderFactory.getRecordType(classUID);
        Dataset filter = this.pref.getFilterForRecordType(type);
        if (filter == null) {
            return 0;
        }
        String instUID = fmi.getMediaStorageSOPInstanceUID();
        if (instUID == null) {
            throw new IllegalArgumentException("Missing SOP Instance UID");
        }
        if (!instUID.equals(ds.getString(524312))) {
            throw new IllegalArgumentException("Mismatch SOP Instance UID");
        }
        String seriesUID = ds.getString(0x20000E);
        if (seriesUID == null) {
            throw new IllegalArgumentException("Missing Series Instance UID");
        }
        String studyUID = ds.getString(0x20000D);
        if (studyUID == null) {
            throw new IllegalArgumentException("Missing Study Instance UID");
        }
        String patID = ds.getString(0x100020, "");
        int count = 0;
        if (!patID.equals(this.curPatID)) {
            count += this.addPatRec(ds, patID);
        }
        if (!studyUID.equals(this.curStudyUID)) {
            count += this.addStudyRec(ds, studyUID);
        }
        if (!seriesUID.equals(this.curSeriesUID)) {
            count += this.addSeriesRec(ds, seriesUID);
        }
        this.writer.add(this.curSeriesRec, type, ds.subSet(filter), fileIDs, classUID, instUID, tsUID);
        return ++count;
    }

    private int addPatRec(Dataset ds, String patID) throws IOException {
        this.writer.commit();
        this.curSeriesUID = null;
        this.curSeriesRec = null;
        this.curStudyUID = null;
        this.curStudyRec = null;
        this.curPatID = patID;
        for (DirRecord dr = this.writer.getFirstRecord(true); dr != null; dr = dr.getNextSibling(true)) {
            if (!"PATIENT".equals(dr.getType()) || !patID.equals(dr.getDataset().getString(0x100020))) continue;
            this.curPatRec = dr;
            return 0;
        }
        this.curPatRec = this.writer.add(null, "PATIENT", ds.subSet(this.pref.getFilterForRecordType("PATIENT")));
        return 1;
    }

    private int addStudyRec(Dataset ds, String studyUID) throws IOException {
        this.writer.commit();
        this.curSeriesUID = null;
        this.curSeriesRec = null;
        this.curStudyUID = studyUID;
        this.curPatRec.reload();
        for (DirRecord dr = this.curPatRec.getFirstChild(true); dr != null; dr = dr.getNextSibling(true)) {
            if (!"STUDY".equals(dr.getType()) || !studyUID.equals(dr.getDataset().getString(0x20000D))) continue;
            this.curStudyRec = dr;
            return 0;
        }
        this.curStudyRec = this.writer.add(this.curPatRec, "STUDY", ds.subSet(this.pref.getFilterForRecordType("STUDY")));
        return 1;
    }

    private int addSeriesRec(Dataset ds, String seriesUID) throws IOException {
        this.writer.commit();
        this.curSeriesUID = seriesUID;
        this.curStudyRec.reload();
        for (DirRecord dr = this.curStudyRec.getFirstChild(true); dr != null; dr = dr.getNextSibling(true)) {
            if (!"SERIES".equals(dr.getType()) || !seriesUID.equals(dr.getDataset().getString(0x20000E))) continue;
            this.curSeriesRec = dr;
            return 0;
        }
        this.curSeriesRec = this.writer.add(this.curStudyRec, "SERIES", ds.subSet(this.pref.getFilterForRecordType("SERIES")));
        return 1;
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

