/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.dict.VRMap;
import org.dcm4che.dict.VRs;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXHandlerAdapter2
extends DefaultHandler {
    private static final int EXPECT_ELM = 0;
    private static final int EXPECT_VAL_OR_FIRST_ITEM = 1;
    private static final int EXPECT_FRAG = 2;
    private static final int EXPECT_NEXT_ITEM = 3;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final StringBuffer sb = new StringBuffer();
    private final Stack vrStack = new Stack();
    private final Stack idStack = new Stack();
    private final DcmHandler handler;
    private final File baseDir;
    private int vr;
    private int state = 0;
    private String src;

    public SAXHandlerAdapter2(DcmHandler handler, File baseDir) {
        this.handler = handler;
        this.baseDir = baseDir;
    }

    public void startDocument() throws SAXException {
        this.handler.setDcmDecodeParam(DcmDecodeParam.EVR_LE);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.sb.setLength(0);
            this.out.reset();
            if ("attr".equals(qName)) {
                this.onStartElement(attrs.getValue("tag"), attrs.getValue("vr"), attrs.getValue("src"));
            } else if ("item".equals(qName)) {
                this.onStartItem(attrs.getValue("src"));
            } else if ("filemetainfo".equals(qName)) {
                this.handler.startFileMetaInfo(new byte[128]);
            } else if ("dataset".equals(qName)) {
                this.handler.startDataset();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SAXException(qName, ex);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if ("attr".equals(qName)) {
                this.onEndElement();
            } else if ("item".equals(qName)) {
                this.onEndItem();
            } else if ("filemetainfo".equals(qName)) {
                this.handler.endFileMetaInfo();
            } else if ("dataset".equals(qName)) {
                this.handler.endDataset();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SAXException(qName, ex);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            switch (this.state) {
                case 1: {
                    if (this.vr == 21329) {
                        return;
                    }
                }
                case 2: {
                    this.sb.append(ch, start, length);
                    this.parse(false);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SAXException(ex);
        }
    }

    private void onStartElement(String tagStr, String vrStr, String src) throws IOException {
        int tag = (int)Long.parseLong(tagStr, 16);
        this.vr = vrStr == null ? VRMap.DEFAULT.lookup(tag) : VRs.valueOf(vrStr);
        this.handler.startElement(tag, this.vr, -1L);
        this.state = 1;
        this.src = src;
    }

    private void onEndElement() throws IOException {
        switch (this.state) {
            case 1: {
                if (this.vr == 21329) {
                    this.handler.startSequence(0);
                    this.handler.endSequence(0);
                    break;
                }
                byte[] data = this.src != null ? this.readData() : this.getData();
                this.handler.value(data, 0, data.length);
                break;
            }
            case 3: {
                this.handler.endSequence(-1);
                this.vrStack.pop();
                this.idStack.pop();
                break;
            }
            default: {
                throw new IllegalArgumentException("state:" + this.state);
            }
        }
        this.handler.endElement();
        this.state = 0;
    }

    private void onStartItem(String src) throws IOException {
        if (this.state == 1) {
            this.handler.startSequence(-1);
            this.vrStack.push(new Integer(this.vr));
            this.idStack.push(new int[]{0});
        }
        this.src = src;
        int[] nArray = (int[])this.idStack.peek();
        int n = nArray[0] + 1;
        nArray[0] = n;
        int id = n;
        if ((Integer)this.vrStack.peek() == 21329) {
            this.handler.startItem(id, -1L, -1);
            this.state = 0;
        } else {
            this.state = 2;
        }
    }

    private void onEndItem() throws IOException {
        int[] nArray = (int[])this.idStack.peek();
        int n = nArray[0];
        nArray[0] = n - 1;
        int id = n;
        switch (this.state) {
            case 0: {
                this.handler.endItem(-1);
                break;
            }
            case 2: {
                byte[] data = this.src != null ? this.readData() : this.getData();
                this.handler.fragment(id, -1L, data, 0, data.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("state:" + this.state);
            }
        }
        this.state = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readData() throws IOException {
        URL url;
        try {
            url = new URL(this.src);
        }
        catch (MalformedURLException e) {
            url = new URL(this.baseDir.toURL(), this.src);
        }
        URLConnection con = url.openConnection();
        DataInputStream in = new DataInputStream(con.getInputStream());
        try {
            int len = con.getContentLength();
            byte[] data = new byte[len + 1 & 0xFFFFFFFE];
            in.readFully(data, 0, len);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private void parse(boolean last) {
        switch (this.vr) {
            case 16724: {
                this.parseAT(last);
                break;
            }
            case 17996: 
            case 20294: {
                this.parseFL_OF(last);
                break;
            }
            case 17988: {
                this.parseFD(last);
                break;
            }
            case 20290: {
                this.parseOB(last);
                break;
            }
            case 20311: 
            case 21331: 
            case 21843: {
                this.parseOW_SS_US(last);
                break;
            }
            case 21324: 
            case 21836: {
                this.parseSL_UL(last);
                break;
            }
            case 21838: {
                this.parseUN(last);
            }
        }
    }

    private byte[] getData() {
        byte[] data;
        this.parse(true);
        switch (this.vr) {
            case 21329: {
                throw new IllegalStateException("vr:SQ");
            }
            case 16724: 
            case 17988: 
            case 17996: 
            case 20290: 
            case 20294: 
            case 20311: 
            case 21324: 
            case 21331: 
            case 21836: 
            case 21838: 
            case 21843: {
                if ((this.out.size() & 1) != 0) {
                    this.out.write(0);
                }
                data = this.out.toByteArray();
                this.out.reset();
                break;
            }
            default: {
                if ((this.sb.length() & 1) != 0) {
                    this.sb.append(this.vr == 21833 ? (char)'\u0000' : ' ');
                }
                try {
                    data = this.sb.toString().getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                this.sb.setLength(0);
            }
        }
        return data;
    }

    private void parseAT(boolean last) {
        int end;
        if (this.sb.length() == 0) {
            return;
        }
        int begin = 0;
        while ((end = this.sb.indexOf("\\", begin)) != -1) {
            this.writeTag((int)Long.parseLong(this.sb.substring(begin, end), 16));
            begin = end + 1;
        }
        String remain = this.sb.substring(begin);
        this.sb.setLength(0);
        if (last) {
            this.writeTag((int)Long.parseLong(remain, 16));
        } else {
            this.sb.append(remain);
        }
    }

    private void writeTag(int tag) {
        this.out.write(tag >> 16 & 0xFF);
        this.out.write(tag >> 24 & 0xFF);
        this.out.write(tag >> 0 & 0xFF);
        this.out.write(tag >> 8 & 0xFF);
    }

    private void parseFL_OF(boolean last) {
        int end;
        if (this.sb.length() == 0) {
            return;
        }
        int begin = 0;
        while ((end = this.sb.indexOf("\\", begin)) != -1) {
            this.writeInt(Float.floatToIntBits(Float.parseFloat(this.sb.substring(begin, end))));
            begin = end + 1;
        }
        String remain = this.sb.substring(begin);
        this.sb.setLength(0);
        if (last) {
            this.writeInt(Float.floatToIntBits(Float.parseFloat(remain)));
        } else {
            this.sb.append(remain);
        }
    }

    private void writeShort(int s) {
        this.out.write(s >> 0 & 0xFF);
        this.out.write(s >> 8 & 0xFF);
    }

    private void writeInt(int i) {
        this.out.write(i >> 0 & 0xFF);
        this.out.write(i >> 8 & 0xFF);
        this.out.write(i >> 16 & 0xFF);
        this.out.write(i >> 24 & 0xFF);
    }

    private void parseFD(boolean last) {
        int end;
        if (this.sb.length() == 0) {
            return;
        }
        int begin = 0;
        while ((end = this.sb.indexOf("\\", begin)) != -1) {
            this.writeLong(Double.doubleToLongBits(Double.parseDouble(this.sb.substring(begin, end))));
            begin = end + 1;
        }
        String remain = this.sb.substring(begin);
        this.sb.setLength(0);
        if (last) {
            this.writeLong(Double.doubleToLongBits(Double.parseDouble(remain)));
        } else {
            this.sb.append(remain);
        }
    }

    private void writeLong(long l) {
        this.out.write((int)(l >> 0 & 0xFFL));
        this.out.write((int)(l >> 8 & 0xFFL));
        this.out.write((int)(l >> 16 & 0xFFL));
        this.out.write((int)(l >> 24 & 0xFFL));
        this.out.write((int)(l >> 32 & 0xFFL));
        this.out.write((int)(l >> 40 & 0xFFL));
        this.out.write((int)(l >> 48 & 0xFFL));
        this.out.write((int)(l >> 56 & 0xFFL));
    }

    private void parseOB(boolean last) {
        int end;
        if (this.sb.length() == 0) {
            return;
        }
        int begin = 0;
        while ((end = this.sb.indexOf("\\", begin)) != -1) {
            this.out.write(Integer.parseInt(this.sb.substring(begin, end)));
            begin = end + 1;
        }
        String remain = this.sb.substring(begin);
        this.sb.setLength(0);
        if (last) {
            this.out.write(Integer.parseInt(remain));
        } else {
            this.sb.append(remain);
        }
    }

    private void parseUN(boolean last) {
        int begin;
        if (this.sb.length() == 0) {
            return;
        }
        int end = this.sb.length() - 2;
        for (begin = 0; begin < end; ++begin) {
            char ch = this.sb.charAt(begin);
            if (ch != '\\' || this.sb.charAt(++begin) == '\\') {
                this.out.write(ch);
                continue;
            }
            this.out.write(Integer.parseInt(this.sb.substring(begin, begin + 2), 16));
            ++begin;
        }
        String remain = this.sb.substring(begin);
        this.sb.setLength(0);
        if (last) {
            this.out.write(remain.getBytes(), 0, remain.length());
        } else {
            this.sb.append(remain);
        }
    }

    private void parseOW_SS_US(boolean last) {
        int end;
        if (this.sb.length() == 0) {
            return;
        }
        int begin = 0;
        while ((end = this.sb.indexOf("\\", begin)) != -1) {
            this.writeShort(Integer.parseInt(this.sb.substring(begin, end)));
            begin = end + 1;
        }
        String remain = this.sb.substring(begin);
        this.sb.setLength(0);
        if (last) {
            this.writeShort(Integer.parseInt(remain));
        } else {
            this.sb.append(remain);
        }
    }

    private void parseSL_UL(boolean last) {
        int end;
        if (this.sb.length() == 0) {
            return;
        }
        int begin = 0;
        while ((end = this.sb.indexOf("\\", begin)) != -1) {
            this.writeInt((int)Long.parseLong(this.sb.substring(begin, end)));
            begin = end + 1;
        }
        String remain = this.sb.substring(begin);
        this.sb.setLength(0);
        if (last) {
            this.writeInt((int)Long.parseLong(remain));
        } else {
            this.sb.append(remain);
        }
    }
}

