/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.auditlog;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.dcm4che.auditlog.Destination;
import org.dcm4che.auditlog.MediaDescription;
import org.dcm4che.auditlog.Patient;

class MediaDescriptionImpl
implements MediaDescription {
    private String mediaID;
    private String mediaType;
    private LinkedHashSet pats = new LinkedHashSet(3);
    private Destination dest;

    public MediaDescriptionImpl(Patient patient) {
        this.addPatient(patient);
    }

    public void setMediaID(String mediaID) {
        this.mediaID = mediaID;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setDestination(Destination dest) {
        this.dest = dest;
    }

    public final void addPatient(Patient patient) {
        this.pats.add(patient);
    }

    public void writeTo(StringBuffer sb) {
        if (this.mediaID != null) {
            sb.append("<MediaID><![CDATA[").append(this.mediaID).append("]]></MediaID>");
        }
        if (this.mediaType != null) {
            sb.append("<MediaType><![CDATA[").append(this.mediaType).append("]]></MediaType>");
        }
        Iterator it = this.pats.iterator();
        while (it.hasNext()) {
            Patient pat = (Patient)it.next();
            pat.writeTo(sb);
        }
        if (this.dest != null) {
            this.dest.writeTo(sb);
        }
    }
}

