/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.client;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.DataSource;
import org.dcm4che.net.DcmService;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.FutureRSP;
import org.dcm4che.net.PDU;

public class AssociationRequestor {
    private static final AssociationFactory assocFact = AssociationFactory.getInstance();
    private static final DcmObjectFactory dcmFact = DcmObjectFactory.getInstance();
    private static final int ECHO_PCID = 1;
    static final String CONNECTED = "Connected";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String host = "localhost";
    private int port = 104;
    private int acTimeout = 5000;
    private int dimseTimeout = 0;
    private int soCloseDelay = 500;
    private boolean packPDVs = false;
    private AAssociateRQ aarq = assocFact.newAAssociateRQ();
    private DcmServiceRegistry services = assocFact.newDcmServiceRegistry();
    private ActiveAssociation active;
    private final AssociationListener assocListener = new AssociationListener(){

        public void write(Association src, PDU pdu) {
        }

        public void received(Association src, PDU pdu) {
        }

        public void write(Association src, Dimse dimse) {
        }

        public void received(Association src, Dimse dimse) {
        }

        public void error(Association src, IOException ioe) {
        }

        public void closing(Association src) {
        }

        public void closed(Association src) {
            AssociationRequestor.this.pcs.firePropertyChange(AssociationRequestor.CONNECTED, true, false);
            AssociationRequestor.this.active = null;
        }
    };

    public AssociationRequestor() {
        this.aarq.addPresContext(assocFact.newPresContext(1, "1.2.840.10008.1.1"));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean bindService(String uid, DcmService service) {
        return this.services.bind(uid, service);
    }

    public boolean unbindService(String uid) {
        return this.services.unbind(uid);
    }

    public int getMaxPDULength() {
        return this.aarq.getMaxPDULength();
    }

    public void setMaxPDULength(int maxLength) {
        this.aarq.setMaxPDULength(maxLength);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getCalledAET() {
        return this.aarq.getCalledAET();
    }

    public void setCalledAET(String calledAET) {
        this.aarq.setCalledAET(calledAET);
    }

    public String getCallingAET() {
        return this.aarq.getCallingAET();
    }

    public void setCallingAET(String callingAET) {
        this.aarq.setCallingAET(callingAET);
    }

    public int getAcTimeout() {
        return this.acTimeout;
    }

    public void setAcTimeout(int acTimeout) {
        this.acTimeout = acTimeout;
    }

    public int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public void setDimseTimeout(int dimseTimeout) {
        this.dimseTimeout = dimseTimeout;
    }

    public boolean isPackPDVs() {
        return this.packPDVs;
    }

    public void setPackPDVs(boolean packPDVs) {
        this.packPDVs = packPDVs;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public void setSoCloseDelay(int soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public boolean isConnected() {
        return this.active != null;
    }

    public int addPresContext(String asuid, String[] tsuids) {
        int pcid = this.aarq.nextPCID();
        this.aarq.addPresContext(assocFact.newPresContext(pcid, asuid, tsuids));
        return pcid;
    }

    public void removePresContext(int pcid) {
        this.aarq.removePresContext(pcid);
    }

    public synchronized void connect() throws UnknownHostException, IOException {
        if (this.active != null) {
            throw new IllegalStateException("Existing connection: " + this.active);
        }
        Association tmp = assocFact.newRequestor(this.newSocket());
        tmp.setAcTimeout(this.acTimeout);
        tmp.setDimseTimeout(this.dimseTimeout);
        tmp.setSoCloseDelay(this.soCloseDelay);
        tmp.setPackPDVs(this.packPDVs);
        tmp.addAssociationListener(this.assocListener);
        PDU pdu = tmp.connect(this.aarq);
        if (!(pdu instanceof AAssociateAC)) {
            throw new IOException("Association rejected: " + pdu);
        }
        this.active = assocFact.newActiveAssociation(tmp, this.services);
        this.pcs.firePropertyChange(CONNECTED, false, true);
        this.active.start();
    }

    public String getAcceptedTransferSyntaxUID(int pcid) {
        try {
            return this.active.getAssociation().getAcceptedTransferSyntaxUID(pcid);
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("No established Association");
        }
    }

    public Dimse invokeAndWaitForRSP(int pcid, Command cmd) throws InterruptedException, IOException {
        return this.invokeAndWaitForRSP(pcid, cmd, (Dataset)null);
    }

    public Dimse invokeAndWaitForRSP(int pcid, Command cmd, Dataset ds) throws InterruptedException, IOException {
        try {
            Dimse rq = assocFact.newDimse(pcid, cmd, ds);
            FutureRSP f = this.active.invoke(rq);
            return f.get();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("No established Association");
        }
    }

    public Dimse invokeAndWaitForRSP(int pcid, Command cmd, DataSource ds) throws InterruptedException, IOException {
        try {
            Dimse rq = assocFact.newDimse(pcid, cmd, ds);
            FutureRSP f = this.active.invoke(rq);
            return f.get();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("No established Association");
        }
    }

    public int nextMsgID() {
        try {
            return this.active.getAssociation().nextMsgID();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("No established Association");
        }
    }

    public void echo() throws InterruptedException, IOException {
        Command cmd = dcmFact.newCommand().initCEchoRQ(this.nextMsgID());
        this.invokeAndWaitForRSP(1, cmd);
    }

    public synchronized void release() throws InterruptedException, IOException {
        if (this.active != null) {
            this.active.release(true);
        }
    }

    private Socket newSocket() throws UnknownHostException, IOException {
        return new Socket(this.host, this.port);
    }
}

