/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class VerifierDocument<T>
extends PlainDocument {
    T currentValue;

    public T getValue() {
        return this.currentValue;
    }

    @Override
    public void insertString(int offset, String S, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (S == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = S;
        } else {
            String currentContent = this.getText(0, length);
            StringBuffer currentBuffer = new StringBuffer(currentContent);
            currentBuffer.insert(offset, S);
            newValue = currentBuffer.toString();
        }
        this.currentValue = this.checkInput(newValue, offset);
        super.insertString(offset, S, attributes);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        int currentLength = this.getLength();
        String currentContent = this.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = before + after;
        this.currentValue = this.checkInput(newValue, offset);
        super.remove(offset, length);
    }

    private String HankakuNumeric(String S) {
        switch (S.charAt(0)) {
            case '\uff10': {
                return "0";
            }
            case '\uff11': {
                return "1";
            }
            case '\uff12': {
                return "2";
            }
            case '\uff13': {
                return "3";
            }
            case '\uff14': {
                return "4";
            }
            case '\uff15': {
                return "5";
            }
            case '\uff16': {
                return "6";
            }
            case '\uff17': {
                return "7";
            }
            case '\uff18': {
                return "8";
            }
            case '\uff19': {
                return "9";
            }
        }
        return S;
    }

    abstract T checkInput(String var1, int var2) throws BadLocationException;
}

