/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginLoader;
import open.dolphin.plugin.PluginWrapper;

public class PlugInMenuSupport
extends HashMap<String, IPlugin> {
    public void add(IPlugin plugin) {
        PluginWrapper pluginWrapper = new PluginWrapper(plugin);
        this.put(pluginWrapper.getName(), plugin);
    }

    public boolean execute(String name, Object[] request, Object[] response) {
        return ((IPlugin)this.get(name)).dispatchCommand(IPlugin.Command.execute, request, response);
    }

    private void deletePlugins(File source) throws Exception {
        File[] sourceFiles = source.listFiles();
        for (int i = 0; i < sourceFiles.length; ++i) {
            File sourceFile = sourceFiles[i];
            String sourceFileName = sourceFile.getName();
            if (!sourceFileName.substring(sourceFileName.length() - 4, sourceFileName.length()).equals(".jar")) continue;
            sourceFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPlugins(File source, File dist) throws Exception {
        File[] sourceFiles = source.listFiles();
        for (int i = 0; i < sourceFiles.length; ++i) {
            File sourceFile = sourceFiles[i];
            String sourceFileName = sourceFile.getName();
            if (!sourceFileName.substring(sourceFileName.length() - 4, sourceFileName.length()).equals(".jar")) continue;
            FileInputStream sourceStream = null;
            FileOutputStream distStream = null;
            AbstractInterruptibleChannel sourceChannel = null;
            AbstractInterruptibleChannel distChannel = null;
            try {
                sourceStream = new FileInputStream(sourceFile);
                distStream = new FileOutputStream(dist.getAbsolutePath() + File.separator + sourceFile.getName());
                sourceChannel = sourceStream.getChannel();
                distChannel = distStream.getChannel();
                ((FileChannel)sourceChannel).transferTo(0L, ((FileChannel)sourceChannel).size(), (WritableByteChannel)((Object)distChannel));
                continue;
            }
            catch (IOException ex) {
                LogWriter.error(this.getClass(), ex);
                continue;
            }
            finally {
                sourceStream.close();
                distStream.close();
                sourceChannel.close();
                distChannel.close();
            }
        }
    }

    private void movePlugins(File source, File dist) {
        try {
            this.copyPlugins(source, dist);
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
    }

    public boolean installPlugins(String sourcePath, String distPaht) {
        File sourceDir = new File(sourcePath);
        File distDir = new File(distPaht);
        if (sourceDir.exists()) {
            if (!distDir.exists()) {
                distDir.mkdir();
            }
            this.movePlugins(sourceDir, distDir);
            return true;
        }
        return false;
    }

    public void loadPlugins(String path, String classPath) {
        File dir = new File(path);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                try {
                    File file = files[i];
                    String fileName = file.getName();
                    if (!fileName.substring(fileName.length() - 4, fileName.length()).equals(".jar")) continue;
                    PluginLoader loader = new PluginLoader(path + "/" + fileName, classPath + fileName.substring(0, fileName.length() - 4));
                    IPlugin plugin = loader.getPlugin();
                    PluginWrapper pluginWrapper = new PluginWrapper(plugin);
                    this.put(pluginWrapper.getName(), plugin);
                    continue;
                }
                catch (Exception e) {
                    LogWriter.error(this.getClass(), e);
                }
            }
        }
    }

    public void loadPlugin(IPlugin plugin) {
        try {
            PluginWrapper pluginWrapper = new PluginWrapper(plugin);
            this.put(pluginWrapper.getName(), plugin);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }
}

