/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import open.dolphin.helper.IMainCommandAccepter;

public class MainMenuSupport {
    private ActionMap actions;
    private ArrayList<IMainCommandAccepter> chains = new ArrayList();

    public MainMenuSupport(IMainCommandAccepter owner) {
        this.chains.add(owner);
    }

    public void registerActions(ActionMap actions) {
        this.actions = actions;
    }

    public Action getAction(String name) {
        if (this.actions != null) {
            return this.actions.get(name);
        }
        return null;
    }

    public ActionMap getActions() {
        return this.actions;
    }

    public void disableAllMenus() {
        if (this.actions != null) {
            Object[] keys;
            for (Object o : keys = this.actions.keys()) {
                this.actions.get(o).setEnabled(false);
            }
        }
    }

    public void disableMenus(String[] menus) {
        if (this.actions != null && menus != null) {
            for (String name : menus) {
                Action action = this.actions.get(name);
                if (action == null) continue;
                action.setEnabled(false);
            }
        }
    }

    public void enableMenus(String[] menus) {
        if (this.actions != null && menus != null) {
            for (String name : menus) {
                Action action = this.actions.get(name);
                if (action == null) continue;
                action.setEnabled(true);
            }
        }
    }

    public void enabledAction(String name, boolean enabled) {
        Action action;
        if (this.actions != null && (action = this.actions.get(name)) != null) {
            action.setEnabled(enabled);
        }
    }

    public void setLast(IMainCommandAccepter obj) {
        this.chains.add(obj);
    }

    public Object getLast() {
        return this.chains.get(this.chains.size() - 1);
    }

    private boolean execute(IMainCommandAccepter.MainCommand command) {
        for (int index = this.chains.size() - 1; index >= 0; --index) {
            if (!this.chains.get(index).dispatchMainCommand(command)) continue;
            return true;
        }
        return false;
    }

    public boolean openKarteCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.openKarte);
    }

    public boolean printerSetupCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.printerSetup);
    }

    public boolean setKarteEnviromentCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.setKarteEnviroment);
    }

    public boolean showStampBoxCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.showStampBox);
    }

    public boolean showSchemaBoxCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.showSchemaBox);
    }

    public boolean showTemplateEditorCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.showTemplateEditor);
    }

    public boolean changePasswordCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.changePassword);
    }

    public boolean addUserCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.addUser);
    }

    public boolean browseDolphinSupportCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.browseDolphinSupport);
    }

    public boolean browseDolphinProjectCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.browseDolphinProject);
    }

    public boolean browseMedXmlCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.browseMedXml);
    }

    public boolean showAboutCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.showAbout);
    }

    public boolean closeCommandExecute() {
        return this.execute(IMainCommandAccepter.MainCommand.close);
    }

    public boolean close() {
        return false;
    }

    public boolean update() {
        return false;
    }
}

