/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.ModelUtils;

public class KarteHeader {
    private DocumentModel model;
    private StringBuilder buffer = new StringBuilder();
    private String title;

    public KarteHeader(DocumentModel model, String title) {
        this.model = model;
        this.title = title;
    }

    public String toString() {
        String modifyDate;
        this.buffer.append(this.title);
        this.buffer.append(" ");
        DocInfoModel docInfo = this.model.getDocInfo();
        String createDate = ModelUtils.getDateAsFormatString(docInfo.getFirstConfirmDate(), "yyyy-MM-dd'('EEE')'HH:mm");
        if (createDate != null) {
            this.buffer.append(" \u4f5c\u6210\u65e5[");
            this.buffer.append(createDate);
            this.buffer.append(" ]");
        }
        if (docInfo.getParentId() != null && (modifyDate = ModelUtils.getDateAsFormatString(docInfo.getConfirmDate(), "yyyy-MM-dd'('EEE')'HH:mm")) != null) {
            this.buffer.append(" \u66f4\u65b0\u65e5[");
            this.buffer.append(modifyDate);
            this.buffer.append(" ]");
        }
        if (this.model.getCreator() != null) {
            this.buffer.append(" ");
            this.buffer.append(this.model.getCreator().getCommonName());
            this.buffer.append(" ");
            this.buffer.append(this.model.getCreator().getDepartmentModel().getDepartmentDesc());
            this.buffer.append(" ");
            this.buffer.append(this.model.getCreator().getLicenseModel().getLicenseDesc());
        }
        if (docInfo.getStatus().equals("T")) {
            this.buffer.append(" - \u4eee\u4fdd\u5b58\u4e2d");
        }
        return this.buffer.toString();
    }
}

