/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dolphinpeer;

import java.io.BufferedReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import open.dolphin.infomodel.AddressModel;
import open.dolphin.infomodel.BeanUtils;
import open.dolphin.infomodel.HealthInsuranceModel;
import open.dolphin.infomodel.PVTClaim;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.PVTPublicInsuranceItemModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.infomodel.SimpleAddressModel;
import open.dolphin.infomodel.TelephoneModel;
import open.dolphin.log.LogWriter;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class PeerBuilder {
    private static final Namespace mmlCm = Namespace.getNamespace((String)"mmlCm", (String)"http://www.medxml.net/MML/SharedComponent/Common/1.0");
    private static final Namespace mmlNm = Namespace.getNamespace((String)"mmlNm", (String)"http://www.medxml.net/MML/SharedComponent/Name/1.0");
    private static final Namespace mmlFc = Namespace.getNamespace((String)"mmlFc", (String)"http://www.medxml.net/MML/SharedComponent/Facility/1.0");
    private static final Namespace mmlDp = Namespace.getNamespace((String)"mmlDp", (String)"http://www.medxml.net/MML/SharedComponent/Department/1.0");
    private static final Namespace mmlPsi = Namespace.getNamespace((String)"mmlPsi", (String)"http://www.medxml.net/MML/SharedComponent/PersonalizedInfo/1.0");
    private static final Namespace mmlCi = Namespace.getNamespace((String)"mmlCi", (String)"http://www.medxml.net/MML/SharedComponent/CreatorInfo/1.0");
    private static final Namespace mmlHi = Namespace.getNamespace((String)"mmlHi", (String)"http://www.medxml.net/MML/ContentModule/HealthInsurance/1.1");
    private static final Namespace claim = Namespace.getNamespace((String)"claim", (String)"http://www.medxml.net/claim/claimModule/2.1");
    private boolean DERBY;
    private PatientModel patientModel;
    private AddressModel curAddress;
    private TelephoneModel curTelephone;
    private List<PVTHealthInsuranceModel> pvtInsurnaces;
    private PVTHealthInsuranceModel curInsurance;
    private PVTPublicInsuranceItemModel curPublicItem;
    private PVTClaim pvtClaim;
    private String curRepCode;

    public void parse(BufferedReader reader) {
        try {
            SAXBuilder docBuilder = new SAXBuilder();
            Document doc = docBuilder.build((Reader)reader);
            Element root = doc.getRootElement();
            this.parseBody(root.getChild("MmlBody"));
            reader.close();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public PatientVisitModel getProduct() throws SQLException {
        PatientVisitModel model = new PatientVisitModel();
        if (this.patientModel != null) {
            List<TelephoneModel> telephones;
            Iterator i$;
            List<AddressModel> addresses;
            String kana;
            if (this.DERBY) {
                String pid = "D_" + this.patientModel.getPatientId();
                this.patientModel.setPatientId(pid);
            }
            model.setPatient(this.patientModel);
            String fullName = this.patientModel.getFullName();
            fullName = fullName.replace("\u3000", " ");
            this.patientModel.setFullName(fullName);
            int index = fullName.indexOf(" ");
            if (this.patientModel.getFamilyName() == null && index > 0) {
                this.patientModel.setFamilyName(fullName.substring(0, index));
            }
            if (this.patientModel.getGivenName() == null && index > 0) {
                this.patientModel.setGivenName(fullName.substring(index + 1));
            }
            if ((kana = this.patientModel.getKanaName()) != null) {
                kana = kana.replace("\u3000", " ");
                this.patientModel.setKanaName(kana);
                int index2 = kana.indexOf(" ");
                if (this.patientModel.getKanaFamilyName() == null && index2 > 0) {
                    this.patientModel.setKanaFamilyName(kana.substring(0, index2));
                }
                if (this.patientModel.getKanaGivenName() == null && index2 > 0) {
                    this.patientModel.setKanaGivenName(kana.substring(index2 + 1));
                }
            }
            if ((addresses = this.patientModel.getAddresses()) != null && addresses.size() > 0 && (i$ = addresses.iterator()).hasNext()) {
                AddressModel bean = (AddressModel)i$.next();
                String string = bean.getAddress();
                char[] addrc = string.toCharArray();
                StringBuffer addrn = new StringBuffer();
                for (int i = 0; i < string.length(); ++i) {
                    if (addrc[i] == '\u2212') {
                        addrn.append('\u30fc');
                        continue;
                    }
                    addrn.append(addrc[i]);
                }
                String string2 = addrn.toString();
                SimpleAddressModel simple = new SimpleAddressModel();
                simple.setZipCode(bean.getZipCode());
                simple.setAddress(string2);
                this.patientModel.setAddress(simple);
            }
            if ((telephones = this.patientModel.getTelephones()) != null) {
                for (TelephoneModel telephoneModel : telephones) {
                    this.patientModel.setTelephone(telephoneModel.getMemo());
                }
            }
            if (this.pvtInsurnaces != null && this.pvtInsurnaces.size() > 0) {
                for (PVTHealthInsuranceModel pVTHealthInsuranceModel : this.pvtInsurnaces) {
                    HealthInsuranceModel insModel = new HealthInsuranceModel();
                    insModel.setBeanBytes(BeanUtils.xmlEncode(pVTHealthInsuranceModel));
                    this.patientModel.addHealthInsurance(insModel);
                    insModel.setPatient(this.patientModel);
                }
            }
        }
        if (this.pvtClaim != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.pvtClaim.getClaimDeptName());
            sb.append(",");
            sb.append(this.pvtClaim.getClaimDeptCode());
            sb.append(",");
            sb.append(this.pvtClaim.getAssignedDoctorName());
            sb.append(",");
            sb.append(this.pvtClaim.getAssignedDoctorId());
            sb.append(",");
            sb.append(this.pvtClaim.getJmariCode());
            sb.append(",");
            sb.append(this.pvtClaim.getClaimAppMemo());
            model.setDepartment(sb.toString());
            model.setPvtDate(this.pvtClaim.getClaimRegistTime());
            model.setInsuranceUid(this.pvtClaim.getInsuranceUid());
        }
        return model;
    }

    public void parseBody(Element body) {
        List children = body.getChildren("MmlModuleItem");
        for (Element moduleItem : children) {
            Element docInfo = moduleItem.getChild("docInfo");
            Element content = moduleItem.getChild("content");
            String attr = docInfo.getAttributeValue("contentModuleType");
            if (attr.equals("patientInfo")) {
                this.patientModel = new PatientModel();
                this.parsePatientInfo(docInfo, content);
                continue;
            }
            if (attr.equals("healthInsurance")) {
                String uuid = docInfo.getChild("docId").getChildTextTrim("uid");
                if (this.pvtInsurnaces == null) {
                    this.pvtInsurnaces = new ArrayList<PVTHealthInsuranceModel>();
                }
                this.curInsurance = new PVTHealthInsuranceModel();
                this.curInsurance.setGUID(uuid);
                this.pvtInsurnaces.add(this.curInsurance);
                this.parseHealthInsurance(docInfo, content);
                continue;
            }
            if (!attr.equals("claim")) continue;
            this.pvtClaim = new PVTClaim();
            this.parseClaim(docInfo, content);
        }
    }

    private void parsePatientInfo(Element docInfo, Element content) {
        List children = content.getChildren();
        for (Element child : children) {
            String val;
            List attrs;
            String ename = child.getName();
            String qname = child.getQualifiedName();
            if (qname.equals("mmlCm:Id")) {
                String pid = child.getTextTrim();
                this.patientModel.setPatientId(pid);
            } else if (qname.equals("mmlNm:Name")) {
                attrs = child.getAttributes();
                for (Attribute attr : attrs) {
                    if (!attr.getName().equals("repCode")) continue;
                    this.curRepCode = attr.getValue();
                }
            } else if (qname.equals("mmlNm:family")) {
                if (this.curRepCode.equals("P")) {
                    this.patientModel.setKanaFamilyName(child.getTextTrim());
                } else if (this.curRepCode.equals("I")) {
                    this.patientModel.setFamilyName(child.getTextTrim());
                } else if (this.curRepCode.equals("A")) {
                    this.patientModel.setRomanFamilyName(child.getTextTrim());
                }
            } else if (qname.equals("mmlNm:given")) {
                if (this.curRepCode.equals("P")) {
                    this.patientModel.setKanaGivenName(child.getTextTrim());
                } else if (this.curRepCode.equals("I")) {
                    this.patientModel.setGivenName(child.getTextTrim());
                } else if (this.curRepCode.equals("A")) {
                    this.patientModel.setRomanGivenName(child.getTextTrim());
                }
            } else if (qname.equals("mmlNm:fullname")) {
                if (this.curRepCode.equals("P")) {
                    this.patientModel.setKanaName(child.getTextTrim());
                } else if (this.curRepCode.equals("I")) {
                    this.patientModel.setFullName(child.getTextTrim());
                } else if (this.curRepCode.equals("A")) {
                    this.patientModel.setRomanName(child.getTextTrim());
                }
            } else if (qname.equals("mmlPi:birthday")) {
                this.patientModel.setBirthday(child.getTextTrim());
            } else if (qname.equals("mmlPi:sex")) {
                this.patientModel.setGender(child.getTextTrim());
            } else if (qname.equals("mmlAd:Address")) {
                this.curAddress = new AddressModel();
                this.patientModel.addAddress(this.curAddress);
                attrs = child.getAttributes();
                for (Attribute attr : attrs) {
                    if (attr.getName().equals("addressClass")) {
                        this.curRepCode = attr.getValue();
                        this.curAddress.setAddressType(attr.getValue());
                        continue;
                    }
                    if (!attr.getName().equals("tableId")) continue;
                    this.curAddress.setAddressTypeCodeSys(attr.getValue());
                }
            } else if (qname.equals("mmlAd:full")) {
                this.curAddress.setAddress(child.getTextTrim());
            } else if (qname.equals("mmlAd:zip")) {
                this.curAddress.setZipCode(child.getTextTrim());
            } else if (qname.equals("mmlPh:Phone")) {
                this.curTelephone = new TelephoneModel();
                this.patientModel.addTelephone(this.curTelephone);
            } else if (qname.equals("mmlPh:area")) {
                val = child.getTextTrim();
                if (val != null && !val.startsWith("?")) {
                    this.curTelephone.setArea(child.getTextTrim());
                }
            } else if (qname.equals("mmlPh:city")) {
                val = child.getTextTrim();
                if (val != null && !val.startsWith("?")) {
                    this.curTelephone.setCity(val);
                }
            } else if (qname.equals("mmlPh:number")) {
                val = child.getTextTrim();
                if (val != null && !val.startsWith("?")) {
                    this.curTelephone.setNumber(val);
                }
            } else if (qname.equals("mmlPh:memo")) {
                this.curTelephone.setMemo(child.getTextTrim());
            }
            this.parsePatientInfo(docInfo, child);
        }
    }

    private void parseHealthInsurance(Element docInfo, Element content) {
        Element publicInsurance;
        Element clientId;
        Element hModule = content.getChild("HealthInsuranceModule", mmlHi);
        if (hModule == null) {
            return;
        }
        Element insuranceClass = hModule.getChild("insuranceClass", mmlHi);
        if (insuranceClass != null) {
            this.curInsurance.setInsuranceClass(insuranceClass.getTextTrim());
            if (insuranceClass.getAttribute("ClassCode", mmlHi) != null) {
                this.curInsurance.setInsuranceClassCode(insuranceClass.getAttributeValue("ClassCode", mmlHi));
            }
            if (insuranceClass.getAttribute("tableId", mmlHi) != null) {
                this.curInsurance.setInsuranceClassCodeSys(insuranceClass.getAttributeValue("tableId", mmlHi));
            }
        }
        if (hModule.getChildTextTrim("insuranceNumber", mmlHi) != null) {
            this.curInsurance.setInsuranceNumber(hModule.getChildTextTrim("insuranceNumber", mmlHi));
        }
        if ((clientId = hModule.getChild("clientId", mmlHi)) != null) {
            if (clientId.getChild("group", mmlHi) != null) {
                this.curInsurance.setClientGroup(clientId.getChildTextTrim("group", mmlHi));
            }
            if (clientId.getChild("number", mmlHi) != null) {
                this.curInsurance.setClientNumber(clientId.getChildTextTrim("number", mmlHi));
            }
        }
        if (hModule.getChild("familyClass", mmlHi) != null) {
            this.curInsurance.setFamilyClass(hModule.getChildTextTrim("familyClass", mmlHi));
        }
        if (hModule.getChild("startDate", mmlHi) != null) {
            this.curInsurance.setStartDate(hModule.getChildTextTrim("startDate", mmlHi));
        }
        if (hModule.getChild("expiredDate", mmlHi) != null) {
            this.curInsurance.setExpiredDate(hModule.getChildTextTrim("expiredDate", mmlHi));
        }
        if (hModule.getChild("paymentInRatio", mmlHi) != null) {
            this.curInsurance.setPayInRatio(hModule.getChildTextTrim("paymentInRatio", mmlHi));
        }
        if (hModule.getChild("paymentOutRatio", mmlHi) != null) {
            this.curInsurance.setPayOutRatio(hModule.getChildTextTrim("paymentOutRatio", mmlHi));
        }
        if ((publicInsurance = hModule.getChild("publicInsurance", mmlHi)) != null) {
            List children = publicInsurance.getChildren();
            for (Element publicInsuranceItem : children) {
                Element paymentRatio;
                this.curPublicItem = new PVTPublicInsuranceItemModel();
                this.curInsurance.addPvtPublicInsuranceItem(this.curPublicItem);
                if (publicInsuranceItem.getAttribute("priority", mmlHi) != null) {
                    this.curPublicItem.setPriority(publicInsuranceItem.getAttributeValue("priority", mmlHi));
                }
                if (publicInsuranceItem.getChild("providerName", mmlHi) != null) {
                    this.curPublicItem.setProviderName(publicInsuranceItem.getChildTextTrim("providerName", mmlHi));
                }
                if (publicInsuranceItem.getChild("provider", mmlHi) != null) {
                    this.curPublicItem.setProvider(publicInsuranceItem.getChildTextTrim("provider", mmlHi));
                }
                if (publicInsuranceItem.getChild("recipient", mmlHi) != null) {
                    this.curPublicItem.setRecipient(publicInsuranceItem.getChildTextTrim("recipient", mmlHi));
                }
                if (publicInsuranceItem.getChild("startDate", mmlHi) != null) {
                    this.curPublicItem.setStartDate(publicInsuranceItem.getChildTextTrim("startDate", mmlHi));
                }
                if (publicInsuranceItem.getChild("expiredDate", mmlHi) != null) {
                    this.curPublicItem.setExpiredDate(publicInsuranceItem.getChildTextTrim("expiredDate", mmlHi));
                }
                if ((paymentRatio = publicInsuranceItem.getChild("paymentRatio", mmlHi)) == null) continue;
                this.curPublicItem.setPaymentRatio(paymentRatio.getTextTrim());
                if (paymentRatio.getAttribute("ratioType", mmlHi) == null) continue;
                this.curPublicItem.setPaymentRatioType(paymentRatio.getAttributeValue("ratioType", mmlHi));
            }
        }
    }

    private void parseClaim(Element docInfo, Element content) {
        Element fullName;
        Element creatorInfo = docInfo.getChild("CreatorInfo", mmlCi);
        Element psiInfo = creatorInfo.getChild("PersonalizedInfo", mmlPsi);
        this.pvtClaim.setAssignedDoctorId(psiInfo.getChildTextTrim("Id", mmlCm));
        Element personName = psiInfo.getChild("personName", mmlPsi);
        Element name = personName.getChild("Name", mmlNm);
        if (name != null && (fullName = name.getChild("fullname", mmlNm)) != null) {
            this.pvtClaim.setAssignedDoctorName(fullName.getTextTrim());
        }
        Element facility = psiInfo.getChild("Facility", mmlFc);
        this.pvtClaim.setJmariCode(facility.getChildTextTrim("Id", mmlCm));
        Element dept = psiInfo.getChild("Department", mmlDp);
        this.pvtClaim.setClaimDeptName(dept.getChildTextTrim("name", mmlDp));
        this.pvtClaim.setClaimDeptCode(dept.getChildTextTrim("Id", mmlCm));
        Element claimModule = content.getChild("ClaimModule", claim);
        Element claimInfo = claimModule.getChild("information", claim);
        this.pvtClaim.setClaimStatus(claimInfo.getAttributeValue("status", claim));
        this.pvtClaim.setClaimRegistTime(claimInfo.getAttributeValue("registTime", claim));
        this.pvtClaim.setClaimAdmitFlag(claimInfo.getAttributeValue("admitFlag", claim));
        this.pvtClaim.setInsuranceUid(claimInfo.getAttributeValue("insuranceUid", claim));
        String memo = claimInfo.getChild("appoint", claim).getChild("memo", claim).getText().trim();
        this.pvtClaim.setClaimAppMemo(memo);
    }
}

