/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dolphinpeer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import open.dolphin.client.IMainService;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.MmlMessageEvent;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

public class DolphinPeerClient
implements IMainService {
    private String csgwPath;
    private String encoding;
    private LinkedBlockingQueue queue;
    private Kicker kicker;
    private Thread sendThread;
    private IMainWindow context;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    public String getCSGWPath() {
        return this.csgwPath;
    }

    public void setCSGWPath(String val) {
        this.csgwPath = val;
        File directory = new File(this.csgwPath);
        if (directory.exists() || directory.mkdirs()) {
            // empty if block
        }
    }

    @Override
    public void stop() {
        try {
            Thread moribund = this.sendThread;
            this.sendThread = null;
            moribund.interrupt();
            this.logDump();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    @Override
    public void start() {
        this.setCSGWPath(GlobalVariables.getCSGWPath());
        this.encoding = GlobalVariables.getMMLEncoding();
        this.queue = new LinkedBlockingQueue();
        this.kicker = new Kicker();
        this.sendThread = new Thread(this.kicker);
        this.sendThread.start();
    }

    public void mmlMessageEvent(MmlMessageEvent e) {
        this.queue.offer(e);
    }

    public Object getMML() throws InterruptedException {
        return this.queue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDump() {
        LinkedBlockingQueue linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            int size = this.queue.size();
            if (size != 0) {
                for (int i = 0; i < size; ++i) {
                    try {
                        MmlMessageEvent evt = (MmlMessageEvent)this.queue.take();
                        continue;
                    }
                    catch (Exception e) {
                        LogWriter.error(this.getClass(), e);
                    }
                }
            }
        }
    }

    protected String getCSGWPathname(String fileName, String ext) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.csgwPath);
        buf.append(File.separator);
        buf.append(fileName);
        buf.append(".");
        buf.append(ext);
        return buf.toString();
    }

    protected class Kicker
    implements Runnable {
        protected Kicker() {
        }

        @Override
        public void run() {
            Thread thisThread = Thread.currentThread();
            BufferedOutputStream writer = null;
            while (thisThread == DolphinPeerClient.this.sendThread) {
                try {
                    MmlMessageEvent mevt = (MmlMessageEvent)DolphinPeerClient.this.getMML();
                    String groupId = mevt.getGroupId();
                    String instance = mevt.getMmlInstance();
                    List<SchemaModel> schemas = mevt.getSchema();
                    String dest = DolphinPeerClient.this.getCSGWPathname(groupId, "xml");
                    String temp = DolphinPeerClient.this.getCSGWPathname(groupId, "xml.tmp");
                    File f = new File(temp);
                    writer = new BufferedOutputStream(new FileOutputStream(f));
                    byte[] bytes = instance.getBytes(DolphinPeerClient.this.encoding);
                    writer.write(bytes);
                    writer.flush();
                    writer.close();
                    f.renameTo(new File(dest));
                    if (schemas == null) continue;
                    for (SchemaModel schema : schemas) {
                        dest = DolphinPeerClient.this.csgwPath + File.separator + schema.getExtRef().getHref();
                        temp = dest + ".tmp";
                        f = new File(temp);
                        writer = new BufferedOutputStream(new FileOutputStream(f));
                        writer.write(schema.getJpegBytes());
                        writer.flush();
                        writer.close();
                        f.renameTo(new File(dest));
                    }
                }
                catch (IOException e) {
                    LogWriter.error(this.getClass(), e);
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
        }
    }
}

