/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.util.List;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import open.dolphin.delegater.DelegaterErrorHandler;
import open.dolphin.infomodel.UserModel;
import open.dolphin.project.DolphinPrincipal;
import open.dolphin.service.IUserService;

public abstract class UserDelegater
extends DelegaterErrorHandler {
    protected abstract IUserService getService() throws NamingException;

    public List<UserModel> getAllUser() {
        try {
            return this.getService().getAllUser();
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public UserModel getUser(String pk) {
        try {
            return this.getService().getUser(pk);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public abstract UserModel login(DolphinPrincipal var1, String var2) throws LoginException;

    public int putUser(UserModel userModel) {
        try {
            return this.getService().addUser(userModel);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public int removeUser(String uid) {
        try {
            return this.getService().removeUser(uid);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public int updateFacility(UserModel user) {
        try {
            return this.getService().updateFacility(user);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public int updateUser(UserModel userModel) {
        try {
            return this.getService().updateUser(userModel);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }
}

