/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import open.dolphin.client.IChart;
import open.dolphin.delegater.DelegaterErrorHandler;
import open.dolphin.dto.PatientVisitSpec;
import open.dolphin.infomodel.HealthInsuranceModel;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.service.IPvtService;

public abstract class PVTDelegater
extends DelegaterErrorHandler {
    protected abstract IPvtService getService() throws NamingException;

    public int addPvt(PatientVisitModel pvtModel) {
        try {
            return this.getService().addPvt(pvtModel);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public List<PatientVisitModel> getPvt(String[] date, int firstRecord) {
        PatientVisitSpec spec = new PatientVisitSpec();
        spec.setDate(date[0]);
        spec.setAppodateFrom(date[1]);
        spec.setAppodateTo(date[2]);
        spec.setSkipCount(firstRecord);
        try {
            List<PatientVisitModel> patients = this.getService().getPvt(spec);
            if (patients == null) {
                return null;
            }
            for (PatientVisitModel model : patients) {
                PatientModel patient = model.getPatient();
                this.decodeHealthInsurance(patient);
            }
            return patients;
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public int removePvt(long id) {
        try {
            return this.getService().removePvt(id);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    public int updatePvtState(long pk, IChart.state state2) {
        try {
            return this.getService().updatePvtState(pk, state2);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0;
        }
    }

    private void decodeHealthInsurance(PatientModel patient) {
        Set<HealthInsuranceModel> c = patient.getHealthInsurances();
        if (c != null) {
            ArrayList<PVTHealthInsuranceModel> list = new ArrayList<PVTHealthInsuranceModel>(c.size());
            for (HealthInsuranceModel model : c) {
                try {
                    PVTHealthInsuranceModel hModel = model.toInfoModel();
                    list.add(hModel);
                }
                catch (Exception e) {
                    this.dispatchError(this.getClass(), e, "");
                }
            }
            patient.setPvtHealthInsurances(list);
            patient.getHealthInsurances().clear();
            patient.setHealthInsurances(null);
        }
    }
}

