/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import open.dolphin.client.settings.AreaNetWorkSettingPanel;
import open.dolphin.client.settings.BrowserSettingPanel;
import open.dolphin.client.settings.ClaimSettingPanel;
import open.dolphin.client.settings.CodeHelperSettingPanel;
import open.dolphin.client.settings.DirectionSettingPanel;
import open.dolphin.client.settings.HostSettingPanel;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.KarteSettingPanel;
import open.dolphin.client.settings.PluginsSettingPanel;
import open.dolphin.client.settings.SendMmlSettingPanel;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.utils.Adapter;

public class SettingDialog
extends JDialog
implements PropertyChangeListener {
    private boolean loginState;
    private PlugInMenuSupport plugins;
    private List<IAbstractSettingPanel> panels;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JTabbedPane jTabbedPane1;
    private JButton okButton;

    public SettingDialog(Frame parent, boolean modal, PlugInMenuSupport plugins) {
        super(parent, modal);
        this.initComponents();
        this.plugins = plugins;
        this.panels = new ArrayList<IAbstractSettingPanel>();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u8a2d\u5b9a");
        this.setResizable(false);
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jPanel1.setName("jPanel1");
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.setRequestFocusEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("jButton1");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.setRequestFocusEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(255, Short.MAX_VALUE).addComponent(this.okButton).addGap(64, 64, 64).addComponent(this.cancelButton).addGap(220, 220, 220)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, -2, 21, -2).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jTabbedPane1, -1, 725, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 626, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        for (IAbstractSettingPanel panel : this.panels) {
            panel.save();
        }
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
    }

    public boolean getLoginState() {
        return this.loginState;
    }

    public void setLoginState(boolean b) {
        this.loginState = b;
    }

    public void start() {
        this.addPanel(new HostSettingPanel());
        this.addPanel(new ClaimSettingPanel());
        this.addPanel(new AreaNetWorkSettingPanel());
        this.addPanel(new SendMmlSettingPanel());
        this.addPanel(new KarteSettingPanel());
        this.addPanel(new CodeHelperSettingPanel());
        this.addPanel(new BrowserSettingPanel());
        this.addPanel(new PluginsSettingPanel());
        this.addPanel(new DirectionSettingPanel());
        for (IPlugin plugin : this.plugins.values()) {
            PluginWrapper pluginWrapper = new PluginWrapper(plugin);
            IAbstractSettingPanel panel = pluginWrapper.configure();
            if (panel == null) continue;
            this.addPanel(panel);
        }
        this.CallBackEnable();
    }

    private void addPanel(IAbstractSettingPanel panel) {
        panel.start();
        this.panels.add(panel);
        this.jTabbedPane1.add(panel.getTitle(), (Component)((Object)panel));
    }

    private void CallBackEnable() {
        for (IAbstractSettingPanel panel : this.panels) {
            panel.onChenge(new Adapter<Boolean, Boolean>(){

                @Override
                public Boolean onResult(Boolean input) throws Exception {
                    return true;
                }
            });
        }
    }

    private void CallBackDisable() {
        for (IAbstractSettingPanel panel : this.panels) {
            panel.onChenge(new Adapter<Boolean, Boolean>(){

                @Override
                public Boolean onResult(Boolean input) throws Exception {
                    return true;
                }
            });
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean enabled = true;
        for (IAbstractSettingPanel panel : this.panels) {
            if (panel.getState() != IAbstractSettingPanel.State.INVALID_STATE) continue;
            enabled = false;
            break;
        }
        this.okButton.setEnabled(enabled);
    }
}

