/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.RegexConstrainedDocument;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.log.LogWriter;
import open.dolphin.project.DolphinPrincipal;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.Adapter;
import open.dolphin.utils.UserDirectoryInitializer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;

public class HostSettingPanel
extends JPanel
implements IAbstractSettingPanel {
    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    protected IAbstractSettingPanel.State state = IAbstractSettingPanel.State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String DEFAULT_FACILITY_OID = "1.3.6.1.4.1.9414.10.1";
    private String ipAddressPattern = "[A-Za-z0-9.\\-_]*";
    private static final String ID = "hostSetting";
    private static final String TITLE = "\u30b5\u30fc\u30d0";
    private static final String ICON = "server.png";
    private int hostPort = 1099;
    private ServerModel model;
    private StateMgr stateMgr;
    private Adapter<Boolean, Boolean> adapter;
    private JTextField dbAddressField;
    private JPasswordField dbPasswordField;
    private JButton fetchButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel sip;
    private JRadioButton sslState;
    private JPanel uip;
    private JTextField userIdField;

    public HostSettingPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        if (GlobalSettings.isTrial()) {
            this.sslState.setVisible(false);
        }
        if (GlobalSettings.isTrial()) {
            this.fetchButton.setVisible(false);
        }
        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
    }

    private void initComponents() {
        this.sip = new JPanel();
        this.jLabel1 = new JLabel();
        this.dbAddressField = new JTextField();
        this.jLabel2 = new JLabel();
        this.dbPasswordField = new JPasswordField();
        this.jPanel1 = new JPanel();
        this.sslState = new JRadioButton();
        this.fetchButton = new JButton();
        this.uip = new JPanel();
        this.jLabel3 = new JLabel();
        this.userIdField = new JTextField();
        this.setPreferredSize(new Dimension(500, 305));
        this.sip.setBorder(BorderFactory.createTitledBorder("\u30b5\u30fc\u30d0\u60c5\u5831"));
        this.sip.setName("sip");
        this.sip.setPreferredSize(new Dimension(500, 199));
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setName("jLabel1");
        this.dbAddressField.setName("dbAddressField");
        this.dbAddressField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostSettingPanel.this.dbAddressFieldActionPerformed(evt);
            }
        });
        this.dbAddressField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HostSettingPanel.this.propertyChange(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setName("jLabel2");
        this.dbPasswordField.setName("dbPasswordField");
        this.dbPasswordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostSettingPanel.this.dbPasswordFieldActionPerformed(evt);
            }
        });
        this.dbPasswordField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HostSettingPanel.this.propertyChange(evt);
            }
        });
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new GridLayout(1, 0));
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(HostSettingPanel.class, (Object)this);
        this.sslState.setAction(actionMap.get("enableKeyStoreFetch"));
        this.sslState.setText("SSL\u3092\u4f7f\u7528");
        this.sslState.setName("sslState");
        this.sslState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostSettingPanel.this.sslStateActionPerformed(evt);
            }
        });
        this.sslState.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HostSettingPanel.this.sslStatePropertyChange(evt);
            }
        });
        this.fetchButton.setAction(actionMap.get("fetchKeyStore"));
        this.fetchButton.setFont(new Font("VL \u30b4\u30b7\u30c3\u30af", 0, 12));
        this.fetchButton.setText("...");
        this.fetchButton.setName("fetchButton");
        GroupLayout sipLayout = new GroupLayout(this.sip);
        this.sip.setLayout(sipLayout);
        sipLayout.setHorizontalGroup(sipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sipLayout.createSequentialGroup().addContainerGap().addGroup(sipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sipLayout.createSequentialGroup().addComponent(this.jLabel2, -2, 159, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sipLayout.createSequentialGroup().addComponent(this.sslState, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fetchButton, -2, 64, -2)).addComponent(this.dbPasswordField, -1, 165, Short.MAX_VALUE))).addGroup(sipLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 159, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dbAddressField, -1, 165, Short.MAX_VALUE)).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -2, 109, -2)).addContainerGap()));
        sipLayout.setVerticalGroup(sipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sipLayout.createSequentialGroup().addContainerGap().addGroup(sipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 26, -2).addComponent(this.dbAddressField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.dbPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sipLayout.createSequentialGroup().addComponent(this.fetchButton, -1, -1, Short.MAX_VALUE).addContainerGap(25, Short.MAX_VALUE)).addGroup(sipLayout.createSequentialGroup().addComponent(this.sslState).addContainerGap()))));
        this.uip.setBorder(BorderFactory.createTitledBorder("\u30e6\u30fc\u30b6\u60c5\u5831"));
        this.uip.setName("uip");
        this.uip.setPreferredSize(new Dimension(500, 79));
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("\u30e6\u30fc\u30b6ID:");
        this.jLabel3.setName("jLabel3");
        this.userIdField.setColumns(10);
        this.userIdField.setName("userIdField");
        this.userIdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostSettingPanel.this.userIdFieldActionPerformed(evt);
            }
        });
        this.userIdField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HostSettingPanel.this.propertyChange(evt);
            }
        });
        GroupLayout uipLayout = new GroupLayout(this.uip);
        this.uip.setLayout(uipLayout);
        uipLayout.setHorizontalGroup(uipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(uipLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userIdField, -2, 108, -2).addContainerGap(70, Short.MAX_VALUE)));
        uipLayout.setVerticalGroup(uipLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(uipLayout.createSequentialGroup().addContainerGap().addGroup(uipLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.userIdField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.uip, GroupLayout.Alignment.LEADING, -1, 372, Short.MAX_VALUE).addComponent(this.sip, GroupLayout.Alignment.LEADING, -1, 372, Short.MAX_VALUE)).addContainerGap(128, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sip, -2, 169, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.uip, -2, 79, -2).addGap(63, 63, 63)));
    }

    private void dbAddressFieldActionPerformed(ActionEvent evt) {
    }

    private void userIdFieldActionPerformed(ActionEvent evt) {
        this.change();
    }

    private void dbPasswordFieldActionPerformed(ActionEvent evt) {
    }

    private void sslStateActionPerformed(ActionEvent evt) {
        this.change();
    }

    private void sslStatePropertyChange(PropertyChangeEvent evt) {
        this.enableKeyStoreFetch();
    }

    private void propertyChange(PropertyChangeEvent evt) {
        this.change();
    }

    @Override
    public void onChenge(Adapter<Boolean, Boolean> adapter) {
        this.adapter = adapter;
    }

    private void change() {
        if (this.adapter != null) {
            try {
                this.adapter.onResult(true);
            }
            catch (Exception ex) {
                LogWriter.error(this.getClass(), ex);
            }
        }
    }

    @Override
    public void start() {
        this.model = new ServerModel();
        this.model.populate();
        this.initCustomComponents();
        this.connect();
        this.bindModelToView();
    }

    private void initCustomComponents() {
        if (GlobalSettings.isTrial()) {
            this.jLabel1.setText("DB\u30a2\u30c9\u30ec\u30b9:\u7de8\u96c6\u4e0d\u53ef");
            this.jLabel2.setText("DB\u30d1\u30b9\u30ef\u30fc\u30c9:\u7de8\u96c6\u4e0d\u53ef");
        } else {
            this.jLabel1.setText("DB\u30a2\u30c9\u30ec\u30b9:");
            this.jLabel2.setText("DB\u30d1\u30b9\u30ef\u30fc\u30c9:");
        }
        RegexConstrainedDocument hostDoc = new RegexConstrainedDocument(this.ipAddressPattern);
        RegexConstrainedDocument dbDoc = new RegexConstrainedDocument(this.ipAddressPattern);
        this.dbAddressField.setDocument(dbDoc);
        if (GlobalSettings.isTrial()) {
            this.dbAddressField.setVisible(false);
            this.dbPasswordField.setVisible(false);
        }
    }

    private void connect() {
        this.stateMgr = new StateMgr();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HostSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HostSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HostSettingPanel.this.stateMgr.checkState();
            }
        };
        this.dbAddressField.getDocument().addDocumentListener(dl);
        this.userIdField.getDocument().addDocumentListener(dl);
        this.dbAddressField.addFocusListener(AutoRomanListener.getInstance());
        this.userIdField.addFocusListener(AutoRomanListener.getInstance());
        if (this.isLoginState()) {
            this.userIdField.setEnabled(false);
            this.dbAddressField.setEnabled(false);
        }
    }

    private void bindModelToView() {
        String val = this.model.getUserId();
        val = val != null ? val : "";
        this.userIdField.setText(val);
        GlobalVariables.UserType userType = this.model.getUserType();
        switch (userType) {
            case FACILITY_USER: {
                val = val != null ? val : "";
                val = this.model.getDbAddress();
                val = val != null ? val : "";
                this.dbAddressField.setText(val);
                this.sslState.setSelected(this.model.getDbSSLState());
                if (this.model.getPort() == 0) break;
                this.hostPort = this.model.getPort();
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
    }

    private void bindViewToModel() {
        String facilityId = DEFAULT_FACILITY_OID;
        String userId = this.userIdField.getText().trim();
        String dbAddress = this.dbAddressField.getText().trim();
        char[] pass = this.dbPasswordField.getPassword();
        String dbPassword = new String(pass);
        for (int i = 0; i < pass.length; ++i) {
            pass[i] = '\u0000';
        }
        pass = null;
        dbPassword = dbPassword.trim();
        this.model.setFacilityId(facilityId);
        this.model.setUserId(userId);
        this.model.setDbAddress(dbAddress);
        if (!dbPassword.equals("")) {
            this.model.setDbPassword(dbPassword);
            dbPassword = null;
        }
        this.model.setDbSSLState(this.sslState.isSelected());
        this.model.setUserType(GlobalVariables.UserType.FACILITY_USER);
        this.model.setPort(this.hostPort);
    }

    @Override
    public void save() {
        this.bindViewToModel();
        this.model.restore();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return this.context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener("stateProp", context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return this.loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        this.loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    @Override
    public void setState(IAbstractSettingPanel.State state2) {
        this.state = state2;
        this.boundSupport.firePropertyChange("stateProp", null, (Object)this.state);
    }

    @Override
    public IAbstractSettingPanel.State getState() {
        return this.state;
    }

    @Action
    public void fetchKeyStore() {
        ApplicationContext appContext = GlobalConstants.getApplicationContext();
        File userPath = appContext.getLocalStorage().getDirectory();
        File trustStorePath = new File(userPath, "security/dolphin.trustStore");
        UserDirectoryInitializer.fetchTrustStore(trustStorePath);
        this.change();
    }

    @Action
    public void enableKeyStoreFetch() {
        this.fetchButton.setEnabled(this.sslState.isSelected());
    }

    class StateMgr {
        StateMgr() {
        }

        public void checkState() {
            IAbstractSettingPanel.State newState;
            IAbstractSettingPanel.State state2 = newState = this.isValid() ? IAbstractSettingPanel.State.VALID_STATE : IAbstractSettingPanel.State.INVALID_STATE;
            if (newState != HostSettingPanel.this.state) {
                HostSettingPanel.this.setState(newState);
            }
        }

        private boolean isValid() {
            boolean isNotUserIdEmpty = !HostSettingPanel.this.userIdField.getText().trim().equals("");
            boolean isNotDbAddressEmpty = !HostSettingPanel.this.dbAddressField.getText().trim().equals("");
            return isNotUserIdEmpty && isNotDbAddressEmpty;
        }
    }

    class ServerModel {
        private GlobalVariables.UserType userType;
        private String dbAddress;
        private String dbPassword;
        private boolean dbSSLState;
        private int port;
        private String facilityId;
        private String userId;

        public void populate() {
            this.setUserId(GlobalVariables.getUserId());
            this.setFacilityId(GlobalVariables.getFacilityId());
            this.setUserType(GlobalVariables.getUserType());
            this.setDbAddress(GlobalVariables.getDbAddress());
            this.setDbPassword(GlobalVariables.getDbPasswordWithoutHash());
            this.setDbSSLState(GlobalVariables.getDbSSLState());
            this.setPort(GlobalVariables.getHostPort());
        }

        public void restore() {
            GlobalVariables.setFacilityId(this.getFacilityId());
            GlobalVariables.setUserId(this.getUserId());
            DolphinPrincipal principal = new DolphinPrincipal();
            principal.setFacilityId(this.getFacilityId());
            principal.setUserId(this.getUserId());
            GlobalVariables.setDolphinPrincipal(principal);
            GlobalVariables.setUserType(this.getUserType());
            GlobalVariables.setDbAddress(this.getDbAddress());
            GlobalVariables.setDbPassword(this.getDbPassword());
            GlobalVariables.setDbSSLState(this.getDbSSLState());
            GlobalVariables.setHostPort(this.getPort());
        }

        public GlobalVariables.UserType getUserType() {
            return this.userType;
        }

        public void setUserType(GlobalVariables.UserType userType) {
            this.userType = userType;
        }

        public String getDbAddress() {
            return this.dbAddress;
        }

        public void setDbAddress(String dbAddress) {
            this.dbAddress = dbAddress;
        }

        public String getDbPassword() {
            return this.dbPassword;
        }

        public void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        public boolean getDbSSLState() {
            return this.dbSSLState;
        }

        public void setDbSSLState(boolean state2) {
            this.dbSSLState = state2;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getFacilityId() {
            return this.facilityId;
        }

        public void setFacilityId(String facilityId) {
            this.facilityId = facilityId;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }
    }
}

