/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.schemaeditor;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.schemaeditor.AreaHolder;
import open.dolphin.client.schemaeditor.IDrawingHolder;
import open.dolphin.client.schemaeditor.Line2DHolder;
import open.dolphin.client.schemaeditor.SchemaCanvas;
import open.dolphin.client.schemaeditor.SchemaDialog;
import open.dolphin.client.schemaeditor.ShapeIconMaker;
import open.dolphin.client.schemaeditor.TextHolder;
import open.dolphin.infomodel.ExtRefModel;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import org.jdesktop.application.ApplicationContext;

public class SchemaEditorImpl {
    private static final float DEFAULT_LINE_WIDTH = 4.0f;
    private static final Color DEFAULT_FILL_COLOR = Color.RED;
    private static final float DEFAULT_ALPHA = 0.5f;
    private static final int DEFAULT_TEXT_SIZE = 24;
    private static final String DEFAULT_FONT_NAME = "Dialog";
    private static final String TITLE = "\u30b7\u30a7\u30fc\u30de\u30a8\u30c7\u30a3\u30bf";
    private static final String DEFAULT_ROLE = "\u53c2\u8003\u56f3";
    private static final String DEFAULT_TITLE = "\u53c2\u8003\u753b\u50cf";
    private SchemaModel model;
    protected Image srcImage;
    private Insets margin;
    protected List<IDrawingHolder> drawingList;
    private float lineWidth = 4.0f;
    private Color fillColor = DEFAULT_FILL_COLOR;
    private float alpha = 0.5f;
    private String fontName = "Dialog";
    private int fontStyle = 1;
    private int textSize = 24;
    private boolean outline = false;
    private SchemaCanvas canvas;
    private SchemaDialog view;
    private JPanel canvasPanel;
    private StateMgr stateMgr;
    private boolean editable;
    private PropertyChangeSupport boundSupport;

    public void setSchema(SchemaModel model) {
        this.model = model;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public void start() {
        if (this.editable) {
            this.initCustomComponents();
        } else {
            this.initCustomComponentsUneditable();
        }
    }

    private BufferedImage createImage() {
        BufferedImage result = null;
        try {
            int width = this.srcImage.getWidth(null);
            int height = this.srcImage.getHeight(null);
            width = this.margin != null ? width + this.margin.left + this.margin.right : width;
            height = this.margin != null ? height + this.margin.top + this.margin.bottom : height;
            int x = this.margin != null ? this.margin.left : 0;
            int y = this.margin != null ? this.margin.top : 0;
            result = new BufferedImage(width, height, 4);
            Graphics2D g2 = result.createGraphics();
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, width, height);
            g2.setPaint(Color.WHITE);
            g2.fill(bounds);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(this.srcImage, x, y, this.srcImage.getWidth(null), this.srcImage.getHeight(null), null);
            for (IDrawingHolder d : this.drawingList) {
                d.draw(g2);
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        return result;
    }

    private void firePropertyChange(BufferedImage image) {
        if (image != null) {
            ImageIcon icon = new ImageIcon(image);
            this.model.setIcon(icon);
            String text = this.view.getTitleFld().getText().trim();
            if (text.equals("")) {
                text = DEFAULT_TITLE;
            }
            this.model.getExtRef().setTitle(text);
            this.model.getExtRef().setMedicalRole((String)this.view.getRoleCombo().getSelectedItem());
            this.boundSupport.firePropertyChange("imageProp", null, this.model);
        } else {
            this.boundSupport.firePropertyChange("imageProp", this.model, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.removePropertyChangeListener(l);
    }

    private void initCustomComponentsUneditable() {
        this.srcImage = this.model.getIcon().getImage();
        this.margin = new Insets(12, 12, 11, 11);
        this.canvas = new SchemaCanvas(this.srcImage, this.margin);
        this.canvas.setController(this);
        this.canvas.setBorder(BorderFactory.createEtchedBorder());
        this.view = new SchemaDialog((Frame)null, GlobalConstants.getFrameTitle(TITLE), true);
        this.canvasPanel = this.view.getCanvasPanel();
        this.canvasPanel.add(this.canvas);
        this.view.getSelectBtn().setEnabled(false);
        this.view.getLineBtn().setEnabled(false);
        this.view.getRectBtn().setEnabled(false);
        this.view.getOvalBtn().setEnabled(false);
        this.view.getPolyBtn().setEnabled(false);
        this.view.getRectFillBtn().setEnabled(false);
        this.view.getOvalFillBtn().setEnabled(false);
        this.view.getPolyFillBtn().setEnabled(false);
        this.view.getTextBtn().setEnabled(false);
        JComboBox widthCombo = this.view.getLineWidthCombo();
        Object[] lines = new Object[]{ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 1)), ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 2)), ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 4)), ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 8))};
        widthCombo.setModel(new DefaultComboBoxModel<Object>(lines));
        widthCombo.setEnabled(false);
        this.view.getColorBtn().setEnabled(false);
        this.view.getUndoBtn().setEnabled(false);
        this.view.getClearBtn().setEnabled(false);
        this.view.getColorBtn().setIcon(ShapeIconMaker.createRectFillIcon(DEFAULT_FILL_COLOR, new Dimension(32, 32)));
        JTextField titleFld = this.view.getTitleFld();
        titleFld.setEditable(false);
        this.view.getRoleCombo().setEnabled(false);
        ExtRefModel extRef = this.model.getExtRef();
        if (extRef != null) {
            String text = extRef.getTitle();
            if (text != null && !text.equals("")) {
                titleFld.setText(text);
            }
            if ((text = extRef.getMedicalRole()) != null && !text.equals("")) {
                this.view.getRoleCombo().setSelectedItem(text);
            }
        }
        this.view.getOkBtn().setEnabled(false);
        String canceltext = (String)UIManager.get("OptionPane.cancelButtonText");
        JButton cancelBtn = this.view.getCancelBtn();
        cancelBtn.setText(canceltext);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.close();
                SchemaEditorImpl.this.firePropertyChange(null);
            }
        });
        int height = this.canvas.getPreferredSize().height + 150;
        int width = this.view.getPreferredSize().width;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int offsetX = (dim.width - width) / 2;
        int offsetY = (dim.height - height) / 2;
        this.view.setBounds(offsetX, offsetY, width, height);
        this.view.setVisible(true);
    }

    private void initCustomComponents() {
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Properties prop = null;
        try {
            prop = (Properties)appCtx.getLocalStorage().load("schemaEditorProp.xml");
        }
        catch (IOException e) {
            LogWriter.error(this.getClass(), e);
        }
        if (prop != null) {
            try {
                this.setLineWidth(Float.parseFloat(prop.getProperty("lineWidth")));
                String line = prop.getProperty("fillColor");
                String[] rgb = line.split("\\s*,\\s*");
                int r = Integer.parseInt(rgb[0]);
                int g = Integer.parseInt(rgb[1]);
                int b = Integer.parseInt(rgb[2]);
                this.setFillColor(new Color(r, g, b));
                this.setAlpha(Float.parseFloat(prop.getProperty("alpha")));
            }
            catch (Exception e) {
                LogWriter.error(this.getClass(), e);
            }
        }
        this.srcImage = this.model.getIcon().getImage();
        this.margin = new Insets(12, 12, 11, 11);
        this.canvas = new SchemaCanvas(this.srcImage, this.margin);
        this.canvas.setController(this);
        this.canvas.setBorder(BorderFactory.createEtchedBorder());
        this.view = new SchemaDialog((Frame)null, GlobalConstants.getFrameTitle(TITLE), true);
        this.canvasPanel = this.view.getCanvasPanel();
        this.canvasPanel.add(this.canvas);
        JToggleButton selectBtn = this.view.getSelectBtn();
        JToggleButton lineBtn = this.view.getLineBtn();
        JToggleButton rectBtn = this.view.getRectBtn();
        JToggleButton ellipseBtn = this.view.getOvalBtn();
        JToggleButton polygonBtn = this.view.getPolyBtn();
        JToggleButton rectFillBtn = this.view.getRectFillBtn();
        JToggleButton ellipseFillBtn = this.view.getOvalFillBtn();
        JToggleButton polygonFillBtn = this.view.getPolyFillBtn();
        JToggleButton textBtn = this.view.getTextBtn();
        ButtonGroup bg = new ButtonGroup();
        bg.add(selectBtn);
        bg.add(lineBtn);
        bg.add(rectBtn);
        bg.add(ellipseBtn);
        bg.add(polygonBtn);
        bg.add(rectFillBtn);
        bg.add(ellipseFillBtn);
        bg.add(polygonFillBtn);
        bg.add(textBtn);
        JComboBox widthCombo = this.view.getLineWidthCombo();
        Object[] lines = new Object[]{ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 1)), ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 2)), ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 4)), ShapeIconMaker.createRectFillIcon(Color.BLACK, new Dimension(30, 8))};
        widthCombo.setModel(new DefaultComboBoxModel<Object>(lines));
        widthCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JComboBox cmb = (JComboBox)e.getSource();
                    int index = cmb.getSelectedIndex();
                    switch (index) {
                        case 0: {
                            SchemaEditorImpl.this.setLineWidth(1.0f);
                            break;
                        }
                        case 1: {
                            SchemaEditorImpl.this.setLineWidth(2.0f);
                            break;
                        }
                        case 2: {
                            SchemaEditorImpl.this.setLineWidth(4.0f);
                            break;
                        }
                        case 3: {
                            SchemaEditorImpl.this.setLineWidth(8.0f);
                            break;
                        }
                        default: {
                            LogWriter.fatal(this.getClass(), "case default");
                        }
                    }
                }
            }
        });
        float lw = this.getLineWidth();
        if (lw == 1.0f) {
            widthCombo.setSelectedIndex(0);
        } else if (lw == 2.0f) {
            widthCombo.setSelectedIndex(1);
        } else if (lw == 4.0f) {
            widthCombo.setSelectedIndex(2);
        } else if (lw == 8.0f) {
            widthCombo.setSelectedIndex(3);
        }
        JButton colorBtn = this.view.getColorBtn();
        JButton undoBtn = this.view.getUndoBtn();
        JButton clearBtn = this.view.getClearBtn();
        colorBtn.setIcon(ShapeIconMaker.createRectFillIcon(this.getFillColor(), new Dimension(32, 32)));
        this.canvas.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SchemaEditorImpl.this.stateMgr.mouseDown(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SchemaEditorImpl.this.stateMgr.mouseUp(e.getPoint());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SchemaEditorImpl.this.stateMgr.mouseDragged(e.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startSelect();
            }
        });
        lineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startLine();
            }
        });
        rectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startRect();
            }
        });
        ellipseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startEllipse();
            }
        });
        polygonBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startPolygon();
            }
        });
        rectFillBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startRectFill();
            }
        });
        ellipseFillBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startEllipseFill();
            }
        });
        polygonFillBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startPolygonFill();
            }
        });
        textBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.startText();
            }
        });
        colorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.chooseColor();
            }
        });
        undoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.undo();
            }
        });
        clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.stateMgr.clear();
            }
        });
        JTextField titleFld = this.view.getTitleFld();
        titleFld.setText(DEFAULT_TITLE);
        titleFld.addFocusListener(AutoKanjiListener.getInstance());
        JComboBox roleCombo = this.view.getRoleCombo();
        roleCombo.setSelectedItem(DEFAULT_ROLE);
        ExtRefModel extRef = this.model.getExtRef();
        if (extRef != null) {
            String text = extRef.getTitle();
            if (text != null && !text.equals("")) {
                titleFld.setText(text);
            }
            if ((text = extRef.getMedicalRole()) != null && !text.equals("")) {
                roleCombo.setSelectedItem(text);
            }
        }
        this.drawingList = new ArrayList<IDrawingHolder>(5);
        this.stateMgr = new StateMgr();
        JButton okBtn = this.view.getOkBtn();
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.close();
                SchemaEditorImpl.this.firePropertyChange(SchemaEditorImpl.this.createImage());
            }
        });
        String canceltext = (String)UIManager.get("OptionPane.cancelButtonText");
        JButton cancelBtn = this.view.getCancelBtn();
        cancelBtn.setText(canceltext);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaEditorImpl.this.close();
                SchemaEditorImpl.this.firePropertyChange(null);
            }
        });
        int height = this.canvas.getPreferredSize().height + 150;
        int width = this.view.getPreferredSize().width;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int offsetX = (dim.width - width) / 2;
        int offsetY = (dim.height - height) / 2;
        this.view.setBounds(offsetX, offsetY, width, height);
        this.view.setVisible(true);
        rectBtn.doClick();
    }

    private void close() {
        try {
            ApplicationContext appCtx = GlobalConstants.getApplicationContext();
            Properties prop = new Properties();
            prop.setProperty("lineWidth", String.valueOf(this.getLineWidth()));
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(this.getFillColor().getRed()));
            buf.append(",");
            buf.append(String.valueOf(this.getFillColor().getGreen()));
            buf.append(",");
            buf.append(String.valueOf(this.getFillColor().getBlue()));
            prop.setProperty("fillColor", buf.toString());
            prop.setProperty("alpha", String.valueOf(this.getAlpha()));
            appCtx.getLocalStorage().save((Object)prop, "schemaEditorProp.xml");
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        this.view.setVisible(false);
        this.view.dispose();
    }

    private void chooseColor() {
        Color newColor = JColorChooser.showDialog(this.view, "\u5857\u308a\u3064\u3076\u3057\u30ab\u30e9\u30fc\u9078\u629e", this.getFillColor());
        if (newColor != null) {
            this.setFillColor(newColor);
            ImageIcon icon = ShapeIconMaker.createRectFillIcon(this.getFillColor(), new Dimension(32, 32));
            this.view.getColorBtn().setIcon(icon);
        }
    }

    public void draw(Graphics2D g2d) {
        if (this.stateMgr != null) {
            this.stateMgr.draw(g2d);
        }
    }

    public void addShape(IDrawingHolder s) {
        this.drawingList.add(s);
    }

    public IDrawingHolder findDrawing(Point p) {
        int last;
        IDrawingHolder found = null;
        for (int i = last = (cnt = this.drawingList.size()) > 0 ? cnt - 1 : 0; i > -1; --i) {
            IDrawingHolder d = this.drawingList.get(i);
            if (!d.contains(p)) continue;
            found = d;
            break;
        }
        return found;
    }

    public void removeLastShape() {
        IDrawingHolder remove = this.drawingList.get(this.drawingList.size() - 1);
        this.drawingList.remove(remove);
    }

    public Stroke getStroke() {
        return new BasicStroke(this.getLineWidth());
    }

    public Paint getPaint() {
        return this.getFillColor();
    }

    public AlphaComposite getAlphaComposite() {
        return AlphaComposite.getInstance(3, this.getAlpha());
    }

    public AlphaComposite getTextComposite() {
        return AlphaComposite.getInstance(3, this.getTextAlpha());
    }

    public Font getFont() {
        return new Font(this.getFontName(), this.getFontStyle(), this.getTextSize());
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public Color getTextColor() {
        return this.getFillColor();
    }

    public void setTextColor(Color textColor) {
    }

    public float getTextAlpha() {
        return this.getAlpha();
    }

    public void setTextAlpha(float textAlpha) {
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    class StateMgr {
        private State selectState;
        private State lineState;
        private State rectState;
        private State ellipseState;
        private State polygonState;
        private State rectFillState;
        private State ellipseFillState;
        private State polygonFillState;
        private State textState;
        private State undoState;
        private State curState;
        private State savedState;

        public StateMgr() {
            this.curState = this.rectFillState;
            this.selectState = new SelectState();
            this.lineState = new LineState();
            this.rectState = new RectState();
            this.ellipseState = new EllipseState();
            this.polygonState = new PolygonState();
            this.rectFillState = new RectFillState();
            this.ellipseFillState = new EllipseFillState();
            this.polygonFillState = new PolygonFillState();
            this.textState = new TextState();
            this.undoState = new UndoState();
            this.curState = this.rectFillState;
        }

        public void startSelect() {
            this.curState = this.selectState;
        }

        public void startLine() {
            this.curState = this.lineState;
        }

        public void startRect() {
            this.curState = this.rectState;
        }

        public void startEllipse() {
            this.curState = this.ellipseState;
        }

        public void startPolygon() {
            this.curState = this.polygonState;
        }

        public void startRectFill() {
            this.curState = this.rectFillState;
        }

        public void startEllipseFill() {
            this.curState = this.ellipseFillState;
        }

        public void startPolygonFill() {
            this.curState = this.polygonFillState;
        }

        public void startText() {
            this.curState = this.textState;
        }

        public void mouseDown(Point p) {
            this.curState.mouseDown(p);
        }

        public void mouseDragged(Point p) {
            this.curState.mouseDragged(p);
        }

        public void mouseUp(Point p) {
            this.curState.mouseUp(p);
        }

        public void draw(Graphics2D g2d) {
            for (IDrawingHolder d : SchemaEditorImpl.this.drawingList) {
                d.draw(g2d);
            }
            if (this.curState == this.undoState) {
                this.curState = this.savedState;
            } else {
                this.curState.draw(g2d);
            }
        }

        public void undo() {
            IDrawingHolder d = SchemaEditorImpl.this.drawingList.get(SchemaEditorImpl.this.drawingList.size() - 1);
            SchemaEditorImpl.this.drawingList.remove(d);
            this.savedState = this.curState;
            this.curState = this.undoState;
            SchemaEditorImpl.this.canvas.repaint();
        }

        public void clear() {
            SchemaEditorImpl.this.drawingList.clear();
            this.savedState = this.curState;
            this.curState = this.undoState;
            SchemaEditorImpl.this.canvas.repaint();
        }
    }

    class UndoState
    extends State {
        UndoState() {
        }

        @Override
        public void mouseDown(Point p) {
        }

        @Override
        public void mouseDragged(Point p) {
        }

        @Override
        public void mouseUp(Point p) {
        }

        @Override
        public void draw(Graphics2D g2d) {
        }
    }

    class TextState
    extends State {
        private String inputText;

        TextState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.inputText = JOptionPane.showInputDialog(SchemaEditorImpl.this.view, (Object)"\u30c6\u30ad\u30b9\u30c8\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            if (this.inputText != null) {
                this.start = p;
                this.end = null;
                SchemaEditorImpl.this.canvas.repaint();
            } else {
                this.start = null;
                this.end = null;
            }
        }

        @Override
        public void mouseDragged(Point p) {
        }

        @Override
        public void mouseUp(Point p) {
        }

        @Override
        public void draw(Graphics2D g2d) {
            if (this.inputText != null && this.start != null) {
                Stroke saveStroke = g2d.getStroke();
                Paint savePaint = g2d.getPaint();
                Composite saveComposite = g2d.getComposite();
                FontRenderContext ctx = g2d.getFontRenderContext();
                Font f = SchemaEditorImpl.this.getFont();
                TextLayout layout = new TextLayout(this.inputText, f, ctx);
                AffineTransform trans = AffineTransform.getTranslateInstance(this.start.getX(), this.start.getY());
                Shape outLine = layout.getOutline(trans);
                g2d.setPaint(SchemaEditorImpl.this.getTextColor());
                if (SchemaEditorImpl.this.isOutline()) {
                    g2d.draw(outLine);
                } else {
                    g2d.fill(outLine);
                }
                g2d.setStroke(saveStroke);
                g2d.setPaint(savePaint);
                g2d.setComposite(saveComposite);
                TextHolder sh = new TextHolder(new Area(outLine), null, SchemaEditorImpl.this.getTextColor(), SchemaEditorImpl.this.getTextComposite(), !SchemaEditorImpl.this.isOutline());
                SchemaEditorImpl.this.addShape(sh);
                this.inputText = null;
            }
        }
    }

    class LineState
    extends State {
        LineState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.start = p;
            this.end = null;
            this.first = true;
        }

        @Override
        public void mouseDragged(Point p) {
            Line2D.Double shape;
            this.end = p;
            if (this.isDragged() && (shape = this.getShape()) != null) {
                if (this.first) {
                    this.first = false;
                } else {
                    SchemaEditorImpl.this.removeLastShape();
                }
                Line2DHolder sh = new Line2DHolder(shape, SchemaEditorImpl.this.getStroke(), SchemaEditorImpl.this.getPaint(), SchemaEditorImpl.this.getAlphaComposite());
                SchemaEditorImpl.this.addShape(sh);
                SchemaEditorImpl.this.canvas.repaint();
            }
        }

        @Override
        public void mouseUp(Point p) {
        }

        private Line2D.Double getShape() {
            return new Line2D.Double(this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY());
        }
    }

    class PolygonFillState
    extends State {
        private GeneralPath gpath;
        private boolean closed;

        PolygonFillState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.start = p;
            this.end = null;
            this.first = true;
            this.gpath = null;
            this.closed = false;
        }

        @Override
        public void mouseDragged(Point p) {
            this.end = p;
            if (this.isDragged()) {
                if (this.first) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(this.start.x, this.start.y);
                    this.gpath.lineTo(this.end.x, this.end.y);
                    this.first = false;
                } else {
                    this.gpath.lineTo(this.end.x, this.end.y);
                }
                SchemaEditorImpl.this.canvas.repaint();
                this.start = this.end;
            }
        }

        @Override
        public void mouseUp(Point p) {
            this.end = p;
            if (this.gpath != null) {
                this.gpath.closePath();
                this.closed = true;
                SchemaEditorImpl.this.canvas.repaint();
                AreaHolder sh = new AreaHolder(new Area(this.gpath), null, SchemaEditorImpl.this.getPaint(), SchemaEditorImpl.this.getAlphaComposite(), true);
                SchemaEditorImpl.this.addShape(sh);
            }
            this.gpath = null;
        }

        @Override
        public void draw(Graphics2D g2d) {
            if (this.gpath == null) {
                return;
            }
            Stroke saveStroke = g2d.getStroke();
            Paint savePaint = g2d.getPaint();
            Composite saveComposite = g2d.getComposite();
            g2d.setComposite(SchemaEditorImpl.this.getAlphaComposite());
            g2d.setPaint(SchemaEditorImpl.this.getPaint());
            if (this.closed) {
                g2d.fill(this.gpath);
            } else {
                g2d.setStroke(SchemaEditorImpl.this.getStroke());
                g2d.draw(this.gpath);
            }
            g2d.setStroke(saveStroke);
            g2d.setPaint(savePaint);
            g2d.setComposite(saveComposite);
        }
    }

    class EllipseFillState
    extends State {
        EllipseFillState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.start = p;
            this.end = null;
            this.first = true;
        }

        @Override
        public void mouseDragged(Point p) {
            this.end = p;
            if (this.isDragged()) {
                this.createAndAddShape();
                SchemaEditorImpl.this.canvas.repaint();
            }
        }

        @Override
        public void mouseUp(Point p) {
        }

        private void createAndAddShape() {
            Ellipse2D.Double shape = new Ellipse2D.Double();
            shape.setFrameFromDiagonal(this.start, this.end);
            if (this.first) {
                this.first = false;
            } else {
                SchemaEditorImpl.this.removeLastShape();
            }
            AreaHolder sh = new AreaHolder(new Area(shape), null, SchemaEditorImpl.this.getPaint(), SchemaEditorImpl.this.getAlphaComposite(), true);
            SchemaEditorImpl.this.addShape(sh);
        }
    }

    class RectFillState
    extends State {
        RectFillState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.start = p;
            this.end = null;
            this.first = true;
        }

        @Override
        public void mouseDragged(Point p) {
            this.end = p;
            if (this.isDragged()) {
                this.createAndAddShape();
                SchemaEditorImpl.this.canvas.repaint();
            }
        }

        @Override
        public void mouseUp(Point p) {
        }

        private void createAndAddShape() {
            Rectangle2D.Double shape = new Rectangle2D.Double();
            shape.setFrameFromDiagonal(this.start, this.end);
            if (this.first) {
                this.first = false;
            } else {
                SchemaEditorImpl.this.removeLastShape();
            }
            AreaHolder sh = new AreaHolder(new Area(shape), null, SchemaEditorImpl.this.getPaint(), SchemaEditorImpl.this.getAlphaComposite(), true);
            SchemaEditorImpl.this.addShape(sh);
        }
    }

    class PolygonState
    extends State {
        private GeneralPath gpath;

        PolygonState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.start = p;
            this.end = null;
            this.first = true;
            this.gpath = null;
        }

        @Override
        public void mouseDragged(Point p) {
            this.end = p;
            if (this.isDragged()) {
                if (this.first) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(this.start.x, this.start.y);
                    this.gpath.lineTo(this.end.x, this.end.y);
                    this.first = false;
                } else {
                    this.gpath.lineTo(this.end.x, this.end.y);
                }
                SchemaEditorImpl.this.canvas.repaint();
                this.start = this.end;
            }
        }

        @Override
        public void mouseUp(Point p) {
            this.end = p;
            if (this.gpath != null) {
                this.gpath.closePath();
                SchemaEditorImpl.this.canvas.repaint();
                AreaHolder sh = new AreaHolder(new Area(this.gpath), SchemaEditorImpl.this.getStroke(), SchemaEditorImpl.this.getPaint(), SchemaEditorImpl.this.getAlphaComposite(), false);
                SchemaEditorImpl.this.addShape(sh);
            }
            this.gpath = null;
        }

        @Override
        public void draw(Graphics2D g2d) {
            if (this.gpath == null) {
                return;
            }
            Stroke saveStroke = g2d.getStroke();
            Paint savePaint = g2d.getPaint();
            Composite saveComposite = g2d.getComposite();
            g2d.setStroke(SchemaEditorImpl.this.getStroke());
            g2d.setComposite(SchemaEditorImpl.this.getAlphaComposite());
            g2d.setPaint(SchemaEditorImpl.this.getPaint());
            g2d.draw(this.gpath);
            g2d.setStroke(saveStroke);
            g2d.setPaint(savePaint);
            g2d.setComposite(saveComposite);
        }
    }

    class EllipseState
    extends State {
        EllipseState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.start = p;
            this.end = null;
            this.first = true;
        }

        @Override
        public void mouseDragged(Point p) {
            this.end = p;
            if (this.isDragged()) {
                this.createAndAddShape();
                SchemaEditorImpl.this.canvas.repaint();
            }
        }

        @Override
        public void mouseUp(Point p) {
        }

        private void createAndAddShape() {
            Ellipse2D.Double shape = new Ellipse2D.Double();
            shape.setFrameFromDiagonal(this.start, this.end);
            if (this.first) {
                this.first = false;
            } else {
                SchemaEditorImpl.this.removeLastShape();
            }
            AreaHolder sh = new AreaHolder(new Area(shape), SchemaEditorImpl.this.getStroke(), SchemaEditorImpl.this.getPaint(), SchemaEditorImpl.this.getAlphaComposite(), false);
            SchemaEditorImpl.this.addShape(sh);
        }
    }

    class RectState
    extends State {
        RectState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.start = p;
            this.end = null;
            this.first = true;
        }

        @Override
        public void mouseDragged(Point p) {
            this.end = p;
            if (this.isDragged()) {
                this.createAndAddShape();
                SchemaEditorImpl.this.canvas.repaint();
            }
        }

        @Override
        public void mouseUp(Point p) {
        }

        private void createAndAddShape() {
            Rectangle2D.Double shape = new Rectangle2D.Double();
            shape.setFrameFromDiagonal(this.start, this.end);
            if (this.first) {
                this.first = false;
            } else {
                SchemaEditorImpl.this.removeLastShape();
            }
            AreaHolder sh = new AreaHolder(new Area(shape), SchemaEditorImpl.this.getStroke(), SchemaEditorImpl.this.getPaint(), SchemaEditorImpl.this.getAlphaComposite(), false);
            SchemaEditorImpl.this.addShape(sh);
        }
    }

    class SelectState
    extends State {
        private IDrawingHolder moving;

        SelectState() {
        }

        @Override
        public void mouseDown(Point p) {
            this.moving = SchemaEditorImpl.this.findDrawing(p);
            if (this.moving != null) {
                this.start = p;
                this.end = null;
            }
        }

        @Override
        public void mouseDragged(Point p) {
            if (this.moving != null) {
                this.end = p;
                if (this.isDragged()) {
                    this.moving.translate(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
                    SchemaEditorImpl.this.canvas.repaint();
                    this.start = this.end;
                }
            }
        }

        @Override
        public void mouseUp(Point p) {
        }
    }

    protected abstract class State {
        protected boolean first;
        protected Point start;
        protected Point end;

        protected State() {
        }

        public abstract void mouseDown(Point var1);

        public abstract void mouseDragged(Point var1);

        public abstract void mouseUp(Point var1);

        public void draw(Graphics2D g2d) {
        }

        protected boolean isDragged() {
            if (this.start == null || this.end == null) {
                return false;
            }
            int x = Math.abs(this.start.x - this.end.x);
            int y = Math.abs(this.start.y - this.end.y);
            return x > 5 || y > 5;
        }
    }
}

