/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.container.NameValuePair;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.dto.DocumentSearchSpec;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.queries.DolphinQuery;
import open.dolphin.table.DocumentHistoryRenderer;
import open.dolphin.table.ObjectReflectTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.layout.GroupLayout;

public class DocumentHistoryPanel
extends JPanel
implements IChartDocument {
    public static final String TITLE = "\u6587\u66f8\u5c65\u6b74";
    public static final String DOCUMENT_TYPE = "documentTypeProp";
    public static final String SELECTED_HISTORIES = "selectedHistories";
    public static final String SELECTED_KARTES = "selectedKartes";
    public static final String HITORY_UPDATED = "historyUpdated";
    private ObjectReflectTableModel<DocInfoModel> tableModel;
    private PropertyChangeSupport boundSupport;
    private DocInfoModel[] selectedHistories;
    private String extractionContent;
    private Date extractionPeriod;
    private int autoFetchCount;
    private boolean ascending;
    private boolean showModified = true;
    private boolean showUnsend = true;
    private boolean showSend = true;
    private boolean start;
    private NameValuePair[] contentObject;
    private NameValuePair[] extractionObjects;
    private IChart parent;
    private String title = "\u6587\u66f8\u5c65\u6b74";
    private boolean newest = false;
    private JLabel cntLbl;
    private JComboBox docTypeCombo;
    private JScrollPane jScrollPane1;
    private JComboBox periodCombo;
    private JButton searchButton;
    private JTextField searchField;
    private JTable table;

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.DocumentHistoryPanel;
    }

    public DocumentHistoryPanel(IChart parent, String keyword) {
        this.parent = parent;
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.initCustomComponents();
        this.connect();
        this.start = true;
        this.searchField.setText(keyword);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.cntLbl = new JLabel();
        this.docTypeCombo = new JComboBox();
        this.periodCombo = new JComboBox();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setName("table");
        this.jScrollPane1.setViewportView(this.table);
        this.cntLbl.setHorizontalAlignment(4);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(DocumentHistoryPanel.class);
        this.cntLbl.setText(resourceMap.getString("cntLbl.text", new Object[0]));
        this.cntLbl.setName("cntLbl");
        this.docTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"\u30ab\u30eb\u30c6", "\u7d39\u4ecb\u72b6", "\u7d39\u4ecb\u72b6\u8fd4\u66f8"}));
        this.docTypeCombo.setName("docTypeCombo");
        this.docTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DocumentHistoryPanel.this.docTypeComboItemStateChanged(evt);
            }
        });
        this.periodCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"1\u30f6\u6708", "3\u30f6\u6708", "\u534a\u5e74", "1\u5e74", "2\u5e74", "3\u5e74", "\u5168\u3066"}));
        this.periodCombo.setSelectedIndex(3);
        this.periodCombo.setName("periodCombo");
        this.periodCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DocumentHistoryPanel.this.periodComboItemStateChanged(evt);
            }
        });
        this.searchField.setText(resourceMap.getString("searchField.text", new Object[0]));
        this.searchField.setName("searchField");
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentHistoryPanel.this.searchFieldActionPerformed(evt);
            }
        });
        this.searchButton.setText(resourceMap.getString("searchButton.text", new Object[0]));
        this.searchButton.setName("searchButton");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentHistoryPanel.this.searchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 280, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.docTypeCombo, 0, 133, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.periodCombo, -2, -1, -2)).add(2, (Component)this.searchField, -1, 201, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.searchButton).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.cntLbl, -1, -1, Short.MAX_VALUE)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 86, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.searchField, -2, -1, -2).add((Component)this.searchButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.docTypeCombo, -2, -1, -2).add((Component)this.cntLbl).add((Component)this.periodCombo, -2, -1, -2))));
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String keyword = this.searchField.getText();
        if (keyword.equals("")) {
            this.getDocumentHistory();
        } else {
            this.Search(keyword);
        }
    }

    private void searchFieldActionPerformed(ActionEvent evt) {
        String keyword = this.searchField.getText();
        if (keyword.equals("")) {
            this.getDocumentHistory();
        } else {
            this.Search(keyword);
        }
    }

    private void docTypeComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            int index = this.docTypeCombo.getSelectedIndex();
            NameValuePair pair = this.contentObject[index];
            this.setExtractionContent(pair.getValue());
        }
    }

    private void periodComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            int index = this.periodCombo.getSelectedIndex();
            NameValuePair pair = this.extractionObjects[index];
            String value = pair.getValue();
            int addValue = Integer.parseInt(value);
            GregorianCalendar today = new GregorianCalendar();
            today.add(2, addValue);
            today.clear(11);
            today.clear(12);
            today.clear(13);
            today.clear(14);
            this.setExtractionPeriod(today.getTime());
        }
    }

    private void initCustomComponents() {
        String[] columnNames = new String[]{"\u8a3a\u7642\u65e5", "\u66f4\u65b0\u65e5", "\u5185\u5bb9", "\u72b6\u614b"};
        String[] methodNames = new String[]{"getFirstConfirmDateTrimTime", "getConfirmDateTrimTime", "getTitle", "getStatusByName"};
        Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class};
        int[] columnWidth = new int[]{110, 110, 110, 110};
        int startNumRows = 0;
        this.extractionObjects = GlobalConstants.getNameValuePair("docHistory.combo.period");
        this.tableModel = new ObjectReflectTableModel<DocInfoModel>(columnNames, startNumRows, methodNames, columnClasses){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 2;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                Object docInfoModel;
                if (col == 2 && value != null && !value.equals("") && (docInfoModel = this.getObject(row)) != null) {
                    DocInfoModel docInfo = (DocInfoModel)docInfoModel;
                    docInfo.setTitle((String)value);
                    DocumentHistoryPanel.this.titleChanged(docInfo);
                }
            }
        };
        this.table.setModel(this.tableModel);
        for (int i = 0; i < columnWidth.length; ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(columnWidth[i]);
        }
        JTextField tf = new JTextField();
        tf.addFocusListener(AutoKanjiListener.getInstance());
        TableColumn column = this.table.getColumnModel().getColumn(1);
        column.setCellEditor(new DefaultCellEditor(tf));
        this.table.setDefaultRenderer(Object.class, new DocumentHistoryRenderer());
        this.contentObject = new NameValuePair[3];
        this.contentObject[0] = new NameValuePair("\u30ab\u30eb\u30c6", "karte");
        this.contentObject[1] = new NameValuePair("\u7d39\u4ecb\u72b6", "letter");
        this.contentObject[2] = new NameValuePair("\u7d39\u4ecb\u72b6\u8fd4\u66f8", "letterReply");
    }

    private void connect() {
        ListSelectionModel slm = this.table.getSelectionModel();
        slm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows;
                if (!e.getValueIsAdjusting() && (selectedRows = DocumentHistoryPanel.this.table.getSelectedRows()).length > 0) {
                    ArrayList<DocInfoModel> list = new ArrayList<DocInfoModel>(1);
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DocInfoModel obj = (DocInfoModel)DocumentHistoryPanel.this.tableModel.getObject(selectedRows[i]);
                        if (obj == null) continue;
                        list.add(obj);
                    }
                    DocInfoModel[] selected = list.toArray(new DocInfoModel[list.size()]);
                    if (selected != null && selected.length > 0) {
                        DocumentHistoryPanel.this.setSelectedHistories(selected);
                    } else {
                        DocumentHistoryPanel.this.setSelectedHistories(null);
                    }
                }
            }
        });
        this.extractionContent = "karte";
        int past = GlobalVariables.getPreferences().getInt("docHistory.period", -12);
        int index = NameValuePair.getIndex(String.valueOf(past), this.extractionObjects);
        this.periodCombo.setSelectedIndex(index);
        GregorianCalendar today = new GregorianCalendar();
        today.add(2, past);
        today.clear(11);
        today.clear(12);
        today.clear(13);
        today.clear(14);
        this.setExtractionPeriod(today.getTime());
        this.autoFetchCount = GlobalVariables.getFetchKarteCount();
        this.ascending = GlobalVariables.getAscendingKarte();
    }

    private void Search(String keyword) {
        Application app = GlobalConstants.getApplicationContext().getApplication();
        KarteSearchTask task = new KarteSearchTask(app, keyword);
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        appCtx.getTaskService().execute((Task)task);
    }

    private void setSelectedHistories(DocInfoModel[] newSelected) {
        DocInfoModel[] old = this.selectedHistories;
        this.selectedHistories = newSelected;
        if (this.selectedHistories != null) {
            this.boundSupport.firePropertyChange(SELECTED_HISTORIES, old, this.selectedHistories);
        }
    }

    private Object findChild(List list, long pk) {
        for (Object docInfo : list) {
            if (((DocInfoModel)docInfo).getParentPk() != pk) continue;
            return docInfo;
        }
        return null;
    }

    private List filtering(List list) {
        ArrayList result = new ArrayList();
        for (Object docInfo : list) {
            if (this.findChild(list, ((DocInfoModel)docInfo).getDocPk()) != null) continue;
            result.add(docInfo);
        }
        return result;
    }

    private void updateHistory(List paramHistory, boolean newest) {
        if (paramHistory != null && paramHistory.size() > 0) {
            if (this.isAscending()) {
                Collections.sort(paramHistory);
            } else {
                Collections.sort(paramHistory, Collections.reverseOrder());
            }
        }
        List newHistory = null;
        newHistory = newest ? this.filtering(paramHistory) : paramHistory;
        this.tableModel.setObjectList(newHistory);
        this.boundSupport.firePropertyChange(HITORY_UPDATED, false, true);
        if (newHistory != null && newHistory.size() > 0) {
            int cnt = newHistory.size();
            this.cntLbl.setText(String.valueOf(cnt) + " \u4ef6");
            int fetchCount = cnt > this.autoFetchCount ? this.autoFetchCount : cnt;
            int first = 0;
            int last = 0;
            if (this.isAscending()) {
                last = cnt - 1;
                first = cnt - fetchCount;
            } else {
                first = 0;
                last = fetchCount - 1;
            }
            this.table.getSelectionModel().addSelectionInterval(first, last);
            Rectangle r = this.table.getCellRect(first, last, true);
            this.table.scrollRectToVisible(r);
        } else {
            this.cntLbl.setText("0 \u4ef6");
        }
    }

    private void titleChanged(DocInfoModel docInfo) {
        if (docInfo != null && docInfo.getTitle() != null) {
            ChangeTitleTask task = new ChangeTitleTask(this.getParentContext(), docInfo, new RemoteDocumentDelegater());
            task.execute();
        }
    }

    private void setExtractionContent(String extractionContent) {
        String old = this.extractionContent;
        this.extractionContent = extractionContent;
        this.boundSupport.firePropertyChange(DOCUMENT_TYPE, old, this.extractionContent);
        this.getDocumentHistory();
    }

    private void setExtractionPeriod(Date extractionPeriod) {
        this.extractionPeriod = extractionPeriod;
        this.getDocumentHistory();
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
        this.getDocumentHistory();
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setShowModified(boolean showModified) {
        this.setShowModified(showModified, true);
    }

    public void setShowModified(boolean showModified, boolean rewrite) {
        this.showModified = showModified;
        if (rewrite) {
            this.getDocumentHistory();
        }
    }

    public void setShowUnsend(boolean showUnsend) {
        this.setShowUnsend(showUnsend, true);
    }

    public void setShowUnsend(boolean showUnsend, boolean rewrite) {
        this.showUnsend = showUnsend;
        if (rewrite) {
            this.getDocumentHistory();
        }
    }

    public void setShowSend(boolean showSend) {
        this.setShowSend(showSend, true);
    }

    public void setShowSend(boolean showSend, boolean rewrite) {
        this.showSend = showSend;
        if (rewrite) {
            this.getDocumentHistory();
        }
    }

    public void setShowNewest(boolean newest) {
        this.setShowNewest(newest, true);
    }

    public void setShowNewest(boolean newest, boolean rewrite) {
        this.newest = newest;
        if (rewrite) {
            this.getDocumentHistory();
        }
    }

    public void clear() {
        this.tableModel.clear();
    }

    public void getDocumentHistory() {
        if (this.start && this.extractionPeriod != null && this.extractionContent != null) {
            DocumentSearchSpec spec = new DocumentSearchSpec();
            spec.setKarteId(this.getParentContext().getKarte().getId());
            spec.setDocType(this.extractionContent);
            spec.setFromDate(this.extractionPeriod);
            spec.setIncludeModifid(this.showModified);
            spec.setIncludeUnsend(this.showUnsend);
            spec.setIncludeSend(this.showSend);
            spec.setLines(200);
            spec.setCode(0);
            spec.setAscending(this.ascending);
            RemoteDocumentDelegater delegater = new RemoteDocumentDelegater();
            DocInfoTask task = new DocInfoTask(this.getParentContext(), spec, delegater, this.newest);
            task.execute();
        }
    }

    @Override
    public void addPropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.boundSupport.addPropertyChangeListener(propName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.boundSupport.removePropertyChangeListener(propName, listener);
    }

    @Override
    public void requestFocus() {
        this.table.requestFocusInWindow();
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    class ChangeTitleTask
    extends DBTask<Boolean> {
        private DocInfoModel docInfo;
        private RemoteDocumentDelegater ddl;

        public ChangeTitleTask(IChart ctx, DocInfoModel docInfo, RemoteDocumentDelegater ddl) {
            super(ctx);
            this.docInfo = docInfo;
            this.ddl = ddl;
        }

        @Override
        protected Boolean doInBackground() {
            this.ddl.updateTitle(this.docInfo);
            return !this.ddl.isError();
        }

        @Override
        protected void succeeded(Boolean result) {
        }
    }

    class DocInfoTask
    extends DBTask<List<DocInfoModel>> {
        private RemoteDocumentDelegater ddl;
        private DocumentSearchSpec spec;
        private boolean newest;

        public DocInfoTask(IChart ctx, DocumentSearchSpec spec, RemoteDocumentDelegater ddl, boolean newest) {
            super(ctx);
            this.spec = spec;
            this.ddl = ddl;
            this.newest = newest;
        }

        @Override
        protected List<DocInfoModel> doInBackground() {
            List result = this.ddl.getDocumentHistory(this.spec);
            if (!this.ddl.isError()) {
                return result;
            }
            return null;
        }

        @Override
        protected void succeeded(List<DocInfoModel> result) {
            if (result != null) {
                DocumentHistoryPanel.this.updateHistory(result, this.newest);
            }
        }
    }

    class BlockKeyListener
    implements KeyListener {
        BlockKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }
    }

    class KarteSearchTask
    extends Task<List, Void> {
        private RemoteDocumentDelegater ddl;
        private Cursor currentCursor;
        private String FKeyword;

        public KarteSearchTask(Application app, String keyword) {
            super(app);
            this.ddl = new RemoteDocumentDelegater();
            this.FKeyword = keyword;
        }

        protected List<DocInfoModel> doInBackground() throws Exception {
            this.currentCursor = DocumentHistoryPanel.this.getCursor();
            DocumentHistoryPanel.this.setCursor(new Cursor(3));
            ArrayList<DocInfoModel> result = new ArrayList<DocInfoModel>();
            DolphinQuery query = new DolphinQuery();
            query.addWhat("keyword", this.FKeyword);
            HashMap<Long, DocInfoModel> docIds = new HashMap<Long, DocInfoModel>();
            for (int index = 0; index < DocumentHistoryPanel.this.tableModel.getRowCount(); ++index) {
                DocInfoModel item = (DocInfoModel)DocumentHistoryPanel.this.tableModel.getObject(index);
                if (item == null) continue;
                docIds.put(new Long(item.getDocPk()), item);
            }
            List<DocumentModel> documents = this.ddl.getDocuments(new ArrayList<Long>(docIds.keySet()));
            for (DocumentModel document : documents) {
                DocInfoModel docInfo = (DocInfoModel)docIds.get(document.getId());
                if (docInfo.search(query)) {
                    boolean found = false;
                    for (DocInfoModel doc : result) {
                        if (doc.getDocPk() != docInfo.getDocPk()) continue;
                        found = true;
                    }
                    if (found) continue;
                    result.add(docInfo);
                    continue;
                }
                Set<ModuleModel> modules = document.getModules();
                for (ModuleModel module : modules) {
                    if (!module.search(query)) continue;
                    boolean found = false;
                    for (DocInfoModel doc : result) {
                        if (doc.getDocPk() != docInfo.getDocPk()) continue;
                        found = true;
                    }
                    if (found) continue;
                    result.add(docInfo);
                }
            }
            return result;
        }

        protected void succeeded(List result) {
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)DocumentHistoryPanel.this.table.getModel();
            tableModel.setObjectList(result);
            int cnt = result != null ? result.size() : 0;
            String cntStr = String.valueOf(cnt);
            DocumentHistoryPanel.this.cntLbl.setText(cntStr + " \u4ef6");
            DocumentHistoryPanel.this.setCursor(this.currentCursor);
        }

        protected void failed(Throwable cause) {
            DocumentHistoryPanel.this.setCursor(this.currentCursor);
        }

        protected void cancelled() {
            DocumentHistoryPanel.this.setCursor(this.currentCursor);
        }
    }
}

