/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.TransferAction;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.project.GlobalConstants;

public class StampTreeMenuBuilder {
    private static final Icon icon = GlobalConstants.getImageIcon("foldr_16.gif");
    private Map<Object, JMenu> parents;

    public JMenu build(StampTree stampTree, JComponent cmp, TransferHandler handler) {
        if (this.parents == null) {
            this.parents = new HashMap<Object, JMenu>(10, 0.75f);
        } else {
            this.parents.clear();
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)stampTree.getModel().getRoot();
        JMenu top = new JMenu(stampTree.getTreeName());
        this.parents.put(rootNode, top);
        Enumeration<TreeNode> e = rootNode.preorderEnumeration();
        if (e != null) {
            e.nextElement();
            while (e.hasMoreElements()) {
                this.parseChildren((StampTreeNode)e.nextElement(), cmp, handler);
            }
        }
        return top;
    }

    private void parseChildren(StampTreeNode node, JComponent comp, TransferHandler handler) {
        if (!node.isLeaf()) {
            JMenu subMenu = new JMenu(node.getUserObject().toString());
            JMenu parent = this.parents.get(node.getParent());
            parent.add(subMenu);
            this.parents.put(node, subMenu);
            JMenuItem item = new JMenuItem(node.getUserObject().toString());
            item.setIcon(icon);
            subMenu.add(item);
            if (comp != null && handler != null) {
                item.addActionListener(new TransferAction(comp, handler, new LocalStampTreeNodeTransferable(node)));
            } else {
                item.setEnabled(false);
            }
        } else {
            ModuleInfoBean info = (ModuleInfoBean)node.getUserObject();
            JMenuItem item = new JMenuItem(info.getStampName());
            if (comp != null && handler != null) {
                item.addActionListener(new TransferAction(comp, handler, new LocalStampTreeNodeTransferable(node)));
            } else {
                item.setEnabled(false);
            }
            JMenu parent = this.parents.get(node.getParent());
            parent.add(item);
        }
    }
}

