/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.caremapdocument;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.caremapdocument.CareMapDocumentPanel;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.IStampInfo;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.table.ObjectTableModel;
import open.dolphin.table.OddEvenRowRenderer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class OrderHistoryPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -2302784717739085879L;
    private ObjectTableModel tModel;
    private String pid;
    private JLabel contents;
    private JScrollPane cs;
    private JScrollPane scroller;
    private JTable table;

    public OrderHistoryPanel(final CareMapDocumentPanel chartCtx) {
        this.initComponents();
        String[] columnNames = new String[]{"\u5b9f\u65bd\u65e5", "\u5185   \u5bb9"};
        this.tModel = new ObjectTableModel(columnNames, 12){
            private static final long serialVersionUID = 1684645192401100170L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public Object getValueAt(int row, int col) {
                String result = null;
                ModuleModel module = (ModuleModel)this.getObject(row);
                if (module != null) {
                    IStampInfo info = module.getModuleInfo();
                    switch (col) {
                        case 0: {
                            result = ModelUtils.getDateAsFormatString(module.getStarted(), "yyyy-MM-dd'('EEE')'HH:mm");
                            break;
                        }
                        case 1: {
                            result = info.getStampName();
                            break;
                        }
                        default: {
                            LogWriter.fatal(this.getClass(), "case default");
                        }
                    }
                }
                return result;
            }
        };
        this.table.setModel(this.tModel);
        this.table.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.Popup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.Popup(e);
            }

            private void Popup(MouseEvent evnt) {
                if (evnt.isPopupTrigger()) {
                    JTable table = (JTable)evnt.getSource();
                    int selectedIndex = table.rowAtPoint(evnt.getPoint());
                    table.changeSelection(selectedIndex, 1, false, false);
                    ModuleModel stamp = (ModuleModel)OrderHistoryPanel.this.tModel.getObject(selectedIndex);
                    chartCtx.setSelectedHistoryModel(stamp);
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(chartCtx.getParentContext().getChartMediator().getAction("letterPaste"));
                    popup.show(evnt.getComponent(), evnt.getX(), evnt.getY());
                }
            }
        });
        ListSelectionModel m = this.table.getSelectionModel();
        m.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OrderHistoryPanel.this.contents.setText(OrderHistoryPanel.this.displayOrder(OrderHistoryPanel.this.table.getSelectedRow()));
                }
            }
        });
        this.setColumnWidth(new int[]{50, 240});
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.contents.setBackground(Color.white);
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.table = new JTable();
        this.cs = new JScrollPane();
        this.contents = new JLabel();
        this.setLayout(new BorderLayout(0, 5));
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setName("scroller");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(4);
        this.table.setName("table");
        this.table.setSelectionMode(0);
        this.scroller.setViewportView(this.table);
        this.add((Component)this.scroller, "Center");
        this.cs.setHorizontalScrollBarPolicy(31);
        this.cs.setMaximumSize(new Dimension(240, 300));
        this.cs.setName("cs");
        this.cs.setPreferredSize(new Dimension(240, 300));
        this.contents.setName("contents");
        this.cs.setViewportView(this.contents);
        this.add((Component)this.cs, "East");
    }

    public void setColumnWidth(int[] columnWidth) {
        int len = columnWidth.length;
        for (int i = 0; i < len; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(columnWidth[i]);
        }
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String val) {
        this.pid = val;
    }

    public void setModuleList(List allModules) {
        this.tModel.clear();
        if (allModules == null || allModules.isEmpty()) {
            return;
        }
        int size = allModules.size();
        ArrayList list = new ArrayList();
        for (int i = size - 1; i >= 0; --i) {
            List l = (List)allModules.get(i);
            if (l == null) continue;
            for (int j = l.size() - 1; j >= 0; --j) {
                list.add(l.get(j));
            }
        }
        this.tModel.setObjectList(list);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SELECTED_DATE_PROP")) {
            String date = (String)e.getNewValue();
            this.findDate(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String displayOrder(int index) {
        String result = "";
        ModuleModel stamp = (ModuleModel)this.tModel.getObject(index);
        if (stamp != null) {
            IInfoModel model = stamp.getModel();
            try {
                VelocityContext context = GlobalConstants.getVelocityContext();
                context.put("model", (Object)model);
                context.put("stampName", (Object)stamp.getModuleInfo().getStampName());
                context.put("bundleNumber", (Object)((ClaimBundle)model).getBundleNumber());
                context.put("stampStatus", (Object)stamp.getModuleInfo().getStampStatus());
                String templateFile = stamp.getModel().getClass().getName() + ".vm";
                StringWriter sw = new StringWriter();
                BufferedWriter bw = new BufferedWriter(sw);
                InputStream instream = GlobalConstants.getTemplateAsStream(templateFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "SHIFT_JIS"));
                try {
                    Velocity.evaluate((Context)context, (Writer)bw, (String)"stmpHolder", (Reader)reader);
                }
                finally {
                    bw.flush();
                    bw.close();
                    reader.close();
                }
                result = sw.toString();
            }
            catch (Exception e) {
                LogWriter.error(this.getClass(), e);
            }
        }
        return result;
    }

    public void findDate(String date) {
        int size = this.tModel.getDataSize();
        for (int i = 0; i < size; ++i) {
            String rowDate = (String)this.tModel.getValueAt(i, 0);
            if (!rowDate.equals(date)) continue;
            this.table.setRowSelectionInterval(i, i);
            break;
        }
    }
}

