/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import open.dolphin.client.IChart;
import open.dolphin.client.IMenuAdapter;
import open.dolphin.helper.ChartMenuSupport;
import open.dolphin.helper.MainMenuSupport;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class WindowsMenuAdapter
implements IMenuAdapter {
    private MainMenuSupport main;
    private ChartMenuSupport chart;
    private PlugInMenuSupport plugin;
    private JMenuBar menuBar;
    private JPanel toolPanel;
    private ActionMap actionMap;
    private IChart chartContext;

    @Override
    public void setMenuSupports(IChart chartContext, MainMenuSupport main, ChartMenuSupport chart, PlugInMenuSupport plugin) {
        this.chartContext = chartContext;
        this.main = main;
        this.chart = chart;
        this.plugin = plugin;
    }

    @Override
    public JMenuBar getMenuBarProduct() {
        return this.menuBar;
    }

    @Override
    public JPanel getToolPanelProduct() {
        return this.toolPanel;
    }

    @Override
    public ActionMap getActionMap() {
        return this.actionMap;
    }

    @Action
    public void newKarte() {
        this.chart.newKarteCommandExecute();
    }

    @Action
    public void newDocument() {
        this.chart.newDocumentCommandExecute();
    }

    @Action
    public void openKarte() {
        this.main.openKarteCommandExecute();
    }

    @Action
    public void close() {
        this.chart.closeCommandExecute();
    }

    @Action
    public void save() {
        this.chart.saveCommandExecute();
    }

    @Action
    public void delete() {
        this.chart.deleteCommandExecute();
    }

    @Action
    public void direction() {
        this.chart.directionCommandExecute();
    }

    @Action
    public void printerSetup() {
        this.main.printerSetupCommandExecute();
    }

    @Action
    public void print() {
        this.chart.printCommandExecute();
    }

    @Action
    public void processExit() {
        this.main.closeCommandExecute();
    }

    @Action
    public void modifyKarte() {
        this.chart.modifyKarteCommandExecute();
    }

    @Action
    public void undo() {
        this.chart.undoCommandExecute();
    }

    @Action
    public void redo() {
        this.chart.redoCommandExecute();
    }

    @Action
    public void cut() {
        this.chart.cut();
    }

    @Action
    public void copy() {
        this.chart.copy();
    }

    @Action
    public void paste() {
        this.chart.paste();
    }

    @Action
    public void letterPaste() {
        this.chart.letterPasteCommandExecute();
    }

    @Action
    public void letterPasteFromKarte() {
        this.chart.letterPasteFromKarteCommandExecute();
    }

    @Action
    public void quickEdit() {
        this.chart.quickEditExcecute();
    }

    @Action
    public void ascending() {
        this.chart.ascendingCommandExecute();
    }

    @Action
    public void descending() {
        this.chart.descendingCommandExecute();
    }

    @Action
    public void showModified() {
        if (this.isShowModified()) {
            this.chart.showModifiedCommandExecute();
        } else {
            this.chart.hideModifiedCommandExecute();
        }
    }

    @Action
    public void showUnsend() {
        if (this.isShowUnsend()) {
            this.chart.showUnsendCommandExecute();
        } else {
            this.chart.hideUnsendCommandExecute();
        }
    }

    @Action
    public void showSend() {
        if (this.isShowSend()) {
            this.chart.showSendCommandExecute();
        } else {
            this.chart.hideSendCommandExecute();
        }
    }

    @Action
    public void showNewest() {
        if (this.isShowNewest()) {
            this.chart.showNewestCommandExecute();
        } else {
            this.chart.hideNewestCommandExecute();
        }
    }

    @Action
    public void setKarteEnviroment() {
        this.main.setKarteEnviromentCommandExecute();
    }

    @Action
    public void insertDisease() {
    }

    @Action
    public void insertText() {
    }

    @Action
    public void insertSchema() {
    }

    @Action
    public void insertStamp() {
    }

    @Action
    public void selectInsurance() {
    }

    @Action
    public void size() {
    }

    @Action
    public void fontLarger() {
        this.chart.fontLargerCommandExecute();
    }

    @Action
    public void fontSmaller() {
        this.chart.fontSmallerCommandExecute();
    }

    @Action
    public void fontStandard() {
        this.chart.fontStandardCommandExecute();
    }

    @Action
    public void style() {
    }

    @Action
    public void fontBold() {
        this.chart.fontBoldCommandExecute();
    }

    @Action
    public void fontItalic() {
        this.chart.fontItalicCommandExecute();
    }

    @Action
    public void fontUnderline() {
        this.chart.fontUnderlineCommandExecute();
    }

    @Action
    public void justify() {
    }

    @Action
    public void leftJustify() {
        this.chart.leftJustifyCommandExecute();
    }

    @Action
    public void centerJustify() {
        this.chart.centerJustifyCommandExecute();
    }

    @Action
    public void rightJustify() {
        this.chart.rightJustifyCommandExecute();
    }

    @Action
    public void color() {
    }

    @Action
    public void fontRed() {
        this.chart.fontRedCommandExecute();
    }

    @Action
    public void fontOrange() {
        this.chart.fontOrangeCommandExecute();
    }

    @Action
    public void fontYellow() {
        this.chart.fontYellowCommandExecute();
    }

    @Action
    public void fontGreen() {
        this.chart.fontGreenCommandExecute();
    }

    @Action
    public void fontBlue() {
        this.chart.fontBlueCommandExecute();
    }

    @Action
    public void fontPurple() {
        this.chart.fontPurpleCommandExecute();
    }

    @Action
    public void fontGray() {
        this.chart.fontGrayCommandExecute();
    }

    @Action
    public void fontBlack() {
        this.chart.fontBlackCommandExecute();
    }

    @Action
    public void resetStyle() {
        this.chart.resetStyleCommandExecute();
    }

    @Action
    public void showStampBox() {
        this.main.showStampBoxCommandExecute();
    }

    @Action
    public void showSchemaBox() {
        this.main.showSchemaBoxCommandExecute();
    }

    @Action
    public void showTemplateEditor() {
        this.main.showTemplateEditorCommandExecute();
    }

    @Action
    public void changePassword() {
        this.main.changePasswordCommandExecute();
    }

    @Action
    public void addUser() {
        this.main.addUserCommandExecute();
    }

    @Action
    public void browseDolphinSupport() {
        this.main.browseDolphinSupportCommandExecute();
    }

    @Action
    public void browseDolphinProject() {
        this.main.browseDolphinProjectCommandExecute();
    }

    @Action
    public void browseMedXml() {
        this.main.browseMedXmlCommandExecute();
    }

    @Action
    public void showAbout() {
        this.main.showAboutCommandExecute();
    }

    private boolean isShowModified() {
        return this.menuBar.getMenu(2).getItem(2).isSelected();
    }

    private boolean isShowUnsend() {
        return this.menuBar.getMenu(2).getItem(3).isSelected();
    }

    private boolean isShowSend() {
        return this.menuBar.getMenu(2).getItem(4).isSelected();
    }

    private boolean isShowNewest() {
        return this.menuBar.getMenu(2).getItem(6).isSelected();
    }

    @Override
    public void build(JMenuBar menuBar, boolean enabled) {
        this.menuBar = menuBar;
        ApplicationContext ctx = GlobalConstants.getApplicationContext();
        ResourceMap resMap = ctx.getResourceMap(WindowsMenuAdapter.class);
        this.actionMap = ctx.getActionMap((Object)this);
        JToolBar fileBar = null;
        JToolBar editBar = null;
        JToolBar textBar1 = null;
        JToolBar textBar2 = null;
        if (this.chart != null) {
            fileBar = new JToolBar();
            fileBar.setName("fileBar");
            editBar = new JToolBar();
            editBar.setName("editBar");
            textBar1 = new JToolBar();
            textBar1.setName("\u6587\u5b57\u30b5\u30a4\u30ba");
            textBar2 = new JToolBar();
            textBar2.setName("\u6587\u5b57\u5909\u5f62");
            this.toolPanel = new JPanel(new FlowLayout(0));
            this.toolPanel.add(fileBar);
            this.toolPanel.add(editBar);
            this.toolPanel.add(textBar1);
            this.toolPanel.add(textBar2);
        }
        JMenu fileMenu = new JMenu();
        fileMenu.setName("fileMenu");
        JMenuItem newKarte = new JMenuItem();
        newKarte.setName("newKarte");
        newKarte.setAction(this.actionMap.get("newKarte"));
        this.setAccelerator(newKarte, 78);
        fileMenu.add(newKarte);
        if (this.chart != null) {
            JButton newKarteBtn = new JButton();
            newKarteBtn.setAction(this.actionMap.get("newKarte"));
            newKarteBtn.setText(null);
            newKarteBtn.setToolTipText("\u65b0\u3057\u3044\u30ab\u30eb\u30c6\u3092\u4f5c\u6210\u3057\u307e\u3059");
            fileBar.add(newKarteBtn);
        }
        JMenuItem newDocument = new JMenuItem();
        newDocument.setName("newDocument");
        newDocument.setAction(this.actionMap.get("newDocument"));
        fileMenu.add(newDocument);
        if (this.chart != null) {
            JButton newDocBtn = new JButton();
            newDocBtn.setAction(this.actionMap.get("newDocument"));
            newDocBtn.setText(null);
            newDocBtn.setToolTipText("\u65b0\u3057\u3044\u6587\u66f8\u3092\u4f5c\u6210\u3057\u307e\u3059");
            fileBar.add(newDocBtn);
        }
        JMenuItem openKarte = new JMenuItem();
        openKarte.setName("openKarte");
        openKarte.setAction(this.actionMap.get("openKarte"));
        this.setAccelerator(openKarte, 79);
        fileMenu.add(openKarte);
        fileMenu.add(new JSeparator());
        JMenuItem close = new JMenuItem();
        close.setName("close");
        close.setAction(this.actionMap.get("close"));
        this.setAccelerator(close, 87);
        fileMenu.add(close);
        JMenuItem save = new JMenuItem();
        save.setName("save");
        save.setAction(this.actionMap.get("save"));
        this.setAccelerator(save, 83);
        fileMenu.add(save);
        if (this.chart != null) {
            JButton saveBtn = new JButton();
            saveBtn.setAction(this.actionMap.get("save"));
            saveBtn.setText(null);
            saveBtn.setToolTipText("\u4fdd\u5b58\u3057\u307e\u3059");
            fileBar.add(saveBtn);
        }
        fileMenu.add(new JSeparator());
        JMenuItem direction = new JMenuItem();
        direction.setName("direction");
        direction.setAction(this.actionMap.get("direction"));
        direction.setEnabled(enabled);
        fileMenu.add(direction);
        if (this.chart != null) {
            JButton directionBtn = new JButton();
            directionBtn.setAction(this.actionMap.get("direction"));
            directionBtn.setText(null);
            directionBtn.setEnabled(enabled);
            directionBtn.setToolTipText("\u6307\u793a\u7b8b\u5370\u5237");
            fileBar.add(directionBtn);
        }
        fileMenu.add(new JSeparator());
        JMenuItem printerSetup = new JMenuItem();
        printerSetup.setName("printerSetup");
        printerSetup.setAction(this.actionMap.get("printerSetup"));
        fileMenu.add(printerSetup);
        JMenuItem print = new JMenuItem();
        print.setName("print");
        print.setAction(this.actionMap.get("print"));
        this.setAccelerator(print, 80);
        fileMenu.add(print);
        if (this.chart != null) {
            JButton printBtn = new JButton();
            printBtn.setAction(this.actionMap.get("print"));
            printBtn.setText(null);
            printBtn.setToolTipText("\u5370\u5237\u3057\u307e\u3059");
            fileBar.add(printBtn);
        }
        fileMenu.add(new JSeparator());
        JMenuItem exit = new JMenuItem();
        exit.setName("processExit");
        exit.setAction(this.actionMap.get("processExit"));
        fileMenu.add(exit);
        this.setAccelerator(exit, 81);
        JMenu editMenu = new JMenu();
        editMenu.setName("editMenu");
        JMenuItem modifyKarte = new JMenuItem();
        modifyKarte.setName("modifyKarte");
        modifyKarte.setAction(this.actionMap.get("modifyKarte"));
        this.setAccelerator(modifyKarte, 77);
        editMenu.add(modifyKarte);
        if (this.chart != null) {
            JButton modifyKarteBtn = new JButton();
            modifyKarteBtn.setAction(this.actionMap.get("modifyKarte"));
            modifyKarteBtn.setText(null);
            modifyKarteBtn.setToolTipText("\u4fee\u6b63\u3057\u307e\u3059");
            editBar.add(modifyKarteBtn);
        }
        editMenu.add(new JSeparator());
        JMenuItem undo = new JMenuItem();
        undo.setName("undo");
        undo.setAction(this.actionMap.get("undo"));
        this.setAccelerator(undo, 90);
        editMenu.add(undo);
        if (this.chart != null) {
            JButton undoBtn = new JButton();
            undoBtn.setAction(this.actionMap.get("undo"));
            undoBtn.setText(null);
            undoBtn.setToolTipText("\u5143\u306b\u623b\u3057\u307e\u3059");
            editBar.add(undoBtn);
        }
        JMenuItem redo = new JMenuItem();
        redo.setName("redo");
        redo.setAction(this.actionMap.get("redo"));
        this.setAccelerator(redo, 90, true);
        editMenu.add(redo);
        if (this.chart != null) {
            JButton redoBtn = new JButton();
            redoBtn.setAction(this.actionMap.get("redo"));
            redoBtn.setText(null);
            redoBtn.setToolTipText("\u518d\u5b9f\u884c\u3057\u307e\u3059");
            editBar.add(redoBtn);
        }
        editMenu.add(new JSeparator());
        JMenuItem cut = new JMenuItem();
        cut.setName("cut");
        cut.setAction(this.actionMap.get("cut"));
        this.setAccelerator(cut, 88);
        editMenu.add(cut);
        if (this.chart != null) {
            JButton cutBtn = new JButton();
            cutBtn.setAction(this.actionMap.get("cut"));
            cutBtn.setText(null);
            cutBtn.setToolTipText("\u5207\u308a\u53d6\u308a\u307e\u3059");
            editBar.add(cutBtn);
        }
        JMenuItem copy = new JMenuItem();
        copy.setName("copy");
        copy.setAction(this.actionMap.get("copy"));
        this.setAccelerator(copy, 67);
        editMenu.add(copy);
        if (this.chart != null) {
            JButton copyBtn = new JButton();
            copyBtn.setAction(this.actionMap.get("copy"));
            copyBtn.setText(null);
            copyBtn.setToolTipText("\u30b3\u30d4\u30fc\u3057\u307e\u3059");
            editBar.add(copyBtn);
        }
        JMenuItem paste = new JMenuItem();
        paste.setName("paste");
        paste.setAction(this.actionMap.get("paste"));
        this.setAccelerator(paste, 86);
        editMenu.add(paste);
        if (this.chart != null) {
            JButton pasteBtn = new JButton();
            pasteBtn.setAction(this.actionMap.get("paste"));
            pasteBtn.setText(null);
            pasteBtn.setToolTipText("\u8cbc\u308a\u4ed8\u3051\u307e\u3059");
            editBar.add(pasteBtn);
        }
        if (this.chart != null) {
            JButton bigTextBtn = new JButton();
            bigTextBtn.setAction(this.actionMap.get("fontLarger"));
            bigTextBtn.setText("");
            bigTextBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/big.gif")));
            bigTextBtn.setToolTipText("\u6587\u5b57\u3092\u62e1\u5927\u3057\u307e\u3059");
            textBar1.add(bigTextBtn);
            JButton stdTextBtn = new JButton();
            stdTextBtn.setAction(this.actionMap.get("fontStandard"));
            stdTextBtn.setText("");
            stdTextBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/std.gif")));
            stdTextBtn.setToolTipText("\u6587\u5b57\u3092\u6a19\u6e96\u30b5\u30a4\u30ba\u306b\u3057\u307e\u3059");
            textBar1.add(stdTextBtn);
            JButton smlTextBtn = new JButton();
            smlTextBtn.setAction(this.actionMap.get("fontSmaller"));
            smlTextBtn.setText("");
            smlTextBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/sml.gif")));
            smlTextBtn.setToolTipText("\u6587\u5b57\u3092\u7e2e\u5c0f\u3057\u307e\u3059");
            textBar1.add(smlTextBtn);
            JButton bldStyleBtn = new JButton();
            bldStyleBtn.setAction(this.actionMap.get("fontBold"));
            bldStyleBtn.setText("");
            bldStyleBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/bold.png")));
            bldStyleBtn.setToolTipText("\u6587\u5b57\u3092\u592a\u5b57\u306b\u3057\u307e\u3059");
            textBar2.add(bldStyleBtn);
            JButton itkStyleBtn = new JButton();
            itkStyleBtn.setAction(this.actionMap.get("fontItalic"));
            itkStyleBtn.setText("");
            itkStyleBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/italic.png")));
            itkStyleBtn.setToolTipText("\u6587\u5b57\u3092\u30a4\u30bf\u30ea\u30c3\u30af\u306b\u3057\u307e\u3059");
            textBar2.add(itkStyleBtn);
            JButton udlStyleBtn = new JButton();
            udlStyleBtn.setAction(this.actionMap.get("fontUnderline"));
            udlStyleBtn.setText("");
            udlStyleBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/underline.png")));
            udlStyleBtn.setToolTipText("\u6587\u5b57\u306b\u30a2\u30f3\u30c0\u30fc\u30e9\u30a4\u30f3\u3092\u5f15\u304d\u307e\u3059");
            textBar2.add(udlStyleBtn);
            JButton lftLayoutBtn = new JButton();
            lftLayoutBtn.setAction(this.actionMap.get("leftJustify"));
            lftLayoutBtn.setText("");
            lftLayoutBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/left.png")));
            lftLayoutBtn.setToolTipText("\u6587\u5b57\u3092\u5de6\u63c3\u3048\u306b\u3057\u307e\u3059");
            textBar2.add(lftLayoutBtn);
            JButton cntLayoutBtn = new JButton();
            cntLayoutBtn.setAction(this.actionMap.get("centerJustify"));
            cntLayoutBtn.setText("");
            cntLayoutBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/center.png")));
            cntLayoutBtn.setToolTipText("\u6587\u5b57\u3092\u4e2d\u592e\u63c3\u3048\u306b\u3057\u307e\u3059");
            textBar2.add(cntLayoutBtn);
            JButton ritLayoutBtn = new JButton();
            ritLayoutBtn.setAction(this.actionMap.get("rightJustify"));
            ritLayoutBtn.setText("");
            ritLayoutBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/client/resources/right.png")));
            ritLayoutBtn.setToolTipText("\u6587\u5b57\u3092\u53f3\u63c3\u3048\u306b\u3057\u307e\u3059");
            textBar2.add(ritLayoutBtn);
        }
        JMenu karteMenu = new JMenu();
        karteMenu.setName("karteMenu");
        JRadioButtonMenuItem ascending = new JRadioButtonMenuItem();
        ascending.setName("ascending");
        ascending.setAction(this.actionMap.get("ascending"));
        this.actionMap.get("ascending").putValue("menuItem", ascending);
        karteMenu.add(ascending);
        JRadioButtonMenuItem descending = new JRadioButtonMenuItem();
        descending.setName("descending");
        descending.setAction(this.actionMap.get("descending"));
        this.actionMap.get("descending").putValue("menuItem", descending);
        karteMenu.add(descending);
        ButtonGroup bg = new ButtonGroup();
        bg.add(ascending);
        bg.add(descending);
        JCheckBoxMenuItem showModified = new JCheckBoxMenuItem();
        showModified.setSelected(GlobalVariables.getShowModifiedKarte());
        showModified.setName("showModified");
        showModified.setAction(this.actionMap.get("showModified"));
        this.actionMap.get("showModified").putValue("menuItem", showModified);
        karteMenu.add(showModified);
        JCheckBoxMenuItem showUnsend = new JCheckBoxMenuItem();
        showUnsend.setSelected(GlobalVariables.getShowUnsendKarte());
        showUnsend.setName("showUnsend");
        showUnsend.setAction(this.actionMap.get("showUnsend"));
        this.actionMap.get("showUnsend").putValue("menuItem", showUnsend);
        karteMenu.add(showUnsend);
        JCheckBoxMenuItem showSend = new JCheckBoxMenuItem();
        showSend.setSelected(GlobalVariables.getShowSendKarte());
        showSend.setName("showSend");
        showSend.setAction(this.actionMap.get("showSend"));
        this.actionMap.get("showSend").putValue("menuItem", showSend);
        karteMenu.add(showSend);
        karteMenu.add(new JSeparator());
        JCheckBoxMenuItem showNewest = new JCheckBoxMenuItem();
        showNewest.setSelected(GlobalVariables.getShowNewestKarte());
        showNewest.setName("showNewest");
        showNewest.setAction(this.actionMap.get("showNewest"));
        this.actionMap.get("showNewest").putValue("menuItem", showNewest);
        karteMenu.add(showNewest);
        karteMenu.add(new JSeparator());
        JMenuItem setKarteEnviroment = new JMenuItem();
        setKarteEnviroment.setName("setKarteEnviroment");
        setKarteEnviroment.setAction(this.actionMap.get("setKarteEnviroment"));
        this.setAccelerator(setKarteEnviroment, 69);
        karteMenu.add(setKarteEnviroment);
        JMenu insertMenu = new JMenu();
        insertMenu.setName("insertMenu");
        if (this.chart != null) {
            insertMenu.addMenuListener(this.chart);
        }
        JMenu insertDisease = new JMenu();
        insertDisease.setName("insertDisease");
        insertDisease.setAction(this.actionMap.get("insertDisease"));
        insertMenu.add(insertDisease);
        JMenu insertText = new JMenu();
        insertText.setName("insertText");
        insertText.setAction(this.actionMap.get("insertText"));
        insertMenu.add(insertText);
        JMenu insertSchema = new JMenu();
        insertSchema.setName("insertSchema");
        insertSchema.setAction(this.actionMap.get("insertSchema"));
        insertMenu.add(insertSchema);
        JMenu insertStamp = new JMenu();
        insertStamp.setName("insertStamp");
        insertStamp.setAction(this.actionMap.get("insertStamp"));
        insertMenu.add(insertStamp);
        JMenu textMenu = new JMenu();
        textMenu.setName("textMenu");
        if (this.chart != null) {
            textMenu.addMenuListener(this.chart);
        }
        JMenu size = new JMenu();
        size.setName("size");
        size.setAction(this.actionMap.get("size"));
        textMenu.add(size);
        JMenuItem fontLarger = new JMenuItem();
        fontLarger.setName("fontLarger");
        fontLarger.setAction(this.actionMap.get("fontLarger"));
        size.add(fontLarger);
        JMenuItem fontSmaller = new JMenuItem();
        fontSmaller.setName("fontSmaller");
        fontSmaller.setAction(this.actionMap.get("fontSmaller"));
        size.add(fontSmaller);
        JMenuItem fontStandard = new JMenuItem();
        fontStandard.setName("fontStandard");
        fontStandard.setAction(this.actionMap.get("fontStandard"));
        size.add(fontStandard);
        JMenu style = new JMenu();
        style.setName("style");
        style.setAction(this.actionMap.get("style"));
        textMenu.add(style);
        JMenuItem fontBold = new JMenuItem();
        fontBold.setName("fontBold");
        fontBold.setAction(this.actionMap.get("fontBold"));
        this.setAccelerator(fontBold, 66);
        style.add(fontBold);
        JMenuItem fontItalic = new JMenuItem();
        fontItalic.setName("fontItalic");
        fontItalic.setAction(this.actionMap.get("fontItalic"));
        this.setAccelerator(fontItalic, 73);
        style.add(fontItalic);
        JMenuItem fontUnderline = new JMenuItem();
        fontUnderline.setName("fontUnderline");
        fontUnderline.setAction(this.actionMap.get("fontUnderline"));
        this.setAccelerator(fontUnderline, 85);
        style.add(fontUnderline);
        JMenu justify = new JMenu();
        justify.setName("justify");
        justify.setAction(this.actionMap.get("justify"));
        textMenu.add(justify);
        JMenuItem leftJustify = new JMenuItem();
        leftJustify.setName("leftJustify");
        leftJustify.setAction(this.actionMap.get("leftJustify"));
        justify.add(leftJustify);
        JMenuItem centerJustify = new JMenuItem();
        centerJustify.setName("centerJustify");
        centerJustify.setAction(this.actionMap.get("centerJustify"));
        justify.add(centerJustify);
        JMenuItem rightJustify = new JMenuItem();
        rightJustify.setName("rightJustify");
        rightJustify.setAction(this.actionMap.get("rightJustify"));
        justify.add(rightJustify);
        JMenu color = new JMenu();
        color.setName("color");
        color.setAction(this.actionMap.get("color"));
        textMenu.add(color);
        JMenuItem fontRed = new JMenuItem();
        fontRed.setName("fontRed");
        fontRed.setAction(this.actionMap.get("fontRed"));
        color.add(fontRed);
        JMenuItem fontOrange = new JMenuItem();
        fontOrange.setName("fontOrange");
        fontOrange.setAction(this.actionMap.get("fontOrange"));
        color.add(fontOrange);
        JMenuItem fontYellow = new JMenuItem();
        fontYellow.setName("fontYellow");
        fontYellow.setAction(this.actionMap.get("fontYellow"));
        color.add(fontYellow);
        JMenuItem fontGreen = new JMenuItem();
        fontGreen.setName("fontGreen");
        fontGreen.setAction(this.actionMap.get("fontGreen"));
        color.add(fontGreen);
        JMenuItem fontBlue = new JMenuItem();
        fontBlue.setName("fontBlue");
        fontBlue.setAction(this.actionMap.get("fontBlue"));
        color.add(fontBlue);
        JMenuItem fontPurple = new JMenuItem();
        fontPurple.setName("fontPurple");
        fontPurple.setAction(this.actionMap.get("fontPurple"));
        color.add(fontPurple);
        JMenuItem fontGray = new JMenuItem();
        fontGray.setName("fontGray");
        fontGray.setAction(this.actionMap.get("fontGray"));
        color.add(fontGray);
        JMenuItem fontBlack = new JMenuItem();
        fontBlack.setName("fontBlack");
        fontBlack.setAction(this.actionMap.get("fontBlack"));
        color.add(fontBlack);
        JMenu toolMenu = new JMenu();
        toolMenu.setName("toolMenu");
        JMenuItem showStampBox = new JMenuItem();
        showStampBox.setName("showStampBox");
        showStampBox.setAction(this.actionMap.get("showStampBox"));
        toolMenu.add(showStampBox);
        JMenuItem showSchemaBox = new JMenuItem();
        showSchemaBox.setName("showSchemaBox");
        showSchemaBox.setAction(this.actionMap.get("showSchemaBox"));
        toolMenu.add(showSchemaBox);
        toolMenu.add(new JSeparator());
        for (final Map.Entry entry : this.plugin.entrySet()) {
            PluginWrapper pluginWrapper = new PluginWrapper((IPlugin)entry.getValue());
            if (pluginWrapper.getType() != IPlugin.Type.toolmenu) continue;
            JMenuItem menuItem = new JMenuItem();
            menuItem.setName((String)entry.getKey());
            AbstractAction action = new AbstractAction((String)entry.getKey()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginWrapper pluginwrapper = new PluginWrapper((IPlugin)WindowsMenuAdapter.this.plugin.get((String)entry.getKey()));
                    pluginwrapper.execute(WindowsMenuAdapter.this.chartContext);
                }
            };
            menuItem.setAction(action);
            menuItem.setText(pluginWrapper.getReadableName());
            toolMenu.add(menuItem);
        }
        toolMenu.add(new JSeparator());
        JMenuItem changePassword = new JMenuItem();
        changePassword.setName("changePassword");
        changePassword.setAction(this.actionMap.get("changePassword"));
        toolMenu.add(changePassword);
        JMenuItem addUser = new JMenuItem();
        addUser.setName("addUser");
        addUser.setAction(this.actionMap.get("addUser"));
        toolMenu.add(addUser);
        JMenu help = new JMenu();
        help.setName("helpMenu");
        JMenuItem browseDolphinSupport = new JMenuItem();
        browseDolphinSupport.setName("browseDolphinSupport");
        browseDolphinSupport.setAction(this.actionMap.get("browseDolphinSupport"));
        help.add(browseDolphinSupport);
        JMenuItem browseDolphinProject = new JMenuItem();
        browseDolphinProject.setName("browseDolphinProject");
        browseDolphinProject.setAction(this.actionMap.get("browseDolphinProject"));
        help.add(browseDolphinProject);
        JMenuItem browseMedXml = new JMenuItem();
        browseMedXml.setName("browseMedXml");
        browseMedXml.setAction(this.actionMap.get("browseMedXml"));
        help.add(browseMedXml);
        help.add(new JSeparator());
        JMenuItem showAbout = new JMenuItem();
        showAbout.setName("showAbout");
        showAbout.setAction(this.actionMap.get("showAbout"));
        help.add(showAbout);
        menuBar.add((Component)fileMenu, 0);
        menuBar.add((Component)editMenu, 1);
        menuBar.add((Component)karteMenu, 2);
        menuBar.add((Component)insertMenu, 3);
        menuBar.add((Component)textMenu, 4);
        menuBar.add((Component)toolMenu, 5);
        menuBar.add((Component)help, 7);
        resMap.injectComponents((Component)menuBar);
    }

    private void setAccelerator(JMenuItem item, int key) {
        item.setAccelerator(KeyStroke.getKeyStroke(key, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    private void setAccelerator(JMenuItem item, int key, boolean shiftMask) {
        item.setAccelerator(KeyStroke.getKeyStroke(key, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }
}

