/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.tree.TreeNode;
import open.dolphin.client.ImageEntry;
import open.dolphin.client.ImageEntryTransferable;
import open.dolphin.client.KartePane;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.SchemaList;
import open.dolphin.client.SchemaListTransferable;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.log.LogWriter;

public class SOATransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -7891004155072724783L;
    private KartePane soaPane;
    private DataFlavor stringFlavor = DataFlavor.stringFlavor;
    private JTextPane source;
    private boolean shouldRemove;
    Position p0 = null;
    Position p1 = null;

    public SOATransferHandler(KartePane soaPane) {
        this.soaPane = soaPane;
    }

    @Override
    public boolean importData(JComponent c, Transferable tr) {
        JTextPane tc = (JTextPane)c;
        if (!this.canImport(c, tr.getTransferDataFlavors())) {
            return false;
        }
        if (tc.equals(this.source) && tc.getCaretPosition() >= this.p0.getOffset() && tc.getCaretPosition() <= this.p1.getOffset()) {
            this.shouldRemove = false;
            return true;
        }
        try {
            if (tr.isDataFlavorSupported(LocalStampTreeNodeTransferable.localStampTreeNodeFlavor)) {
                this.shouldRemove = false;
                return this.doStampInfoDrop(tr);
            }
            if (tr.isDataFlavorSupported(ImageEntryTransferable.imageEntryFlavor)) {
                return this.doImageEntryDrop(tr);
            }
            if (tr.isDataFlavorSupported(SchemaListTransferable.schemaListFlavor)) {
                return this.doSchemaDrop(tr);
            }
            if (tr.isDataFlavorSupported(this.stringFlavor)) {
                String str = (String)tr.getTransferData(this.stringFlavor);
                tc.replaceSelection(str);
                this.shouldRemove = tc == this.source;
                return true;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            LogWriter.error(this.getClass(), ufe);
        }
        catch (IOException ioe) {
            LogWriter.error(this.getClass(), ioe);
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.source = (JTextPane)c;
        int start = this.source.getSelectionStart();
        int end = this.source.getSelectionEnd();
        Document doc = this.source.getDocument();
        if (start == end) {
            return null;
        }
        try {
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
        }
        catch (BadLocationException e) {
            LogWriter.error(this.getClass(), e);
        }
        String data = this.source.getSelectedText();
        return new StringSelection(data);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        JTextComponent tc = (JTextComponent)c;
        if (tc.isEditable() && this.shouldRemove && action == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException e) {
                LogWriter.error(this.getClass(), e);
            }
        }
        this.shouldRemove = false;
        this.source = null;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        JTextPane tc = (JTextPane)c;
        return tc.isEditable() && this.hasFlavor(flavors);
    }

    protected boolean hasFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (this.stringFlavor.equals(flavor)) {
                return true;
            }
            if (LocalStampTreeNodeTransferable.localStampTreeNodeFlavor.equals(flavor)) {
                return true;
            }
            if (SchemaListTransferable.schemaListFlavor.equals(flavor)) {
                return true;
            }
            if (!ImageEntryTransferable.imageEntryFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    private boolean doStampInfoDrop(Transferable tr) {
        try {
            StampTreeNode droppedNode = (StampTreeNode)tr.getTransferData(LocalStampTreeNodeTransferable.localStampTreeNodeFlavor);
            if (droppedNode.isLeaf()) {
                ModuleInfoBean stampInfo = droppedNode.getStampInfo();
                String role = stampInfo.getStampRole();
                if (role.equals("text")) {
                    this.soaPane.stampInfoDropped(stampInfo);
                } else if (role.equals("soa")) {
                    this.soaPane.stampInfoDropped(stampInfo);
                }
                return true;
            }
            Enumeration<TreeNode> e = droppedNode.preorderEnumeration();
            ArrayList<ModuleInfoBean> addList = new ArrayList<ModuleInfoBean>(5);
            String role = null;
            while (e.hasMoreElements()) {
                ModuleInfoBean stampInfo;
                StampTreeNode node = (StampTreeNode)e.nextElement();
                if (!node.isLeaf() || !(stampInfo = node.getStampInfo()).isSerialized() || stampInfo.getEntity().equals("diagnosis")) continue;
                if (role == null) {
                    role = stampInfo.getStampRole();
                }
                addList.add(stampInfo);
            }
            if (role.equals("text")) {
                this.soaPane.textStampInfoDropped(addList);
            } else if (role.equals("soa")) {
                this.soaPane.stampInfoDropped(addList);
            }
            return true;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return false;
        }
    }

    private boolean doSchemaDrop(Transferable tr) {
        try {
            SchemaList list = (SchemaList)tr.getTransferData(SchemaListTransferable.schemaListFlavor);
            SchemaModel[] schemas = list.schemaList;
            for (int i = 0; i < schemas.length; ++i) {
                this.soaPane.stampSchema(schemas[i]);
            }
            if (this.soaPane.getDraggedCount() > 0 && this.soaPane.getDrragedStamp() != null) {
                this.soaPane.setDroppedCount(schemas.length);
            }
            return true;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return false;
        }
    }

    private boolean doImageEntryDrop(Transferable tr) {
        try {
            ImageEntry entry = (ImageEntry)tr.getTransferData(ImageEntryTransferable.imageEntryFlavor);
            this.soaPane.imageEntryDropped(entry);
            return true;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return false;
        }
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        JTextPane pane;
        super.exportToClipboard(comp, clip, action);
        if (action == 2 && (pane = (JTextPane)comp).isEditable()) {
            pane.replaceSelection("");
        }
    }
}

