/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import open.dolphin.log.LogWriter;

public class MasterRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 4397037194989155042L;
    protected Color beforStartColor;
    protected Color afterEndColor;
    protected Color inUseColor;
    protected String refDate;
    protected static final Color DEFAULT_ODD_COLOR = Color.white;
    protected static final Color DEFAULT_EVENN_COLOR = new Color(237, 243, 254);
    protected Color oddColor;
    protected Color evenColor;

    public MasterRenderer() {
        this.setOpaque(true);
        this.setOddColor(this.oddColor);
        this.setEvenColor(this.evenColor);
        GregorianCalendar gc = new GregorianCalendar();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        this.refDate = f.format(gc.getTime()).toString();
    }

    public MasterRenderer(String refDate) {
        this.refDate = refDate;
    }

    public void setOddColor(Color oddColor) {
        this.oddColor = oddColor;
    }

    public Color getOddColor() {
        return this.oddColor;
    }

    public void setEvenColor(Color evenColor) {
        this.evenColor = evenColor;
    }

    public Color getEvenColor() {
        return this.evenColor;
    }

    public Color getBeforStartColor() {
        return this.beforStartColor;
    }

    public void setBeforStartColor(Color val) {
        this.beforStartColor = val;
    }

    public Color getAfterEndColor() {
        return this.afterEndColor;
    }

    public void setAfterEndColor(Color val) {
        this.afterEndColor = val;
    }

    public Color getInUseColor() {
        return this.inUseColor;
    }

    public void setInUseColor(Color val) {
        this.inUseColor = val;
    }

    public void setColor(JLabel label, String startDate, String endDate) {
        switch (this.useState(startDate, endDate)) {
            case 0: {
                label.setEnabled(false);
                label.setForeground(Color.BLACK);
                break;
            }
            case 1: {
                label.setEnabled(true);
                label.setForeground(Color.BLACK);
                break;
            }
            case 2: {
                label.setEnabled(false);
                label.setForeground(Color.BLACK);
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
    }

    public void setColor(JLabel label, String endDate) {
        this.setColor(label, null, endDate);
    }

    protected int useState(String startDate, String endDate) {
        if (startDate != null && this.refDate.compareTo(startDate) < 0) {
            return 0;
        }
        if (endDate != null && this.refDate.compareTo(endDate) > 0) {
            return 2;
        }
        return 1;
    }
}

