/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IDocumentViewer;
import open.dolphin.client.LetterView;
import open.dolphin.client.PDFLetterMaker;
import open.dolphin.client.PrintablePanel;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.LetterModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.TouTouLetter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;

public class LetterViewer
extends PrintablePanel
implements IDocumentViewer,
IChartDocument,
IChartCommandAccepter {
    public static final String TITLE = "\u7d39\u4ecb\u72b6";
    private StateMgr stateMgr;
    private LetterView view;
    private TouTouLetter model;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "showNewest", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title;
    private boolean dirty;

    public LetterViewer(IChart parent) {
        this.parent = parent;
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.LetterViewer;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case print: {
                return this.print();
            }
        }
        return false;
    }

    @Override
    public void start() {
        this.stateMgr = new StateMgr();
        this.enter();
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
        this.parent.getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        this.stateMgr.enter();
    }

    private boolean print() {
        if (this.model == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PDF\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\u304b?");
        int option = JOptionPane.showOptionDialog(this.getParentContext().getFrame(), sb.toString(), GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u5370\u5237"), -1, 1, null, new String[]{"PDF\u4f5c\u6210", "\u30d5\u30a9\u30fc\u30e0\u5370\u5237", "\u53d6\u6d88\u3057"}, "PDF\u4f5c\u6210");
        if (option == 0) {
            this.makePDF();
        } else if (option == 1) {
            PageFormat pageFormat = this.getParentContext().getContext().getPageFormat();
            String name = this.getParentContext().getPatient().getFullName();
            LetterView panel = this.view;
            panel.printPanel(pageFormat, 1, false, name, 0);
        }
        return true;
    }

    public void makePDF() {
        if (this.model == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PDFLetterMaker pdf = new PDFLetterMaker(GlobalVariables.getLetterGreetings());
                String pdfDir = GlobalVariables.getPreferences().get("pdfStore", System.getProperty("user.dir"));
                pdf.setDocumentDir(pdfDir);
                pdf.setModel(LetterViewer.this.model);
                final boolean result = pdf.create();
                final String fileName = pdf.getFileName();
                final String dir = pdf.getDocumentDir();
                Runnable awt = new Runnable(){

                    @Override
                    public void run() {
                        if (result) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(fileName);
                            sb.append("\u3092");
                            sb.append(System.getProperty("line.separator"));
                            sb.append(dir);
                            sb.append("\u306b\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
                            sb.append(System.getProperty("line.separator"));
                            sb.append("PDF \u30d3\u30e5\u30ef\u30fc\u3092\u8d77\u52d5\u3057\u5370\u5237\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                            JOptionPane.showMessageDialog(LetterViewer.this.getParentContext().getFrame(), sb.toString(), GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u4f5c\u6210"), 1);
                        } else {
                            JOptionPane.showMessageDialog(LetterViewer.this.getParentContext().getFrame(), "\u7d39\u4ecb\u72b6PDF\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002", GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u4f5c\u6210"), 2);
                        }
                    }
                };
                EventQueue.invokeLater(awt);
            }
        };
        Thread t = new Thread(r);
        t.setPriority(5);
        t.start();
    }

    @Override
    public void historyPeriodChanged() {
        this.stateMgr.processEmptyEvent();
    }

    @Override
    public void showDocuments(DocInfoModel[] docs, JScrollPane scroller) {
        if (docs == null || docs.length == 0) {
            this.stateMgr.processEmptyEvent();
            return;
        }
        DocInfoModel docInfo = docs[0];
        long pk = docInfo.getDocPk();
        if (pk == 0L) {
            return;
        }
        LetterGetTask task = new LetterGetTask(this.getParentContext(), pk, scroller);
        task.execute();
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window paerntWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(paerntWindow, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    private void setUnEditableColor(JComponent target) {
        target.setBackground(new Color(227, 250, 207));
        target.setOpaque(true);
    }

    protected final class StateMgr {
        private LetterState emptyState;
        private LetterState cleanState;
        private LetterState currentState;

        public StateMgr() {
            this.emptyState = new EmptyState();
            this.cleanState = new ClaenState();
            this.currentState = this.emptyState;
        }

        public void processEmptyEvent() {
            this.currentState = this.emptyState;
            this.enter();
        }

        public void processCleanEvent() {
            this.currentState = this.cleanState;
            this.enter();
        }

        public void enter() {
            this.currentState.enter();
        }
    }

    protected final class ClaenState
    extends LetterState {
        @Override
        public void enter() {
            boolean canEdit = !LetterViewer.this.isReadOnly();
            LetterViewer.this.getParentContext().enabledAction("newKarte", true);
            LetterViewer.this.getParentContext().enabledAction("newDocument", true);
            LetterViewer.this.getParentContext().enabledAction("modifyKarte", false);
            LetterViewer.this.getParentContext().enabledAction("delete", false);
            LetterViewer.this.getParentContext().enabledAction("print", true);
            LetterViewer.this.getParentContext().enabledAction("direction", true);
            LetterViewer.this.getParentContext().enabledAction("ascending", false);
            LetterViewer.this.getParentContext().enabledAction("descending", false);
            LetterViewer.this.getParentContext().enabledAction("showModified", false);
            LetterViewer.this.getParentContext().enabledAction("showUnsend", false);
            LetterViewer.this.getParentContext().enabledAction("showSend", false);
            LetterViewer.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    protected final class EmptyState
    extends LetterState {
        @Override
        public void enter() {
            boolean canEdit = !LetterViewer.this.isReadOnly();
            LetterViewer.this.getParentContext().enabledAction("newKarte", true);
            LetterViewer.this.getParentContext().enabledAction("newDocument", true);
            LetterViewer.this.getParentContext().enabledAction("modifyKarte", false);
            LetterViewer.this.getParentContext().enabledAction("delete", false);
            LetterViewer.this.getParentContext().enabledAction("print", false);
            LetterViewer.this.getParentContext().enabledAction("direction", false);
            LetterViewer.this.getParentContext().enabledAction("ascending", false);
            LetterViewer.this.getParentContext().enabledAction("descending", false);
            LetterViewer.this.getParentContext().enabledAction("showModified", false);
            LetterViewer.this.getParentContext().enabledAction("showUnsend", false);
            LetterViewer.this.getParentContext().enabledAction("showSend", false);
            LetterViewer.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    protected abstract class LetterState {
        public abstract void enter();
    }

    class LetterGetTask
    extends DBTask<LetterModel> {
        private long letterPk;
        private JScrollPane scroller;

        public LetterGetTask(IChart app, long letterPk, JScrollPane scroller) {
            super(app);
            this.letterPk = letterPk;
            this.scroller = scroller;
        }

        @Override
        protected LetterModel doInBackground() throws Exception {
            RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
            LetterModel letter = ddl.getLetter(this.letterPk);
            if (!ddl.isError()) {
                return letter;
            }
            return null;
        }

        @Override
        protected void succeeded(LetterModel letter) {
            if (letter != null) {
                LetterViewer.this.model = (TouTouLetter)letter;
                LetterViewer.this.view = new LetterView();
                LetterViewer.this.view.getConfirmed().setText(ModelUtils.getDateAsString(LetterViewer.this.model.getConfirmed()));
                LetterViewer.this.view.getCHospital().setText(LetterViewer.this.model.getConsultantHospital());
                LetterViewer.this.view.getCDept().setText(LetterViewer.this.model.getConsultantDept());
                LetterViewer.this.view.getCDoctor().setText(LetterViewer.this.model.getConsultantDoctor());
                LetterViewer.this.view.getPatientName().setText(LetterViewer.this.model.getPatientName());
                LetterViewer.this.view.getPatientName().setText(LetterViewer.this.model.getPatientName());
                LetterViewer.this.view.getPatientGender().setText(LetterViewer.this.model.getPatientGender());
                LetterViewer.this.view.getPatientBirthday().setText(LetterViewer.this.model.getPatientBirthday());
                LetterViewer.this.view.getPatientAge().setText(LetterViewer.this.model.getPatientAge());
                LetterViewer.this.view.getDisease().setText(LetterViewer.this.model.getDisease());
                LetterViewer.this.view.getPurpose().setText(LetterViewer.this.model.getPurpose());
                LetterViewer.this.view.getClinicalCourse().setText(LetterViewer.this.model.getClinicalCourse());
                LetterViewer.this.view.getPastFamily().setText(LetterViewer.this.model.getPastFamily());
                LetterViewer.this.view.getMedication().setText(LetterViewer.this.model.getMedication());
                LetterViewer.this.view.getRemarks().setText(LetterViewer.this.model.getRemarks());
                boolean unEditable = false;
                LetterViewer.this.view.getConfirmed().setEditable(unEditable);
                LetterViewer.this.view.getCHospital().setEditable(unEditable);
                LetterViewer.this.view.getCDept().setEditable(unEditable);
                LetterViewer.this.view.getCDoctor().setEditable(unEditable);
                LetterViewer.this.view.getDisease().setEditable(unEditable);
                LetterViewer.this.view.getPurpose().setEditable(unEditable);
                LetterViewer.this.view.getPastFamily().setEditable(unEditable);
                LetterViewer.this.view.getClinicalCourse().setEditable(unEditable);
                LetterViewer.this.view.getMedication().setEditable(unEditable);
                LetterViewer.this.view.getRemarks().setEditable(unEditable);
                this.scroller.setViewportView(LetterViewer.this.view);
                LetterViewer.this.stateMgr.processCleanEvent();
            }
        }
    }
}

