/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.Dolphin;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IKarteViewer;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.KarteEditor;
import open.dolphin.client.StatusPanel;
import open.dolphin.client.WindowsMenuAdapter;
import open.dolphin.client.karte.DocumentHistoryPanel;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.helper.IMainCommandAccepter;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.helper.WindowSupport;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.Persistent;
import org.jdesktop.application.ResourceMap;

public class EditorFrame
extends JFrame
implements IChart,
IChartCommandAccepter {
    private String name;
    private IMainWindow context;
    private IChart parentChart;
    private IKarteViewer view;
    private KarteEditor editor;
    private JPanel myToolPanel;
    private JScrollPane scroller;
    private StatusPanel statusPanel;
    private EditorMode mode;
    private WindowSupport windowSupport;
    private ChartMediator mediator;
    private BlockGlass blockGlass;
    private ResourceMap resMap;
    private JPanel content;
    private String FKeyword;
    private boolean isActivated;
    private static PageFormat pageFormat = null;

    public EditorFrame(IChart chartCtx, KarteEditor editor) {
        this.initComponents();
        this.parentChart = chartCtx;
        this.context = chartCtx.getContext();
        this.editor = editor;
        this.editor.setParent(this);
        this.context.addEditorFrame(this);
    }

    private Serializable initialBounds() {
        return new Rectangle(5, 20, 724, 740);
    }

    @Override
    public void setKeyword(String keyword) {
        this.FKeyword = keyword;
    }

    @Override
    public IChartDocument getChartDocument(String name) {
        return this.parentChart.getChartDocument(name);
    }

    @Override
    public void setChartDocument(String name, IChartDocument document) {
        this.parentChart.setChartDocument(name, document);
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case save: {
                return this.save();
            }
            case close: {
                return this.close();
            }
            case print: {
                return this.print();
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    @Override
    public void enter() {
    }

    @Override
    public Callable<Boolean> getStartingTask() {
        return null;
    }

    @Override
    public Callable<Boolean> getStoppingTask() {
        return null;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                EditorFrame.this.formWindowActivated(evt);
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                EditorFrame.this.formWindowDeactivated(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (evt.getOppositeWindow() != null) {
            this.isActivated = false;
        }
    }

    private void formWindowActivated(WindowEvent evt) {
        if (evt.getOppositeWindow() != null) {
            this.isActivated = true;
        }
    }

    public IChart getChart() {
        return this.parentChart;
    }

    public void setKarteViewer(IKarteViewer view) {
        this.view = view;
    }

    @Override
    public boolean isActivated() {
        return this.isActivated;
    }

    @Override
    public PatientModel getPatient() {
        return this.parentChart.getPatient();
    }

    @Override
    public KarteBean getKarte() {
        return this.parentChart.getKarte();
    }

    @Override
    public void setKarte(KarteBean karte) {
        this.parentChart.setKarte(karte);
    }

    @Override
    public PatientVisitModel getPatientVisit() {
        return this.parentChart.getPatientVisit();
    }

    @Override
    public void setPatientVisit(PatientVisitModel model) {
        this.parentChart.setPatientVisit(model);
    }

    @Override
    public IChart.state getChartState() {
        return this.parentChart.getChartState();
    }

    @Override
    public void setChartState(IChart.state state2) {
        this.parentChart.setChartState(state2);
    }

    @Override
    public boolean isReadOnly() {
        return this.parentChart.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean b) {
        this.parentChart.setReadOnly(b);
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    @Override
    public StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    @Override
    public void setStatusPanel(StatusPanel statusPanel) {
        this.statusPanel = statusPanel;
    }

    @Override
    public ChartMediator getChartMediator() {
        return this.mediator;
    }

    @Override
    public void enabledAction(String name, boolean enabled) {
        this.mediator.enabledAction(name, enabled);
    }

    @Override
    public DocumentHistoryPanel getDocumentHistory() {
        return this.parentChart.getDocumentHistory();
    }

    @Override
    public void showDocument(String tabName) {
        this.parentChart.showDocument(tabName);
    }

    @Override
    public boolean isDirty() {
        return this.mode == EditorMode.EDITOR ? this.editor.isDirty() : false;
    }

    @Override
    public PVTHealthInsuranceModel[] getHealthInsurances() {
        return this.parentChart.getHealthInsurances();
    }

    @Override
    public void start() {
        this.initialize();
    }

    private String getWindowTitle() {
        String karteStr = this.resMap.getString("karteStr", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPatient().getFullName());
        sb.append("(");
        String kana = this.getPatient().getKanaName();
        kana = kana.replace("\u3000", " ");
        sb.append(kana);
        sb.append(") : ");
        sb.append(this.getPatient().getPatientId());
        sb.append(karteStr);
        sb.append(" | ").append(GlobalVariables.getUserId());
        sb.append(" | ").append(GlobalVariables.getUserModel().getLicenseModel().getLicenseDesc());
        return sb.toString();
    }

    private void initialize() {
        this.resMap = GlobalConstants.getResourceMap(EditorFrame.class);
        this.windowSupport = WindowSupport.create(this, this.getWindowTitle());
        JMenuBar myMenuBar = this.windowSupport.getMenuBar();
        this.setName("editorFrame");
        this.content = new JPanel(new BorderLayout());
        this.mediator = new ChartMediator(this);
        WindowsMenuAdapter appMenu = new WindowsMenuAdapter();
        appMenu.setMenuSupports(this.parentChart, this.parentChart.getContext().getMenuSupport(), this.mediator, this.parentChart.getContext().getPlugin());
        appMenu.build(myMenuBar, true);
        this.mediator.registerActions(appMenu.getActionMap());
        this.myToolPanel = appMenu.getToolPanelProduct();
        this.content.add((Component)this.myToolPanel, "North");
        JToolBar toolBar = new JToolBar();
        this.myToolPanel.add(toolBar);
        Action action = this.mediator.getActions().get("insertText");
        JButton textBtn = new JButton();
        textBtn.setName("textBtn");
        textBtn.setAction(action);
        textBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                EditorFrame.this.mediator.addTextMenu(popup);
                if (!e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        toolBar.add(textBtn);
        action = this.mediator.getActions().get("insertSchema");
        JButton schemaBtn = new JButton();
        schemaBtn.setName("schemaBtn");
        schemaBtn.setAction(action);
        schemaBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorFrame.this.getContext().dispatchMainCommand(IMainCommandAccepter.MainCommand.showSchemaBox);
            }
        });
        toolBar.add(schemaBtn);
        action = this.mediator.getActions().get("insertStamp");
        JButton stampBtn = new JButton();
        stampBtn.setName("stampBtn");
        stampBtn.setAction(action);
        stampBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                EditorFrame.this.mediator.addStampMenu(popup);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        toolBar.add(stampBtn);
        this.statusPanel = new StatusPanel();
        if (this.view != null) {
            this.mode = EditorMode.BROWSER;
            this.view.start();
            this.scroller = new JScrollPane((JPanel)((Object)this.view));
            this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
            this.enabledAction("newDocument", false);
            this.scroller.getVerticalScrollBar().setUnitIncrement(GlobalSettings.karteScrollUnitIncrement());
        } else if (this.editor != null) {
            this.mode = EditorMode.EDITOR;
            this.editor.initialize();
            this.editor.start();
            this.enabledAction("newKarte", false);
            this.enabledAction("newDocument", false);
            this.enabledAction("save", false);
        }
        this.content.add((Component)this.editor, "Center");
        this.getContentPane().setLayout(new BorderLayout(0, 7));
        this.getContentPane().add((Component)this.content, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.resMap.injectComponents((Component)this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                EditorFrame.this.processWindowOpened();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                EditorFrame.this.processWindowClosing();
            }
        });
        this.blockGlass = new BlockGlass();
        this.setGlassPane(this.blockGlass);
        this.setBounds((Rectangle)Persistent.loadLayout(this.getClass().getName(), "layout", this.initialBounds()));
        this.setVisible(true);
        Runnable awt = new Runnable(){

            @Override
            public void run() {
                if (EditorFrame.this.view != null) {
                    ((JPanel)((Object)EditorFrame.this.view)).scrollRectToVisible(new Rectangle(0, 0, ((JPanel)((Object)EditorFrame.this.view)).getWidth(), 50));
                } else if (EditorFrame.this.editor != null) {
                    EditorFrame.this.editor.scrollRectToVisible(new Rectangle(0, 0, EditorFrame.this.editor.getWidth(), 50));
                }
            }
        };
        EventQueue.invokeLater(awt);
    }

    @Override
    public void stop() {
        this.mediator.dispose();
        this.context.removeEditorFrame(this);
        Persistent.saveLayout(this.getClass().getName(), "layout", this.getBounds());
        this.setVisible(false);
        this.dispose();
    }

    public boolean save() {
        this.editor.save();
        return true;
    }

    private void processWindowClosing() {
        this.close();
    }

    private void processWindowOpened() {
        Dolphin.getStampBox().getFrame().setVisible(true);
    }

    private PageFormat getPageFormat() {
        return this.parentChart.getContext().getPageFormat();
    }

    private boolean print() {
        switch (this.mode) {
            case BROWSER: {
                if (this.view == null) break;
                this.view.printPanel2(this.getPageFormat());
                break;
            }
            case EDITOR: {
                if (this.editor == null) break;
                this.editor.printPanel2(this.getPageFormat());
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
        return true;
    }

    @Override
    public boolean close() {
        if (this.mode == EditorMode.EDITOR) {
            if (this.editor.isDirty()) {
                String save = this.resMap.getString("unsavedtask.saveText", new Object[0]);
                String discard = this.resMap.getString("unsavedtask.discardText", new Object[0]);
                String question = this.resMap.getString("unsavedtask.question", new Object[0]);
                String title = this.resMap.getString("unsavedtask.title", new Object[0]);
                String cancelText = (String)UIManager.get("OptionPane.cancelButtonText");
                int option = JOptionPane.showOptionDialog(this, question, GlobalConstants.getFrameTitle(title), -1, 3, null, new String[]{save, discard, cancelText}, save);
                switch (option) {
                    case 0: {
                        this.editor.dispatchChartCommand(IChartCommandAccepter.ChartCommand.save);
                        break;
                    }
                    case 1: {
                        this.enabledAction("modifyKarte", true);
                        this.enabledAction("newDocument", true);
                        this.enabledAction("direction", false);
                        this.stop();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        LogWriter.fatal(this.getClass(), "case default");
                        break;
                    }
                }
            } else {
                this.enabledAction("modifyKarte", true);
                this.enabledAction("newDocument", true);
                this.enabledAction("direction", false);
                this.stop();
            }
        } else {
            this.enabledAction("modifyKarte", true);
            this.enabledAction("newDocument", true);
            this.enabledAction("direction", false);
            this.stop();
        }
        this.parentChart.enabledAction("newKarte", true);
        this.parentChart.enabledAction("newDocument", true);
        return true;
    }

    @Override
    public void closeChartDocument(String label, IChartDocument document) {
    }

    @Override
    public PlugInMenuSupport getPlugins() {
        return this.context.getPlugin();
    }

    static {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (printJob != null && pageFormat == null) {
            pageFormat = printJob.defaultPage();
        }
    }

    public static enum EditorMode {
        BROWSER,
        EDITOR;

    }
}

