/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.KartePane;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;

public abstract class AbstractCodeHelper {
    private static final String[] WORD_SEPARATOR = new String[]{" ", " ", "\u3001", "\u3002", "\n", "\t"};
    protected static final Icon icon = GlobalConstants.getImageIcon("foldr_16.gif");
    private JTextPane textPane;
    private int MODIFIER;
    private int start;
    private int end;
    protected ChartMediator mediator;
    protected JPopupMenu popup;
    protected Pattern pattern;

    protected AbstractCodeHelper(KartePane kartePane, ChartMediator mediator) {
        this.mediator = mediator;
        this.textPane = kartePane.getTextPane();
        Preferences prefs = Preferences.userNodeForPackage(AbstractCodeHelper.class);
        String modifier = prefs.get("modifier", "ctrl");
        if (modifier.equals("ctrl")) {
            this.MODIFIER = 128;
        } else if (modifier.equals("meta")) {
            this.MODIFIER = 256;
        }
        this.textPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    if (e.getModifiersEx() == AbstractCodeHelper.this.MODIFIER && e.getKeyCode() == 32) {
                        AbstractCodeHelper.this.buildAndShowPopup();
                    }
                }
                catch (BadLocationException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
            }
        });
    }

    protected abstract void buildPopup(String var1);

    protected void buildEntityPopup(String entity) {
        StampBoxFrame stampBox = this.mediator.getStampBox();
        StampTree tree = stampBox.getStampTree(entity);
        if (tree != null) {
            this.popup = new JPopupMenu();
            HashMap<DefaultMutableTreeNode, JComponent> ht = new HashMap<DefaultMutableTreeNode, JComponent>(5, 0.75f);
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
            ht.put(rootNode, this.popup);
            Enumeration<TreeNode> e = rootNode.preorderEnumeration();
            if (e != null) {
                e.nextElement();
                while (e.hasMoreElements()) {
                    JComponent parent;
                    StampTreeNode node = (StampTreeNode)e.nextElement();
                    if (!node.isLeaf()) {
                        JComponent parent2;
                        JMenu subMenu = new JMenu(node.getUserObject().toString());
                        if (node.getParent() == rootNode) {
                            parent2 = (JPopupMenu)ht.get(node.getParent());
                            ((JPopupMenu)parent2).add(subMenu);
                        } else {
                            parent2 = (JMenu)ht.get(node.getParent());
                            ((JMenu)parent2).add(subMenu);
                        }
                        ht.put(node, subMenu);
                        JMenuItem item = new JMenuItem(node.getUserObject().toString());
                        item.setIcon(icon);
                        subMenu.add(item);
                        this.addActionListner(item, node);
                        continue;
                    }
                    if (!node.isLeaf()) continue;
                    ModuleInfoBean info = (ModuleInfoBean)node.getUserObject();
                    String stampName = info.getStampName();
                    JMenuItem item = new JMenuItem(stampName);
                    this.addActionListner(item, node);
                    if (node.getParent() == rootNode) {
                        parent = (JPopupMenu)ht.get(node.getParent());
                        ((JPopupMenu)parent).add(item);
                        continue;
                    }
                    parent = (JMenu)ht.get(node.getParent());
                    ((JMenu)parent).add(item);
                }
            }
        }
    }

    protected void addActionListner(JMenuItem item, final StampTreeNode node) {
        ActionListener ral = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCodeHelper.this.importStamp(AbstractCodeHelper.this.textPane, AbstractCodeHelper.this.textPane.getTransferHandler(), new LocalStampTreeNodeTransferable(node));
            }
        };
        item.addActionListener(ral);
    }

    private void showPopup() throws BadLocationException {
        if (this.popup == null || this.popup.getComponentCount() < 1) {
            return;
        }
        int pos = this.textPane.getCaretPosition();
        Rectangle r = this.textPane.modelToView(pos);
        this.popup.show(this.textPane, r.x, r.y);
    }

    private void importStamp(JComponent comp, TransferHandler handler, LocalStampTreeNodeTransferable tr) {
        this.textPane.setSelectionStart(this.start);
        this.textPane.setSelectionEnd(this.end);
        this.textPane.replaceSelection("");
        handler.importData(comp, tr);
        this.closePopup();
    }

    private void closePopup() {
        if (this.popup != null) {
            this.popup.removeAll();
            this.popup = null;
        }
    }

    private void buildAndShowPopup() throws BadLocationException {
        String str;
        this.start = this.end = this.textPane.getCaretPosition();
        boolean found = false;
        while (this.start > 0) {
            --this.start;
            String text = this.textPane.getText(this.start, 1);
            for (String test : WORD_SEPARATOR) {
                if (!test.equals(text)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            ++this.start;
            break;
        }
        if ((str = this.textPane.getText(this.start, this.end - this.start)).length() > 0) {
            this.buildPopup(str);
            this.showPopup();
        }
    }
}

