/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.Series;
import org.dcm4cheri.srom.RefSOPImpl;

class SeriesImpl
implements Series {
    private final String modality;
    private final String seriesInstanceUID;
    private final int seriesNumber;
    private final RefSOP refStudyComponent;

    public SeriesImpl(String modality, String seriesInstanceUID, int seriesNumber, RefSOP refStudyComponent) {
        if (modality.length() == 0) {
            throw new IllegalArgumentException(modality);
        }
        if (seriesInstanceUID.length() == 0) {
            throw new IllegalArgumentException(seriesInstanceUID);
        }
        this.modality = modality;
        this.seriesInstanceUID = seriesInstanceUID;
        this.seriesNumber = seriesNumber;
        this.refStudyComponent = refStudyComponent;
    }

    public SeriesImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(524384), ds.getString(0x20000E), ds.getInt(0x200011, -1), RefSOPImpl.newRefSOP(ds.getItem(528657)));
    }

    public String getModality() {
        return this.modality;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    public RefSOP getRefStudyComponent() {
        return this.refStudyComponent;
    }

    public int hashCode() {
        return this.seriesInstanceUID.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Series)) {
            return false;
        }
        Series ser = (Series)o;
        return this.seriesInstanceUID.equals(ser.getSeriesInstanceUID());
    }

    public String toString() {
        return "Series[" + this.seriesInstanceUID + ",#" + this.seriesNumber + ",PPS=" + this.refStudyComponent + "]";
    }

    public void toDataset(Dataset ds) {
        ds.putCS(524384, this.modality);
        ds.putUI(0x20000E, this.seriesInstanceUID);
        ds.putIS(0x200011, this.seriesNumber);
        DcmElement sq = ds.putSQ(528657);
        if (this.refStudyComponent != null) {
            this.refStudyComponent.toDataset(sq.addNewItem());
        }
    }
}

