/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.auditlog;

import java.net.InetAddress;
import java.net.Socket;
import org.dcm4che.auditlog.RemoteNode;

class RemoteNodeImpl
implements RemoteNode {
    private String ip;
    private String hname;
    private String aet;

    public RemoteNodeImpl(String ip, String hname, String aet) {
        this.ip = ip;
        this.hname = hname;
        this.aet = aet;
    }

    public RemoteNodeImpl(Socket s, String aet, boolean disableHostLookup) {
        InetAddress addr = s.getInetAddress();
        this.ip = addr.getHostAddress();
        if (!disableHostLookup) {
            this.hname = this.toHname(addr.getHostName());
        }
        this.aet = aet;
    }

    public final String getAET() {
        return this.aet;
    }

    public final String getHostName() {
        return this.hname;
    }

    public final String getIP() {
        return this.ip;
    }

    private final String toHname(String name) {
        if (Character.isDigit(name.charAt(0))) {
            return null;
        }
        int pos = name.indexOf(46);
        return pos == -1 ? name : name.substring(0, pos);
    }

    public void writeTo(StringBuffer sb) {
        sb.append("<IP>").append(this.ip).append("</IP>");
        if (this.hname != null) {
            sb.append("<Hname>").append(this.hname).append("</Hname>");
        }
        if (this.aet != null) {
            sb.append("<AET><![CDATA[").append(this.aet).append("]]></AET>");
        }
    }
}

